/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.interaction.query;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.ode.bpe.interaction.query.NodeDescriptor;

public class XPathParser
implements Serializable {
    static final long serialVersionUID = -8922198154683798177L;
    private LinkedList m_nodeDescriptors = null;
    private String m_expression = null;
    private HashMap m_uriMap = null;
    private int m_expressionLength;
    private int m_currentIndex;
    private boolean m_parseActive;
    static final int QUOTE = 34;
    static final int TICK = 39;
    static final int LEFT_BRACKET = 91;
    static final int RIGHT_BRACKET = 93;
    static final int COLON = 58;
    static final int FORWARD_SLASH = 47;

    public XPathParser() {
    }

    public XPathParser(HashMap iURIMap, String iXPathExpression) {
        this.setURIMap(iURIMap);
        this.setXPathExpression(iXPathExpression);
    }

    private synchronized void parseExpression() {
        if (this.m_nodeDescriptors != null) {
            return;
        }
        this.m_expressionLength = this.m_expression.length();
        this.m_currentIndex = 0;
        this.m_parseActive = true;
        this.m_nodeDescriptors = new LinkedList();
        while (this.m_parseActive && this.m_currentIndex < this.m_expressionLength) {
            this.parseNodeDescriptor();
        }
        this.m_parseActive = false;
    }

    private void parseNodeDescriptor() {
        int startIndex = this.m_currentIndex;
        int stopIndex = 0;
        while (true) {
            int closeIndex;
            if (this.m_currentIndex >= this.m_expressionLength) {
                stopIndex = this.m_expressionLength;
                break;
            }
            char currentChar = this.m_expression.charAt(this.m_currentIndex);
            if (currentChar == '\"' || currentChar == '\'') {
                closeIndex = this.m_expression.indexOf(currentChar, this.m_currentIndex + 1);
                if (closeIndex >= 0) {
                    this.m_currentIndex = closeIndex + 1;
                    continue;
                }
                this.m_parseActive = false;
                break;
            }
            if (currentChar == '[') {
                closeIndex = this.m_expression.indexOf(93, this.m_currentIndex + 1);
                if (closeIndex >= 0) {
                    this.m_currentIndex = closeIndex + 1;
                    continue;
                }
                this.m_parseActive = false;
                break;
            }
            if (currentChar == '/') {
                stopIndex = this.m_currentIndex++;
                break;
            }
            ++this.m_currentIndex;
        }
        String nodeDescriptorString = this.m_expression.substring(startIndex, stopIndex);
        if (nodeDescriptorString.length() > 0) {
            this.addNodeDescriptor(nodeDescriptorString);
        }
    }

    private void addNodeDescriptor(String iDescriptorString) {
        NodeDescriptor nodeDescriptor = new NodeDescriptor(this.getURIMap(), iDescriptorString);
        this.m_nodeDescriptors.addLast(nodeDescriptor);
    }

    public void setXPathExpression(String iExpression) {
        this.m_expression = iExpression;
    }

    public String getXPathExpression() {
        return this.m_expression;
    }

    public void setURIMap(HashMap iHashMap) {
        this.m_uriMap = iHashMap;
    }

    public HashMap getURIMap() {
        return this.m_uriMap;
    }

    public void dump(OutputStream iOutputStream) {
        PrintStream printStream = new PrintStream(iOutputStream);
        printStream.println("XPathExpression = " + this.m_expression);
        printStream.println("Node Descriptors:");
        Iterator iter = this.getNodeDescriptors().iterator();
        int count = 0;
        while (iter.hasNext()) {
            NodeDescriptor nodeDescriptor = (NodeDescriptor)iter.next();
            printStream.println(++count + ")");
            nodeDescriptor.dump(iOutputStream);
        }
    }

    public LinkedList getNodeDescriptors() {
        if (this.m_nodeDescriptors == null) {
            this.parseExpression();
        }
        return this.m_nodeDescriptors;
    }
}

