/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.scope.service.impl;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.bpel.TimerAction;
import org.apache.ode.bpe.context.IContainer;
import org.apache.ode.bpe.context.IContextService;
import org.apache.ode.bpe.context.IPart;
import org.apache.ode.bpe.context.resolver.ContextResolvedObject;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.correlation.CorrelationService;
import org.apache.ode.bpe.correlation.Registration;
import org.apache.ode.bpe.definition.IPMDLocator;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.engine.ProcessInstance;
import org.apache.ode.bpe.engine.StateEnum;
import org.apache.ode.bpe.event.StateEvent;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.instance.service.InstanceService;
import org.apache.ode.bpe.lang.ResourceGetter;
import org.apache.ode.bpe.scope.service.BPRuntimeException;
import org.apache.ode.bpe.scope.service.IFCScopeInstance;
import org.apache.ode.bpe.scope.service.ScopePath;
import org.apache.ode.bpe.timerservice.BPETimerServiceFactory;
import org.apache.ode.bpe.timerservice.IBPETimer;
import org.apache.ode.bpe.timerservice.IBPETimerService;
import org.apache.ode.bpe.util.BPException;

public class FCScopeInstanceImpl
implements IFCScopeInstance,
Serializable {
    static final long serialVersionUID = -810005833715560330L;
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$scope$service$impl$FCScopeInstanceImpl == null ? (class$org$apache$ode$bpe$scope$service$impl$FCScopeInstanceImpl = FCScopeInstanceImpl.class$("org.apache.ode.bpe.scope.service.impl.FCScopeInstanceImpl")) : class$org$apache$ode$bpe$scope$service$impl$FCScopeInstanceImpl).getName());
    private ScopePath scopePath;
    private boolean active = true;
    private boolean faulted = false;
    private boolean compensated = false;
    private HashMap faultsByName = new HashMap();
    private HashMap faultsByType = new HashMap();
    private HashMap faultsByNameType = new HashMap();
    private String faultObserver;
    private String compensationHandler;
    private String compenstationCtxId;
    private String ctxId;
    private ArrayList receives = new ArrayList();
    private ArrayList timers = new ArrayList();
    private HashSet procs = new HashSet();
    private FCScopeInstanceImpl parentScope;
    private HashMap childrenScopes = new HashMap();
    private ArrayList completedChildrenScopes = new ArrayList();
    private HashMap allScopes;
    private transient TimerAction act;
    private transient ContextResolver resolver;
    private ScopePath _sp;
    private boolean executingFaultHandler = false;
    static /* synthetic */ Class class$org$apache$ode$bpe$scope$service$impl$FCScopeInstanceImpl;

    protected FCScopeInstanceImpl() {
        this.allScopes = new HashMap();
        this.scopePath = new ScopePath();
        this.allScopes.put(this.scopePath.toString(), this);
    }

    private FCScopeInstanceImpl(ScopePath scopePath, String newScopeName, String newScopeId, String ctxId, FCScopeInstanceImpl parentScope, HashMap allScopes) {
        try {
            this.scopePath = (ScopePath)scopePath.clone();
        }
        catch (CloneNotSupportedException e) {
            this.scopePath = scopePath;
        }
        this.ctxId = ctxId;
        this.scopePath.addScope(newScopeName, newScopeId);
        this.parentScope = parentScope;
        parentScope.addChildScope(this);
        this.allScopes = allScopes;
        this.allScopes.put(this.scopePath.toString(), this);
    }

    protected FCScopeInstanceImpl getParentScope() {
        return this.parentScope;
    }

    protected List getCompletedChildrenScopes() {
        return this.completedChildrenScopes;
    }

    private void addChildScope(FCScopeInstanceImpl childScope) {
        this.childrenScopes.put(childScope.getScopePath().toString(), childScope);
    }

    private void addCompletedChiledScope(FCScopeInstanceImpl scope) {
        this.completedChildrenScopes.add(scope);
    }

    protected IFCScopeInstance getScope(ScopePath scopePath) {
        return (IFCScopeInstance)this.allScopes.get(scopePath.toString());
    }

    protected HashMap getScopes() {
        return this.allScopes;
    }

    public IFCScopeInstance createScope(String newScopeName, String newScopeId, String ctxId) throws BPException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Creating new " + newScopeName + newScopeId + " scope in: " + this.scopePath);
        }
        return new FCScopeInstanceImpl(this.scopePath, newScopeName, newScopeId, ctxId, this, this.allScopes);
    }

    public void addFaultHandler(String faultName, String faultType, String defintionId) throws BPException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding fault handler for scope:" + this.scopePath + " name: " + faultName + " faultType: " + faultType + " defid: " + defintionId);
        }
        if (faultName != null) {
            this.faultsByName.put(faultName, defintionId);
        }
        if (faultType != null) {
            this.faultsByType.put(faultType, defintionId);
        }
        if (faultType != null && faultName != null) {
            this.faultsByNameType.put(faultName + faultType, defintionId);
        }
    }

    public void setFaultHandlerObserver(String defintionId) throws BPException {
        this.faultObserver = defintionId;
    }

    public void setCompensationHandler(String defintionId, List locators, ContextResolver resolver, String ctxId) throws BPException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Creating compensation snap shot for " + this.scopePath + " defid :" + defintionId + " snap shot context: " + ctxId);
        }
        this.compensationHandler = defintionId;
        this.compenstationCtxId = ctxId;
        IContextService cs = resolver.getContextService();
        IContainer rootCont = cs.getRoot();
        IContainer snapShot = rootCont.createContainer(this.compenstationCtxId);
        Iterator it = locators.iterator();
        while (it.hasNext()) {
            IPMDLocator loc = (IPMDLocator)it.next();
            String[] path = this.scopePath.applyPathIdsToPath(loc.getPath()).split("/");
            IContainer cont = snapShot;
            for (int i = 1; i < path.length - 1; ++i) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Created snap shot container(" + this.compenstationCtxId + "):" + path[i]);
                }
                cont = cont.createContainer(path[i]);
            }
            ContextResolvedObject from = (ContextResolvedObject)resolver.resolveWithOutInvocation(loc);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Copying snap shot part(" + this.compenstationCtxId + "):" + path[path.length - 1]);
            }
            cont.copyNode(from.getContextNode(), path[path.length - 1]);
        }
    }

    public void setInactive(IPMIProcess proc, IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        if (this.active) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Deactivating scope:" + this.scopePath);
            }
            this.active = false;
            this.cleanUp(pcb);
            if (this.parentScope != null) {
                this.parentScope.addCompletedChiledScope(this);
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isFaulted() {
        return this.faulted;
    }

    public boolean isCompensated() {
        return this.compensated;
    }

    public void addRegistration(Registration registration) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding registration for scope:" + this.scopePath + " registration: " + registration);
        }
        this.receives.add(registration);
    }

    public void addTimer(IBPETimer timer) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding timer for scope:" + this.scopePath + " timer: " + timer);
        }
        this.timers.add(timer);
    }

    public ScopePath getScopePath() {
        return this.scopePath;
    }

    private String getFaultHandler(String faultName, String faultType, Throwable t) {
        String faultHandler = null;
        if (faultType == null) {
            if (faultName != null) {
                faultHandler = (String)this.faultsByName.get(faultName);
            }
        } else {
            if (faultName != null && faultType != null) {
                faultHandler = (String)this.faultsByNameType.get(faultName + faultType);
            }
            if (faultHandler == null) {
                if (faultName != null) {
                    faultHandler = (String)this.faultsByName.get(faultName);
                }
                if (faultHandler == null && faultType != null) {
                    faultHandler = (String)this.faultsByType.get(faultType);
                }
            }
        }
        if (faultHandler == null && faultName != "http://schemas.xmlsoap.org/ws/2003/03/business-process/:forcedTermination" && (faultHandler = (String)this.faultsByName.get("catchAll")) != null && faultName == null && faultType == null && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, ResourceGetter.getString("NON_BPEL_CATCHALL"), t);
        }
        return faultHandler;
    }

    private void executeProcess(String procId, IPMIProcess proc, IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        IPMDProcess def = ec.getProcessService().getInstanceService().getDefinitionService().getProcessDefintion(new ProcessDefinitionKey(procId), proc.getDefinition().getRootKey());
        ProcessInstance pi = ec.getProcessService().createSubProcess(proc, def);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Executing process:" + pi.getKey() + "(Parent:" + proc.getKey() + ")");
        }
        pi.processEvent(new StateEvent(pi.getRootKey(), pi.getKey(), StateEnum.STARTED), ec, pcb);
    }

    private void reThrow(Throwable t) throws BPException {
        if (t instanceof BPException) {
            throw (BPException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleFault(Throwable exception, IPMIProcess proc, IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        String faultHandler;
        if (this.executingFaultHandler) {
            proc.setExecutionContext("faultHandler");
        }
        if (this._sp != null) {
            proc.setScopePath(this._sp);
            ScopePath esp = this._sp.getEnclosingScopePath();
            while (this.parentScope != null && !esp.equals(this.parentScope.getScopePath())) {
                this.parentScope = this.parentScope.parentScope;
            }
            this._sp = null;
        }
        if (proc.getExecutionContext().equals("faultHandler")) {
            if (this.parentScope != null && !this.parentScope.scopePath.getCurrentScope().equals("")) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Fault thrown from fault handler, passing fault to parent scope:" + this.parentScope.getScopePath());
                }
                proc.setScopePath(this.parentScope.getScopePath());
                proc.setExecutionContext("process");
                this.parentScope.handleFault(exception, proc, ec, pcb);
                return;
            } else {
                this.reThrow(exception);
            }
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Handling fault " + exception.toString() + " in scope:" + this.scopePath);
        }
        Iterator it = this.childrenScopes.values().iterator();
        while (it.hasNext()) {
            IFCScopeInstance scope = (IFCScopeInstance)it.next();
            if (!scope.isActive()) continue;
            scope.terminate(proc, ec, pcb);
        }
        if (this.faulted) return;
        this.faulted = true;
        String faultName = null;
        String faultType = null;
        if (exception instanceof BPRuntimeException) {
            BPRuntimeException brpe = (BPRuntimeException)exception;
            if (brpe.getMessageParts().size() > 0) {
                IContextService cs = ec.getProcessService().getContextService(proc.getRootKey());
                IContainer rootCont = cs.getRoot();
                IContainer globalCont = rootCont.createContainer(proc.getContextContainerId());
                IContainer faultCont = globalCont.createContainer("currentFault");
                Iterator itrPart = brpe.getMessageParts().entrySet().iterator();
                while (itrPart.hasNext()) {
                    Map.Entry me = itrPart.next();
                    IPart faultPart = faultCont.createPart((String)me.getKey());
                    faultPart.setObject(me.getValue());
                }
            }
            faultName = brpe.getNameSpace() + ":" + brpe.getName();
            faultType = brpe.getType();
        }
        if ((faultHandler = this.getFaultHandler(faultName, faultType, exception)) != null) {
            proc.setContextContaionerId(this.ctxId);
            proc.setExecutionContext("faultHandler");
            this.executingFaultHandler = true;
            this.executeProcess(faultHandler, proc, ec, pcb);
            proc.setExecutionContext("process");
            if (this.faultObserver == null) return;
            this.executeProcess(this.faultObserver, proc, ec, pcb);
            return;
        } else {
            this.compensate(proc, ec, pcb);
            if (this.parentScope != null && !this.parentScope.scopePath.getCurrentScope().equals("")) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Re throwing fault to scope:" + this.parentScope.getScopePath());
                }
                proc.setScopePath(this.parentScope.getScopePath());
                this.parentScope.handleFault(exception, proc, ec, pcb);
                return;
            } else {
                this.reThrow(exception);
            }
        }
    }

    private void cleanUp(IProcessCallBack pcb) throws BPException {
        IBPETimerService ts = BPETimerServiceFactory.getBPETimerService();
        Iterator it = ((AbstractList)this.timers).iterator();
        while (it.hasNext()) {
            IBPETimer timer = (IBPETimer)it.next();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Canceling timer in scope:" + this.scopePath + " timer: " + timer);
            }
            ts.removeTimer(timer);
        }
        CorrelationService cs = pcb.getCorrelationService();
        it = ((AbstractList)this.receives).iterator();
        while (it.hasNext()) {
            Registration reg = (Registration)it.next();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Removing registration in scope:" + this.scopePath + " registration: " + reg);
            }
            cs.removeRegistration(reg);
        }
        InstanceService is = pcb.getCorrelationService().getProcessService().getInstanceService();
        it = this.procs.iterator();
        while (it.hasNext()) {
            IPMIProcess proc = (IPMIProcess)it.next();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Removing process in scope:" + this.scopePath + " process: " + proc.getKey());
            }
            is.getInstance(proc.getRootKey(), proc.getKey()).remove();
        }
        this.timers.clear();
        this.receives.clear();
        this.procs.clear();
    }

    public void terminate(IPMIProcess proc, IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        if (this.active) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Terminating scope:" + this.scopePath);
            }
            this.active = false;
            Iterator it = this.childrenScopes.values().iterator();
            while (it.hasNext()) {
                IFCScopeInstance scope = (IFCScopeInstance)it.next();
                if (!scope.isActive()) continue;
                scope.terminate(proc, ec, pcb);
            }
            this.cleanUp(pcb);
            String forcedTermination = this.getFaultHandler("http://schemas.xmlsoap.org/ws/2003/03/business-process/:forcedTermination", null, null);
            if (forcedTermination != null) {
                this.executeProcess(forcedTermination, proc, ec, pcb);
            } else {
                this.compensate(proc, ec, pcb);
            }
        }
    }

    public void compensate(IPMIProcess proc, IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        if (this.compensated) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Scope has already been compensated:" + this.scopePath);
            }
            return;
        }
        if (this.compensationHandler != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Compensating scope:" + this.scopePath);
            }
            this._sp = proc.getScopePath();
            proc.setScopePath(this.scopePath);
            this.compensated = true;
            String saveCtxId = proc.getContextContainerId();
            proc.setContextContaionerId(this.compenstationCtxId);
            this.executeProcess(this.compensationHandler, proc, ec, pcb);
            proc.setContextContaionerId(saveCtxId);
            proc.setScopePath(this._sp);
            this._sp = null;
        } else {
            for (int i = this.completedChildrenScopes.size(); i > 0; --i) {
                IFCScopeInstance scope = (IFCScopeInstance)this.completedChildrenScopes.get(i - 1);
                scope.compensate(proc, ec, pcb);
            }
        }
    }

    public void removeRegistration(Registration registration) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Removing registration from scope:" + this.scopePath + " registration: " + registration);
        }
        this.receives.remove(registration);
    }

    public void removeTimer(IBPETimer timer) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Canceling timer in scope:" + this.scopePath + " timer: " + timer);
        }
        this.timers.remove(timer);
    }

    public void addProcess(IPMIProcess proc) {
        this.procs.add(proc);
    }

    public String toString() {
        return this.scopePath.toString();
    }

    public void setTimerAction(TimerAction act, ContextResolver resolver) {
        this.act = act;
        this.resolver = resolver;
    }

    public void executeTimerAction(IEvaluationContext ec, IProcessCallBack pcb, IPMIProcess processInstance, IPMDProcess processDefinition) throws BPException {
        if (this.act != null) {
            this.act.execute(this.resolver, ec, pcb, processInstance, processDefinition);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

