/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class ObjectInputStreamContextClassLoader
extends ObjectInputStream {
    ClassLoader cl = Thread.currentThread().getContextClassLoader();

    public ObjectInputStreamContextClassLoader(InputStream in) throws IOException {
        super(in);
    }

    protected Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        return this.cl.loadClass(osc.getName());
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] interfacesClass = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfacesClass[i] = Class.forName(interfaces[i], false, this.cl);
        }
        return Proxy.getProxyClass(this.cl, interfacesClass);
    }
}

