/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.uuid.connector;

import java.io.PrintWriter;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.apache.ode.bpe.pool.ObjPoolObject;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.uuid.UUIDService;
import org.apache.ode.bpe.uuid.connector.UUIDConnection;
import org.apache.ode.bpe.uuid.connector.UUIDEventListener;
import org.apache.ode.bpe.uuid.connector.UUIDManagedConnectionMetadata;
import org.apache.ode.bpe.uuid.connector.UUIDNotSupportedException;
import org.apache.ode.bpe.uuid.connector.UUIDResourceException;
import org.apache.ode.bpe.uuid.connector.service.UUIDServiceFactory;

public class UUIDManagedConnection
implements ManagedConnection,
ObjPoolObject {
    private UUIDEventListener listener = new UUIDEventListener(this);
    private PrintWriter logWriter;
    private boolean destroyed = false;
    private UUIDService service;
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$uuid$connector$UUIDManagedConnection == null ? (class$org$apache$ode$bpe$uuid$connector$UUIDManagedConnection = UUIDManagedConnection.class$("org.apache.ode.bpe.uuid.connector.UUIDManagedConnection")) : class$org$apache$ode$bpe$uuid$connector$UUIDManagedConnection).getName());
    static /* synthetic */ Class class$org$apache$ode$bpe$uuid$connector$UUIDManagedConnection;

    public UUIDManagedConnection(Subject subject, ConnectionRequestInfo info, BPEProperties props) {
        try {
            this.service = UUIDServiceFactory.createUUIDService(props);
        }
        catch (UUIDResourceException e) {
            // empty catch block
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        return new UUIDConnection(this);
    }

    public void destroy() throws ResourceException {
        this.destroyed = true;
    }

    public void cleanup() throws ResourceException {
    }

    public void associateConnection(Object connection) throws ResourceException {
        throw new UUIDNotSupportedException(logger, "UUID_NOT_SUPPORTED", new Object[]{"associateConnection"});
    }

    public void addConnectionEventListener(ConnectionEventListener eventListener) {
        this.listener.addConnectorListener(eventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener eventListener) {
        this.listener.removeConnectorListener(eventListener);
    }

    public XAResource getXAResource() throws ResourceException {
        throw new UUIDNotSupportedException(logger, "UUID_NOT_SUPPORTED", new Object[]{"getXAResource()"});
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new UUIDNotSupportedException(logger, "UUID_NOT_SUPPORTED", new Object[]{"getLocalTransaction()"});
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (this.destroyed) {
            throw new IllegalStateException();
        }
        return new UUIDManagedConnectionMetadata();
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        if (this.destroyed) {
            throw new IllegalStateException();
        }
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (this.destroyed) {
            throw new IllegalStateException();
        }
        return this.logWriter;
    }

    void sendEvent(int eventType, Exception ex, Object connectionHandle) {
        this.listener.sendEvent(eventType, ex, connectionHandle);
    }

    String getUUID() throws ResourceException {
        return this.service.getUUID();
    }

    public void afterObjPoolObjectCheckin() {
    }

    public void beforeObjPoolObjectCheckout() {
    }

    public void deleteObjPoolObject() {
    }

    public boolean isObjPoolObjectValid() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

