/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.action.bpel;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.internal.ActionException;
import org.apache.ode.bpe.action.internal.IInternalAction;
import org.apache.ode.bpe.context.IContainer;
import org.apache.ode.bpe.context.IContextService;
import org.apache.ode.bpe.context.IPart;
import org.apache.ode.bpe.context.resolver.ContextResolvedObject;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.correlation.keys.CorrelationKeysUtil;
import org.apache.ode.bpe.definition.IPMDLocator;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.event.IRequestMessageEvent;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.interaction.IInteraction;
import org.apache.ode.bpe.lang.ResourceGetter;
import org.apache.ode.bpe.scope.service.IFCScopeInstance;
import org.apache.ode.bpe.scope.service.IScopeService;
import org.apache.ode.bpe.util.BPException;

public class ReceiveAction
implements IInternalAction {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$action$bpel$ReceiveAction == null ? (class$org$apache$ode$bpe$action$bpel$ReceiveAction = ReceiveAction.class$("org.apache.ode.bpe.action.bpel.ReceiveAction")) : class$org$apache$ode$bpe$action$bpel$ReceiveAction).getName());
    public static final String PARTNER_LINK = "partner_link";
    public static final String OOB_DATA = "<OOB";
    private Properties props;
    private ArrayList operations;
    private String partnerLink;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$ReceiveAction;

    public void init(Properties properties) throws ActionException {
        this.props = properties;
        this.operations = (ArrayList)((Hashtable)this.props).get("operations");
        this.partnerLink = this.props.getProperty(PARTNER_LINK);
    }

    public boolean execute(ContextResolver resolver, IEvaluationContext ec, IProcessCallBack pcb, IPMIProcess processInstance, IPMDProcess processDefinition) throws BPException {
        IRequestMessageEvent me = pcb.getMessageEvent();
        if (me == null) {
            ActionException bpx = new ActionException("ACT_NO_ME", null);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        IInteraction obj = me.getPart(OOB_DATA);
        if (obj != null) {
            IContextService cs = resolver.getContextService();
            IContainer root = cs.getRoot();
            IContainer procroot = (IContainer)root.findChild(processInstance.getRootKey());
            IPart partnerLinkPart = (IPart)procroot.findChild(this.partnerLink);
            if (partnerLinkPart == null) {
                partnerLinkPart = procroot.createPart(this.partnerLink);
            }
            partnerLinkPart.setObject(obj);
        }
        Iterator it = resolver.getLocatorHolder().getLocators();
        while (it.hasNext()) {
            IPMDLocator loc = (IPMDLocator)it.next();
            String name = loc.getName();
            String[] name_split = name.split(":");
            if (name_split.length <= 1) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding message part:" + name_split[1] + " to " + loc.getPath());
            }
            ContextResolvedObject ro = (ContextResolvedObject)resolver.resolveBPContext(name);
            IInteraction part = me.getPart(name_split[1]);
            if (part == null && name_split[1].compareTo("tns") != 0) {
                logger.warning(ResourceGetter.getFormatted("ACT_NO_ME_PART", new Object[]{name_split[1]}));
            }
            ro.setObject(part);
        }
        if (this.operations != null) {
            CorrelationKeysUtil.setCorrelationKeys(resolver, pcb.getMessageEvent().getParts(), this.operations, null);
        }
        IScopeService ss = resolver.getScopeService();
        IFCScopeInstance scope = ss.getScope(processInstance.getScopePath());
        scope.executeTimerAction(ec, pcb, processInstance, processDefinition);
        return true;
    }

    public void release() {
        this.props = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

