/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.action.bpel;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.internal.ActionException;
import org.apache.ode.bpe.action.internal.IInternalAction;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.correlation.CorrelationService;
import org.apache.ode.bpe.correlation.CorrelationServiceException;
import org.apache.ode.bpe.correlation.PartQuery;
import org.apache.ode.bpe.correlation.Registration;
import org.apache.ode.bpe.correlation.keys.CorrelationKeysUtil;
import org.apache.ode.bpe.definition.IPMDCorrelation;
import org.apache.ode.bpe.definition.IPMDCorrelationSet;
import org.apache.ode.bpe.definition.IPMDOperation;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.event.BPELStaticKey;
import org.apache.ode.bpe.event.IStaticKey;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.scope.service.IFCScopeInstance;
import org.apache.ode.bpe.scope.service.IScopeService;
import org.apache.ode.bpe.util.BPException;

public class RegisterAction
implements IInternalAction {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$action$bpel$RegisterAction == null ? (class$org$apache$ode$bpe$action$bpel$RegisterAction = RegisterAction.class$("org.apache.ode.bpe.action.bpel.RegisterAction")) : class$org$apache$ode$bpe$action$bpel$RegisterAction).getName());
    private Properties props;
    public static final String OPERATIONS = "operations";
    public static final String BLOCK = "block";
    public static final String DEP_OPERATIONS = "dependent_operations";
    public static final String CORRELATION_NOT_INITALIZED = "correlationSetNotInitalized";
    private ArrayList operations;
    private Boolean blocking;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$RegisterAction;

    public void init(Properties properties) throws ActionException {
        this.props = properties;
        this.operations = (ArrayList)((Hashtable)this.props).get(OPERATIONS);
        this.blocking = (Boolean)((Hashtable)properties).get(BLOCK);
    }

    public boolean execute(ContextResolver resolver, IEvaluationContext ec, IProcessCallBack pcb, IPMIProcess processInstance, IPMDProcess processDefinition) throws BPException {
        CorrelationService cs = pcb.getCorrelationService();
        Iterator it1 = ((AbstractList)this.operations).iterator();
        boolean matched = false;
        boolean removeProc = false;
        while (it1.hasNext()) {
            Object obj;
            PartQuery pq;
            Iterator pqit;
            IPMDCorrelationSet corrls;
            String dynamicKeyValue;
            IPMDOperation op = (IPMDOperation)it1.next();
            IStaticKey staticKeyValue = op.getKey();
            IPMDCorrelation correlation = op.getCorrelation();
            String opId = op.getOperationId();
            Registration reg = cs.getRegistration(staticKeyValue, opId, processInstance.getRootKey());
            if (reg == null && correlation == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Creating Static Registration for " + ((Object)staticKeyValue).toString());
                }
                removeProc = this.createRegistration(cs, resolver, op, processInstance, processDefinition, null);
                continue;
            }
            if (reg == null && correlation != null) {
                Iterator csIt = correlation.getCorrelationSets().iterator();
                boolean init = false;
                dynamicKeyValue = "";
                block1: while (csIt.hasNext()) {
                    corrls = (IPMDCorrelationSet)csIt.next();
                    pqit = corrls.getPartQueries().iterator();
                    while (pqit.hasNext()) {
                        pq = (PartQuery)pqit.next();
                        obj = resolver.resolveBPContext(pq.getLocatorName()).getValue();
                        if (obj == null && !corrls.isInstantiating()) {
                            throw new BPException(CORRELATION_NOT_INITALIZED, null);
                        }
                        if (obj == null) continue block1;
                        dynamicKeyValue = dynamicKeyValue + obj.toString();
                        init = true;
                    }
                }
                if (init) {
                    removeProc = this.createRegistration(cs, resolver, op, processInstance, processDefinition, dynamicKeyValue);
                    continue;
                }
                removeProc = this.createRegistration(cs, resolver, op, processInstance, processDefinition, null);
                continue;
            }
            if (reg != null && correlation == null) {
                matched = true;
                continue;
            }
            if (reg == null || correlation == null) continue;
            matched = true;
            ArrayList<IPMDOperation> ops = new ArrayList<IPMDOperation>();
            ops.add(op);
            if (!CorrelationKeysUtil.setCorrelationKeys(resolver, pcb.getMessageEvent().getParts(), ops, null)) continue;
            RegisterAction.removeRegistration(reg, cs, processInstance, resolver);
            Iterator csIt = correlation.getCorrelationSets().iterator();
            dynamicKeyValue = "";
            while (csIt.hasNext()) {
                corrls = (IPMDCorrelationSet)csIt.next();
                pqit = corrls.getPartQueries().iterator();
                while (pqit.hasNext() && (obj = resolver.resolveBPContext((pq = (PartQuery)pqit.next()).getLocatorName()).getValue()) != null) {
                    dynamicKeyValue = dynamicKeyValue + obj.toString();
                }
            }
            removeProc = this.createRegistration(cs, resolver, op, processInstance, processDefinition, dynamicKeyValue);
        }
        if (removeProc) {
            ec.setDeadProcess(true);
        }
        if (matched) {
            return this.blocking == null || this.blocking == false;
        }
        return this.blocking != null && this.blocking == false;
    }

    public void release() {
        this.props = null;
    }

    protected static void removeRegistration(Registration reg, CorrelationService cs, IPMIProcess proc, ContextResolver resolver) throws BPException {
        IScopeService ss = resolver.getScopeService();
        IFCScopeInstance scope = ss.getScope(proc.getScopePath());
        scope.removeRegistration(reg);
        if (reg != null) {
            cs.removeRegistration(reg);
        }
    }

    private boolean createRegistration(CorrelationService cs, ContextResolver resolver, IPMDOperation op, IPMIProcess proc, IPMDProcess def, String keyValue) throws BPException {
        if (cs.isBPELCompliant()) {
            Collection c;
            if (keyValue == null) {
                c = cs.getRegistrations(op.getKey());
            } else {
                ArrayList<String> al = new ArrayList<String>();
                al.add(keyValue);
                c = cs.getRegistrations(op.getKey(), al);
            }
            if (c.size() > 0) {
                BPELStaticKey key = (BPELStaticKey)op.getKey();
                CorrelationServiceException cse = new CorrelationServiceException("ACT_REG_BPEL_COMP", new Object[]{key.getTargetNamespace(), key.getPortType(), key.getOperation(), keyValue});
                logger.log(Level.SEVERE, "", cse);
                throw cse;
            }
        }
        Registration reg = new Registration(((Object)op.getKey()).toString(), op.getOperationId(), def.getRootKey().getValue(), op.getDefId(), proc.getRootKey(), proc.getKey(), keyValue);
        cs.createRegistration(reg);
        IScopeService ss = resolver.getScopeService();
        IFCScopeInstance scope = ss.getScope(proc.getScopePath());
        scope.addRegistration(reg);
        if (op.getDefId() != null) {
            scope.addProcess(proc);
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

