/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.action.bpel;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.ode.bpe.action.bpel.JaxenUtil;
import org.apache.ode.bpe.action.bpel.UnInitVariableMetaData;
import org.apache.ode.bpe.action.bpel.XPathJaxenExpression;
import org.apache.ode.bpe.action.internal.IInternalAction;
import org.apache.ode.bpe.bped.EventDirectorException;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.engine.ProcessInstance;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.util.BPException;

public class StartSequenceAction
implements IInternalAction {
    public static final String START_DEF_KEY = "START_DEF_KEY";
    public static final String END_DEF_KEY = "END_DEF_KEY";
    public static final String JOIN_EXPRESSION_KEY = "JoinExpression";
    public static final String SUPPRESS_KEY = "SuppressJoinFault";
    public static final String UNINITVAR_KEY = "UNINITVAR";
    private ProcessDefinitionKey startKey;
    private ProcessDefinitionKey endKey;
    private UnInitVariableMetaData varExcept;
    private XPathJaxenExpression m_joinExpression;
    private Boolean m_suppressJoinFault;

    public void init(Properties properties) throws BPException {
        this.startKey = (ProcessDefinitionKey)((Hashtable)properties).get(START_DEF_KEY);
        this.endKey = (ProcessDefinitionKey)((Hashtable)properties).get(END_DEF_KEY);
        if (properties != null && ((Hashtable)properties).get(JOIN_EXPRESSION_KEY) != null) {
            this.m_joinExpression = (XPathJaxenExpression)((Hashtable)properties).get(JOIN_EXPRESSION_KEY);
            this.m_suppressJoinFault = (Boolean)((Hashtable)properties).get(SUPPRESS_KEY);
            this.m_joinExpression.getExpressionTree();
        }
        if (((Hashtable)properties).get(UNINITVAR_KEY) != null) {
            this.varExcept = (UnInitVariableMetaData)((Hashtable)properties).get(UNINITVAR_KEY);
        }
    }

    public boolean execute(ContextResolver resolver, IEvaluationContext ec, IProcessCallBack pcb, IPMIProcess processInstance, IPMDProcess processDefinition) throws BPException {
        boolean joinResult = true;
        if (this.m_joinExpression == null || (joinResult = JaxenUtil.evalBool(resolver, this.m_joinExpression, this.varExcept)) || !this.m_suppressJoinFault.booleanValue()) {
            // empty if block
        }
        if (joinResult) {
            this.startProcess(this.startKey, ec, pcb, processDefinition, processInstance);
        } else {
            this.startProcess(this.endKey, ec, pcb, processDefinition, processInstance);
        }
        return true;
    }

    public void release() {
    }

    private void startProcess(ProcessDefinitionKey key, IEvaluationContext ec, IProcessCallBack pcb, IPMDProcess pd, IPMIProcess pi) throws EventDirectorException, BPException {
        DefinitionService ds = ec.getProcessService().getInstanceService().getDefinitionService();
        IPMDProcess startProcDef = ds.getProcessDefintion(key, pd.getRootKey());
        ProcessInstance startProcInst = ec.getProcessService().createSubProcess(pi, startProcDef);
        ec.addProcessInstance(startProcInst);
    }
}

