/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.action.bpel;

import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.axis.types.Duration;
import org.apache.ode.bpe.action.bpel.JaxenUtil;
import org.apache.ode.bpe.action.bpel.UnInitVariableMetaData;
import org.apache.ode.bpe.action.bpel.XPathJaxenExpression;
import org.apache.ode.bpe.action.internal.ActionException;
import org.apache.ode.bpe.action.internal.IInternalAction;
import org.apache.ode.bpe.context.resolver.ContextResolvedObject;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.event.ITimerEvent;
import org.apache.ode.bpe.event.TimerEvent;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.scope.service.IFCScopeInstance;
import org.apache.ode.bpe.scope.service.IScopeService;
import org.apache.ode.bpe.timerservice.BPETimerServiceFactory;
import org.apache.ode.bpe.timerservice.IBPETimer;
import org.apache.ode.bpe.timerservice.IBPETimerService;
import org.apache.ode.bpe.util.BPException;
import org.relaxng.datatype.DatatypeException;

public class TimerAction
implements IInternalAction {
    public static final String DEADLINE = "deadline";
    public static final String DURATION = "duration";
    public static final String BLOCK = "block";
    public static final String DEFINITION = "definition";
    public static final String TIMER_ACTION_LOCATOR_KEY = "timerActionLocatorKey";
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$action$bpel$TimerAction == null ? (class$org$apache$ode$bpe$action$bpel$TimerAction = TimerAction.class$("org.apache.ode.bpe.action.bpel.TimerAction")) : class$org$apache$ode$bpe$action$bpel$TimerAction).getName());
    private XPathJaxenExpression deadlineExp;
    private XPathJaxenExpression durationExp;
    private UnInitVariableMetaData varMetadata;
    private boolean block = true;
    private boolean notSupported = false;
    private IBPETimerService ts;
    private String defId;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$TimerAction;

    public void init(Properties properties) throws ActionException {
        if (((Hashtable)properties).containsKey(DEADLINE)) {
            this.deadlineExp = (XPathJaxenExpression)((Hashtable)properties).get(DEADLINE);
        } else if (((Hashtable)properties).containsKey(DURATION)) {
            this.durationExp = (XPathJaxenExpression)((Hashtable)properties).get(DURATION);
        }
        this.varMetadata = (UnInitVariableMetaData)((Hashtable)properties).get("UNITVAR");
        if (this.varMetadata == null) {
            throw new ActionException("NULL_PROP", new Object[]{"UNITVAR", (class$org$apache$ode$bpe$action$bpel$TimerAction == null ? (class$org$apache$ode$bpe$action$bpel$TimerAction = TimerAction.class$("org.apache.ode.bpe.action.bpel.TimerAction")) : class$org$apache$ode$bpe$action$bpel$TimerAction).getName()}, null);
        }
        if (((Hashtable)properties).containsKey(BLOCK)) {
            this.block = (Boolean)((Hashtable)properties).get(BLOCK);
        }
        if (((Hashtable)properties).containsKey(DEFINITION)) {
            this.defId = properties.getProperty(DEFINITION);
        }
        try {
            this.ts = BPETimerServiceFactory.getBPETimerService();
            if (this.ts == null) {
                this.notSupported = true;
            }
        }
        catch (BPException e) {
            ActionException bpx = new ActionException("NATIVE_EXCEPTION", new Object[]{"BPException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
    }

    public boolean execute(ContextResolver resolver, IEvaluationContext ec, IProcessCallBack pcb, IPMIProcess processInstance, IPMDProcess processDefinition) throws BPException {
        boolean retValue = false;
        if (this.notSupported) {
            logger.severe("TIMER NOT SUPPORTED");
            return true;
        }
        ContextResolvedObject timerStarted = (ContextResolvedObject)resolver.resolveBPContext(TIMER_ACTION_LOCATOR_KEY);
        if (timerStarted.getValue() != null) {
            retValue = true;
        } else {
            IScopeService ss = resolver.getScopeService();
            IFCScopeInstance scope = ss.getScope(processInstance.getScopePath());
            String deadline = null;
            String duration = null;
            try {
                if (this.deadlineExp != null) {
                    deadline = JaxenUtil.evalString(resolver, this.deadlineExp, this.varMetadata);
                }
                if (this.durationExp != null) {
                    duration = JaxenUtil.evalString(resolver, this.durationExp, this.varMetadata);
                }
            }
            catch (BPException e) {
                if (scope.getScopePath().getEnclosingScopePath().toString().equals("/")) {
                    scope.setTimerAction(this, resolver);
                    return true;
                }
                throw e;
            }
            Date startTime = null;
            if (deadline != null) {
                Calendar calendar;
                block17: {
                    try {
                        XSDatatype dt = DatatypeFactory.getTypeByName((String)"dateTime");
                        if (dt.isValid(deadline, null)) {
                            calendar = (Calendar)dt.createJavaObject(deadline, null);
                            break block17;
                        }
                        dt = DatatypeFactory.getTypeByName((String)"date");
                        if (dt.isValid(deadline, null)) {
                            calendar = (Calendar)dt.createJavaObject(deadline, null);
                            break block17;
                        }
                        throw new ActionException("TIME_PARSE", new Object[]{deadline});
                    }
                    catch (DatatypeException e) {
                        ActionException bpx = new ActionException("NATIVE_EXCEPTION", new Object[]{"DatatypeException"}, e);
                        bpx.log(logger, Level.SEVERE);
                        throw bpx;
                    }
                }
                startTime = calendar.getTime();
            }
            if (duration != null) {
                Duration dur = new Duration(duration);
                GregorianCalendar currentCalendar = new GregorianCalendar();
                ((Calendar)currentCalendar).add(1, dur.getYears());
                ((Calendar)currentCalendar).add(2, dur.getMonths());
                ((Calendar)currentCalendar).add(5, dur.getDays());
                ((Calendar)currentCalendar).add(10, dur.getHours());
                ((Calendar)currentCalendar).add(12, dur.getMinutes());
                ((Calendar)currentCalendar).add(13, (int)dur.getSeconds());
                startTime = currentCalendar.getTime();
            }
            if (startTime == null) {
                throw new ActionException("TIME_NOT_SET");
            }
            TimerEvent timerEvent = new TimerEvent(processInstance.getRootKey().toString(), processInstance.getKey(), processDefinition.getRootKey().getValue(), this.defId);
            IBPETimer timer = this.ts.createTimer(startTime, (ITimerEvent)timerEvent);
            timerStarted.setObject(new Boolean(true));
            scope.addTimer(timer);
            if (this.block) {
                retValue = false;
            } else {
                ec.setDeadProcess(true);
                scope.addProcess(processInstance);
                retValue = true;
            }
        }
        return retValue;
    }

    public void release() {
        this.deadlineExp = null;
        this.durationExp = null;
        this.varMetadata = null;
        this.defId = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

