/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.action.bpel;

import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.bpel.JaxenUtil;
import org.apache.ode.bpe.action.bpel.UnInitVariableMetaData;
import org.apache.ode.bpe.action.bpel.XPathSwitchTuple;
import org.apache.ode.bpe.action.internal.ActionException;
import org.apache.ode.bpe.action.internal.IInternalAction;
import org.apache.ode.bpe.bped.EventDirectorException;
import org.apache.ode.bpe.bped.IInternalEventDirector;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.engine.ProcessInstance;
import org.apache.ode.bpe.engine.StateEnum;
import org.apache.ode.bpe.event.StateEvent;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.scope.service.BPRuntimeException;
import org.apache.ode.bpe.util.BPException;

public class XPathSwitchAction
implements IInternalAction {
    public static final String CASES_KEY = "CASES";
    public static final String THREAD_KEY = "WithNewThread";
    public static final String DEFAULT_KEY = "DEFAULT";
    public static final String UNINITVAR_KEY = "UNINITVAR";
    private Vector cases;
    private ProcessDefinitionKey defaultKey;
    private boolean newThread = false;
    private UnInitVariableMetaData varExcept;
    protected static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$action$bpel$XPathSwitchAction == null ? (class$org$apache$ode$bpe$action$bpel$XPathSwitchAction = XPathSwitchAction.class$("org.apache.ode.bpe.action.bpel.XPathSwitchAction")) : class$org$apache$ode$bpe$action$bpel$XPathSwitchAction).getName());
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$XPathSwitchAction;

    public void init(Properties properties) throws BPException {
        this.cases = (Vector)((Hashtable)properties).get(CASES_KEY);
        this.defaultKey = (ProcessDefinitionKey)((Hashtable)properties).get(DEFAULT_KEY);
        if (properties.getProperty(THREAD_KEY) != null) {
            this.newThread = true;
        }
        if (this.cases != null) {
            Iterator itr = ((AbstractList)this.cases).iterator();
            while (itr.hasNext()) {
                ((XPathSwitchTuple)itr.next()).getExpression().getExpressionTree();
            }
        }
        if (((Hashtable)properties).get(UNINITVAR_KEY) == null) {
            throw new ActionException("NULL_PROP", new Object[]{UNINITVAR_KEY, (class$org$apache$ode$bpe$action$bpel$XPathSwitchAction == null ? (class$org$apache$ode$bpe$action$bpel$XPathSwitchAction = XPathSwitchAction.class$("org.apache.ode.bpe.action.bpel.XPathSwitchAction")) : class$org$apache$ode$bpe$action$bpel$XPathSwitchAction).getName()}, null);
        }
        this.varExcept = (UnInitVariableMetaData)((Hashtable)properties).get(UNINITVAR_KEY);
    }

    public boolean execute(ContextResolver resolver, IEvaluationContext ec, IProcessCallBack pcb, IPMIProcess processInstance, IPMDProcess processDefinition) throws BPException {
        boolean defaultFlag = this.defaultKey != null;
        try {
            Iterator i = ((AbstractList)this.cases).iterator();
            while (i.hasNext()) {
                XPathSwitchTuple st = (XPathSwitchTuple)i.next();
                if (!JaxenUtil.evalBool(resolver, st.getExpression(), this.varExcept)) continue;
                this.startProcess(st.getKey(), ec, pcb, processDefinition, processInstance);
                defaultFlag = false;
                break;
            }
        }
        catch (BPRuntimeException bpe) {
            logger.log(Level.SEVERE, bpe.getLocalizedMessage(), bpe);
            BPRuntimeException bpe1 = new BPRuntimeException(bpe.getName(), "SINGLE_RULE_ERROR", new Object[]{processDefinition.getRoot().getLabel(), processDefinition.getRoot().getKey().getValue(), processDefinition.getLabel()});
            bpe1.setNameSpace(bpe.getNameSpace());
            throw bpe1;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            throw new BPException("SINGLE_RULE_ERROR", new Object[]{processDefinition.getRoot().getLabel(), processDefinition.getRoot().getKey().getValue(), processDefinition.getLabel()}, e);
        }
        if (defaultFlag) {
            this.startProcess(this.defaultKey, ec, pcb, processDefinition, processInstance);
        }
        return true;
    }

    public void release() {
    }

    private void startProcess(ProcessDefinitionKey key, IEvaluationContext ec, IProcessCallBack pcb, IPMDProcess pd, IPMIProcess pi) throws EventDirectorException, BPException {
        DefinitionService ds = ec.getProcessService().getInstanceService().getDefinitionService();
        IPMDProcess startProcDef = ds.getProcessDefintion(key, pd.getRootKey());
        ProcessInstance startProcInst = ec.getProcessService().createSubProcess(pi, startProcDef);
        if (this.newThread) {
            ((IInternalEventDirector)pcb).sendEvent(new StateEvent(startProcInst.getRootKey(), startProcInst.getKey(), StateEnum.STARTED), false);
        } else {
            ec.addProcessInstance(startProcInst);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

