/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.bped.unmanaged;

import java.util.Stack;
import java.util.logging.Logger;
import org.apache.ode.bpe.bped.DeployTypeEnum;
import org.apache.ode.bpe.bped.EventContext;
import org.apache.ode.bpe.bped.EventDirectorUtil;
import org.apache.ode.bpe.bped.ExternalEventDirectorBase;
import org.apache.ode.bpe.bped.IDeployer;
import org.apache.ode.bpe.bped.IInternalEventDirector;
import org.apache.ode.bpe.bped.unmanaged.BPELDeployerSLImpl;
import org.apache.ode.bpe.correlation.CorrelationService;
import org.apache.ode.bpe.engine.ProcessInstance;
import org.apache.ode.bpe.engine.ProcessService;
import org.apache.ode.bpe.engine.ReturnMessageLocatorHolder;
import org.apache.ode.bpe.event.Fault;
import org.apache.ode.bpe.event.IRequestMessageEvent;
import org.apache.ode.bpe.event.IResponseMessage;
import org.apache.ode.bpe.event.LoadDefinitionEvent;
import org.apache.ode.bpe.event.StateEvent;
import org.apache.ode.bpe.lang.ResourceGetter;
import org.apache.ode.bpe.locking.LockingService;
import org.apache.ode.bpe.timerservice.IBPETimer;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;
import org.apache.ode.bpe.uuid.UUIDService;

public class EventDirectorSLImpl
extends ExternalEventDirectorBase
implements IInternalEventDirector {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$bped$unmanaged$EventDirectorSLImpl == null ? (class$org$apache$ode$bpe$bped$unmanaged$EventDirectorSLImpl = EventDirectorSLImpl.class$("org.apache.ode.bpe.bped.unmanaged.EventDirectorSLImpl")) : class$org$apache$ode$bpe$bped$unmanaged$EventDirectorSLImpl).getName());
    private ProcessService processService;
    private CorrelationService correlationService;
    private LockingService lockingService;
    private ThreadLocal currentEventContext = new ThreadLocal();
    private UUIDService us;
    private ThreadLocal processInstanceStack = new ThreadLocal();
    private ThreadLocal dead = new ThreadLocal();
    static /* synthetic */ Class class$org$apache$ode$bpe$bped$unmanaged$EventDirectorSLImpl;

    public void init(BPEProperties props, ProcessService ps, CorrelationService cs, UUIDService us, LockingService ls) throws BPException {
        this.correlationService = cs;
        this.us = us;
        this.processService = ps;
        this.lockingService = ls;
    }

    public CorrelationService getCorrelationService() {
        return this.correlationService;
    }

    public LockingService getLockingService() {
        return this.lockingService;
    }

    public ProcessService getProcessService() {
        return this.processService;
    }

    public IResponseMessage sendEvent(IRequestMessageEvent msg, boolean sync) throws BPException {
        logger.fine("Received message event.");
        EventContext previousEventContext = this.getEventContext();
        this.setEventContext(new EventContext());
        IResponseMessage responseMessage = this.getCorrelationService().correlateEvent(msg, sync, this);
        this.setEventContext(previousEventContext);
        return responseMessage;
    }

    private EventContext getEventContext() {
        return (EventContext)this.currentEventContext.get();
    }

    private void setEventContext(EventContext context) {
        this.currentEventContext.set(context);
    }

    public void activate(String rootKey, String procKey) throws BPException {
        EventDirectorUtil.activate(this, rootKey, procKey);
    }

    public void terminate(String rootKey, String procKey) throws BPException {
        EventDirectorUtil.terminate(this, rootKey, procKey);
    }

    public void pause(String rootKey, String procKey) throws BPException {
        EventDirectorUtil.pause(this, rootKey, procKey);
    }

    private void handleStateEvent(StateEvent se, boolean sync) throws BPException {
        if (!sync) {
            logger.severe(ResourceGetter.getString("ED_ED_SMT"));
        }
        EventDirectorUtil.handleStateEvent(this, this.processService, se);
    }

    public ReturnMessageLocatorHolder getReturnMessageMetadata() {
        return this.getEventContext().getReturnMessageMetadata();
    }

    public IRequestMessageEvent getMessageEvent() {
        return this.getEventContext().getMessageEvent();
    }

    public void setReturnMessageMetadata(ReturnMessageLocatorHolder rmlh) {
        this.getEventContext().setReturnMessageMetadata(rmlh);
    }

    public void setMessageEvent(IRequestMessageEvent me) {
        this.getEventContext().setMessageEvent(me);
    }

    public void release() {
        this.us.close();
        this.processService.getInstanceService().getDefinitionService().releaseExternalActions();
    }

    public IDeployer getDeployer(DeployTypeEnum type) {
        if (type.equals(DeployTypeEnum.BPEL)) {
            return new BPELDeployerSLImpl(this);
        }
        return null;
    }

    public void sendEvent(StateEvent me, boolean sync) throws BPException {
        logger.fine("Recieved state event.");
        this.setEventContext(new EventContext());
        this.handleStateEvent(me, sync);
    }

    public void sendEvent(LoadDefinitionEvent me, boolean sync) throws BPException {
        EventDirectorUtil.handleLoadDefintionEvent(this, me);
    }

    public Fault sendEvent(IBPETimer me, boolean sync) throws BPException {
        logger.fine("Recieved timer event.");
        this.setEventContext(new EventContext());
        EventDirectorUtil.handleTimerEvent(this, me);
        return null;
    }

    private Stack getProcessInstanceStack() {
        Stack stack = (Stack)this.processInstanceStack.get();
        if (stack == null) {
            stack = new Stack();
            this.processInstanceStack.set(stack);
        }
        return stack;
    }

    public void addProcessInstance(ProcessInstance pi) {
        this.getProcessInstanceStack().push(pi);
    }

    public ProcessInstance getNextProcessInstance() {
        return this.getProcessInstanceStack().size() > 0 ? (ProcessInstance)this.getProcessInstanceStack().pop() : null;
    }

    public void initProcessInstanceCollection() {
        this.getProcessInstanceStack().clear();
    }

    public boolean processInstanceCollectionIsEmpty() {
        return this.getProcessInstanceStack().isEmpty();
    }

    public void setDeadProcess(boolean mark) {
        this.dead.set(new Boolean(mark));
    }

    public boolean isDeadProcess() {
        return (Boolean)this.dead.get();
    }

    public IInternalEventDirector getIInternalEventDirector() {
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

