/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.cc.base;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.bped.EventDirector;
import org.apache.ode.bpe.bped.EventDirectorFactory;
import org.apache.ode.bpe.bped.IInternalEventDirector;
import org.apache.ode.bpe.cc.base.DataExtractor;
import org.apache.ode.bpe.cc.client.CCException;
import org.apache.ode.bpe.cc.client.IBundle;
import org.apache.ode.bpe.cc.data.DefinitionData;
import org.apache.ode.bpe.cc.data.EngineData;
import org.apache.ode.bpe.cc.data.InstanceData;
import org.apache.ode.bpe.cc.data.PartData;
import org.apache.ode.bpe.cc.data.ScopeData;
import org.apache.ode.bpe.cc.data.VariableData;
import org.apache.ode.bpe.cc.service.ICCService;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.engine.StateEnum;
import org.apache.ode.bpe.enginestate.service.EngineStateFactory;
import org.apache.ode.bpe.enginestate.service.IEngineState;
import org.apache.ode.bpe.event.StateEvent;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.instance.service.InstanceService;
import org.apache.ode.bpe.util.BPException;

public class CCServiceBase
implements ICCService {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$cc$base$CCServiceBase == null ? (class$org$apache$ode$bpe$cc$base$CCServiceBase = CCServiceBase.class$("org.apache.ode.bpe.cc.base.CCServiceBase")) : class$org$apache$ode$bpe$cc$base$CCServiceBase).getName());
    private transient IEngineState m_engineStateService = null;
    public transient EventDirector eventDirector;
    public transient IInternalEventDirector m_intED;
    static /* synthetic */ Class class$org$apache$ode$bpe$cc$base$CCServiceBase;
    static /* synthetic */ Class class$org$apache$ode$bpe$bped$EventDirector;

    public CCServiceBase() {
    }

    public CCServiceBase(Properties props) {
        this.eventDirector = (EventDirector)((Hashtable)props).get((class$org$apache$ode$bpe$bped$EventDirector == null ? (class$org$apache$ode$bpe$bped$EventDirector = CCServiceBase.class$("org.apache.ode.bpe.bped.EventDirector")) : class$org$apache$ode$bpe$bped$EventDirector).getName());
        if (this.eventDirector == null) {
            try {
                this.eventDirector = EventDirectorFactory.createEventDirector();
            }
            catch (BPException e) {
                logger.log(Level.SEVERE, "", e);
            }
        }
        this.m_intED = this.eventDirector.getIInternalEventDirector();
    }

    protected DefinitionService getDefinitionService() {
        DefinitionService definitionService = this.m_intED.getProcessService().getInstanceService().getDefinitionService();
        return definitionService;
    }

    protected InstanceService getInstanceService() {
        InstanceService instanceService = this.m_intED.getProcessService().getInstanceService();
        return instanceService;
    }

    protected IEngineState getSS() throws CCException {
        if (this.m_engineStateService == null) {
            try {
                this.m_engineStateService = EngineStateFactory.getEngineState("BPE_ENGINE_" + this.eventDirector.hashCode());
            }
            catch (BPException e) {
                throw new CCException(e);
            }
        }
        return this.m_engineStateService;
    }

    public Collection getDefinitionData() throws CCException {
        Collection defData;
        try {
            Collection defs = this.getDefinitionService().getRootDefinitions();
            defData = DataExtractor.getDefinitionData(defs);
        }
        catch (BPException e) {
            throw new CCException(e);
        }
        return defData;
    }

    public Collection getInstancesData(String iBPDefinitionID) throws CCException {
        Collection returnCollection;
        try {
            Collection instances = this.getInstanceService().getRootInstances(iBPDefinitionID);
            returnCollection = DataExtractor.getInstanceData(instances);
        }
        catch (BPException e) {
            throw new CCException(e);
        }
        if (returnCollection == null) {
            return new LinkedList();
        }
        return returnCollection;
    }

    public void cleanupNow() throws CCException {
    }

    public void cleanCompletedSince(Date iDate) throws CCException {
    }

    public void pauseEngine() throws CCException {
    }

    public void resumeEngine() throws CCException {
    }

    public Collection deployBundle(IBundle source) throws CCException {
        return null;
    }

    public InstanceData getInstanceData(String instanceID) throws CCException {
        try {
            IPMIProcess instance = this.getInstanceService().getRootInstance(instanceID);
            InstanceData instanceData = DataExtractor.getInstanceData(instance);
            return instanceData;
        }
        catch (BPException e) {
            throw new CCException(e);
        }
    }

    public DefinitionData getDefinitionData(String definitionID) throws CCException {
        return null;
    }

    public void deactivateDefinition(DefinitionData data) throws CCException {
        try {
            this.getDefinitionService().deactivateDefinition(data.getID());
        }
        catch (BPException e) {
            throw new RuntimeException(e);
        }
    }

    public void activateDefinition(DefinitionData data) throws CCException {
        try {
            this.getDefinitionService().activateDefinition(data.getID());
        }
        catch (BPException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeDefinition(DefinitionData data) throws CCException {
        try {
            this.getDefinitionService().deleteDefinition(data.getID());
        }
        catch (BPException e) {
            throw new CCException(e);
        }
    }

    public EngineData getEngineData() throws CCException {
        try {
            return DataExtractor.getEngineData(this.getSS());
        }
        catch (BPException e) {
            throw new CCException(e);
        }
    }

    public DefinitionData getDefinitionForInstance(String instanceID) throws CCException {
        return null;
    }

    public void pauseInstance(InstanceData data) throws CCException {
        try {
            this.getInstanceService().pauseRootInstance(data.getID());
        }
        catch (BPException e) {
            throw new CCException(e);
        }
    }

    public void terminateInstance(InstanceData data) throws CCException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Terminating process:" + data.getID());
        }
        StateEvent se = new StateEvent(data.getID(), data.getID(), StateEnum.TERMINATED);
        try {
            this.eventDirector.sendEvent(se, true);
        }
        catch (BPException e) {
            throw new CCException(e);
        }
    }

    public void resumeInstance(InstanceData data) throws CCException {
        try {
            this.getInstanceService().resumeRootInstance(data.getID());
        }
        catch (BPException e) {
            throw new CCException(e);
        }
    }

    public void removeInstance(InstanceData data) throws CCException {
    }

    public ScopeData getContextScopeData(InstanceData data) throws CCException {
        return null;
    }

    public Collection getChildScopes(ScopeData data) throws CCException {
        return new LinkedList();
    }

    public Collection getVariables(ScopeData data) throws CCException {
        return new LinkedList();
    }

    public Collection getRegistrations(InstanceData data) throws CCException {
        return new LinkedList();
    }

    public Collection getPartData(VariableData data) throws CCException {
        return new LinkedList();
    }

    public void cleanup(Date completionDate) throws CCException {
    }

    public Object getPartValue(PartData data) throws CCException {
        return null;
    }

    public void setAutomaticCleanup(boolean automaticCleanup) throws CCException {
    }

    public Map getDefinitionStatistics(DefinitionData data) throws CCException {
        return new HashMap();
    }

    public Map getEngineStatistics(EngineData data) throws CCException {
        return new HashMap();
    }

    public Map getInstanceStatistics(InstanceData data) throws CCException {
        return new HashMap();
    }

    public Collection getProcessCreatingOperations(DefinitionData data) throws CCException {
        LinkedList operationData = null;
        try {
            IPMDRoot root = this.getDefinitionService().getRootDefinition(data.getID());
            if (root != null) {
                Collection operations = root.getInstanceCreatingOperations();
                operationData = DataExtractor.createOperationData(operations);
            }
        }
        catch (BPException e) {
            throw new CCException(e);
        }
        if (operationData == null) {
            operationData = new LinkedList();
        }
        return operationData;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

