/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.cc.client;

import java.io.ObjectStreamException;
import java.io.Serializable;

public class InstanceState
implements Serializable {
    static final long serialVersionUID = 4860370316474738334L;
    private final String m_state;
    private final int m_intState;
    public static final int STARTED_CONST = 1;
    public static final int PAUSED_CONST = 3;
    public static final int FINISHED_CONST = 4;
    public static final int TERMINATED_CONST = 5;
    public static final int RUNNING_CONST = 6;
    public static final int UNKNOWN_CONST = -1;
    public static final InstanceState STARTED = new InstanceState("Started", 1);
    public static final InstanceState RUNNING = new InstanceState("Running", 6);
    public static final InstanceState PAUSED = new InstanceState("Paused", 3);
    public static final InstanceState FINISHED = new InstanceState("Finished", 4);
    public static final InstanceState TERMINATED = new InstanceState("Terminated", 5);
    public static final InstanceState UNKNOWN = new InstanceState("Unknown", -1);

    private InstanceState(String iState, int iIntState) {
        this.m_state = iState;
        this.m_intState = iIntState;
    }

    public String toString() {
        return this.m_state;
    }

    public int toInt() {
        return this.m_intState;
    }

    private Object readResolve() throws ObjectStreamException {
        switch (this.m_intState) {
            case 1: {
                return STARTED;
            }
            case 6: {
                return RUNNING;
            }
            case 3: {
                return PAUSED;
            }
            case 4: {
                return FINISHED;
            }
            case 5: {
                return TERMINATED;
            }
            case -1: {
                return UNKNOWN;
            }
        }
        return UNKNOWN;
    }
}

