/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.cc.client.ejbproxy;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import org.apache.ode.bpe.cc.client.CCClient;
import org.apache.ode.bpe.cc.client.CCException;
import org.apache.ode.bpe.cc.client.IDefinition;
import org.apache.ode.bpe.cc.client.IEngine;
import org.apache.ode.bpe.cc.client.IInstance;

public class CCClientProxyBean
implements SessionBean {
    static final long serialVersionUID = -577190264022194039L;
    private static Logger ms_logger = Logger.getLogger((class$org$apache$ode$bpe$cc$client$ejbproxy$CCClientProxyBean == null ? (class$org$apache$ode$bpe$cc$client$ejbproxy$CCClientProxyBean = CCClientProxyBean.class$("org.apache.ode.bpe.cc.client.ejbproxy.CCClientProxyBean")) : class$org$apache$ode$bpe$cc$client$ejbproxy$CCClientProxyBean).getName());
    static /* synthetic */ Class class$org$apache$ode$bpe$cc$client$ejbproxy$CCClientProxyBean;

    public void ejbCreate() throws CreateException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
    }

    private IEngine getEngine(String pkgName) throws CCException {
        ms_logger.log(Level.FINEST, "Obtaining reference to BP engine \"" + pkgName + "\"");
        CCClient client = new CCClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("ENGINE_NAME", pkgName);
        return client.getEngine(props);
    }

    private IDefinition getDefinition(IEngine engine, String name) throws CCException {
        Collection definitions = engine.getDefinitions();
        Iterator i = definitions.iterator();
        while (i.hasNext()) {
            IDefinition def = (IDefinition)i.next();
            if (!def.getName().equals(name)) continue;
            return def;
        }
        return null;
    }

    public String getName(String pkgName) throws Exception {
        try {
            return this.getEngine(pkgName).getName();
        }
        catch (CCException e) {
            String msg = "Failed to get name of BP Engine \"" + pkgName + "\"";
            ms_logger.log(Level.SEVERE, msg, e);
            throw new Exception(msg + ". Exception: " + e + ", Cause: " + e.getCause());
        }
    }

    public String getState(String pkgName) throws Exception {
        try {
            return this.getEngine(pkgName).getState().toString();
        }
        catch (CCException e) {
            String msg = "Failed to get state of BP Engine \"" + pkgName + "\"";
            ms_logger.log(Level.SEVERE, msg, e);
            throw new Exception(msg + ". Exception: " + e + ", Cause: " + e.getCause());
        }
    }

    public Map getStatistics(String pkgName) throws Exception {
        try {
            return this.getEngine(pkgName).getStatistics();
        }
        catch (CCException e) {
            String msg = "Failed to get statistics of BP Engine \"" + pkgName + "\"";
            ms_logger.log(Level.SEVERE, msg, e);
            throw new Exception(msg + ". Exception: " + e + ", Cause: " + e.getCause());
        }
    }

    public void pause(String pkgName) throws Exception {
        try {
            this.getEngine(pkgName).pause();
        }
        catch (CCException e) {
            String msg = "Failed to pause BP Engine \"" + pkgName + "\"";
            ms_logger.log(Level.SEVERE, msg, e);
            throw new CreateException(msg + ". Exception: " + e + ", Cause: " + e.getCause());
        }
    }

    public void resume(String pkgName) throws Exception {
        try {
            this.getEngine(pkgName).resume();
        }
        catch (CCException e) {
            String msg = "Failed to resume BP Engine \"" + pkgName + "\"";
            ms_logger.log(Level.SEVERE, msg, e);
            throw new Exception(msg + ". Exception: " + e + ", Cause: " + e.getCause());
        }
    }

    public Collection getDefinitions(String pkgName) throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        try {
            Collection definitions = this.getEngine(pkgName).getDefinitions();
            Iterator i = definitions.iterator();
            while (i.hasNext()) {
                IDefinition def = (IDefinition)i.next();
                names.add(def.getName());
            }
        }
        catch (CCException e) {
            String msg = "Failed to get BP Definitions from BP Engine \"" + pkgName + "\"";
            ms_logger.log(Level.SEVERE, msg, e);
            throw new Exception(msg + ". Exception: " + e + ", Cause: " + e.getCause());
        }
        return names;
    }

    public void pauseDefinition(String pkgName, String defName) throws Exception {
        try {
            IEngine engine = this.getEngine(pkgName);
            IDefinition def = this.getDefinition(engine, defName);
            def.deactivate();
        }
        catch (CCException e) {
            String msg = "Failed to pause BP Definition \"" + defName + "\"" + " of BP Engine \"" + pkgName + "\"";
            ms_logger.log(Level.SEVERE, msg, e);
            throw new Exception(msg + ". Exception: " + e + ", Cause: " + e.getCause());
        }
    }

    public void resumeDefinition(String pkgName, String defName) throws Exception {
        try {
            IEngine engine = this.getEngine(pkgName);
            IDefinition def = this.getDefinition(engine, defName);
            def.deactivate();
        }
        catch (CCException e) {
            String msg = "Failed to resume BP Definition \"" + defName + "\"" + " of BP Engine \"" + pkgName + "\"";
            ms_logger.log(Level.SEVERE, msg, e);
            throw new Exception(msg + ". Exception: " + e + ", Cause: " + e.getCause());
        }
    }

    public Collection getInstances(String pkgName, String defName) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            IEngine engine = this.getEngine(pkgName);
            IDefinition def = this.getDefinition(engine, defName);
            Collection instances = def.getInstances();
            Iterator i = instances.iterator();
            while (i.hasNext()) {
                IInstance inst = (IInstance)i.next();
                ids.add(inst.getID());
            }
        }
        catch (CCException e) {
            String msg = "Failed to get instances of BP Definition \"" + defName + "\" from BP Engine \"" + pkgName + "\"";
            ms_logger.log(Level.SEVERE, msg, e);
            throw new Exception(msg + ". Exception: " + e + ", Cause: " + e.getCause());
        }
        return ids;
    }

    public void pauseInstance(String pkgName, String id) throws Exception {
        try {
            IInstance inst = this.getEngine(pkgName).getInstance(id);
            inst.pause();
        }
        catch (CCException e) {
            String msg = "Failed to pause BP Instance \"" + id + "\"" + " of BP Engine \"" + pkgName + "\"";
            ms_logger.log(Level.SEVERE, msg, e);
            throw new Exception(msg + ". Exception: " + e + ", Cause: " + e.getCause());
        }
    }

    public void resumeInstance(String pkgName, String id) throws Exception {
        try {
            IInstance inst = this.getEngine(pkgName).getInstance(id);
            inst.resume();
        }
        catch (CCException e) {
            String msg = "Failed to resume BP Instance \"" + id + "\"" + " of BP Engine \"" + pkgName + "\"";
            ms_logger.log(Level.SEVERE, msg, e);
            throw new Exception(msg + ". Exception: " + e + ", Cause: " + e.getCause());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

