/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.cc.client.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.ode.bpe.cc.client.CCException;
import org.apache.ode.bpe.cc.client.DefinitionState;
import org.apache.ode.bpe.cc.client.IDefinition;
import org.apache.ode.bpe.cc.client.IEngine;
import org.apache.ode.bpe.cc.client.impl.Engine;
import org.apache.ode.bpe.cc.client.impl.Instance;
import org.apache.ode.bpe.cc.client.impl.ProcessCreatingOperation;
import org.apache.ode.bpe.cc.client.impl.ServiceNode;
import org.apache.ode.bpe.cc.data.DefinitionData;
import org.apache.ode.bpe.cc.data.InstanceData;
import org.apache.ode.bpe.cc.data.OperationData;
import org.apache.ode.bpe.cc.service.ICCService;

public class Definition
extends ServiceNode
implements IDefinition {
    private DefinitionData m_data;
    private IEngine m_engine;

    public Definition(ICCService service, Engine engine, DefinitionData ddata) {
        super(service);
        this.m_engine = engine;
        this.m_data = ddata;
    }

    public void deactivate() throws CCException {
        this.getService().deactivateDefinition(this.m_data);
    }

    public void activate() throws CCException {
        this.getService().activateDefinition(this.m_data);
    }

    public void remove() throws CCException {
        this.getService().removeDefinition(this.m_data);
    }

    public DefinitionState getState() throws CCException {
        return this.m_data.getState();
    }

    public Collection getInstances() throws CCException {
        Collection instances = this.getService().getInstancesData(this.m_data.getID());
        Iterator instanceIter = instances.iterator();
        LinkedList<Instance> instancelist = new LinkedList<Instance>();
        while (instanceIter.hasNext()) {
            InstanceData instanceData = (InstanceData)instanceIter.next();
            instanceData.setDefinitionID(this.m_data.getID());
            Instance newInstance = new Instance(this.getService(), this, instanceData);
            instancelist.add(newInstance);
        }
        return instancelist;
    }

    public String getName() throws CCException {
        return this.m_data.getName();
    }

    public String getID() throws CCException {
        return this.m_data.getID();
    }

    public IEngine getEngine() throws CCException {
        return this.m_engine;
    }

    public Map getStatistics() throws CCException {
        Map statistics = this.getService().getDefinitionStatistics(this.m_data);
        return statistics;
    }

    public Collection getProcessCreatingOperations() throws CCException {
        LinkedList<ProcessCreatingOperation> returnCollection = new LinkedList<ProcessCreatingOperation>();
        Collection operationData = this.getService().getProcessCreatingOperations(this.m_data);
        Iterator iter = operationData.iterator();
        while (iter.hasNext()) {
            OperationData opData = (OperationData)iter.next();
            ProcessCreatingOperation pco = new ProcessCreatingOperation(opData);
            returnCollection.add(pco);
        }
        return returnCollection;
    }
}

