/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.cc.service;

import java.util.Properties;
import org.apache.ode.bpe.cc.base.CCServiceBase;
import org.apache.ode.bpe.cc.client.CCException;
import org.apache.ode.bpe.cc.ejb.CCServiceRemoteProxy;
import org.apache.ode.bpe.cc.service.ICCService;
import org.apache.ode.bpe.cc.service.ICCServiceFactory;

public class CCServiceFactory
implements ICCServiceFactory {
    private static ICCServiceFactory cachedFactory;

    private CCServiceFactory() {
    }

    public static ICCServiceFactory newInstance() {
        if (cachedFactory == null) {
            return CCServiceFactory.CreateCCServiceFactory();
        }
        return cachedFactory;
    }

    public ICCService createCCService(String pgkName) throws CCException {
        return this.createCCService(pgkName, new Properties());
    }

    public ICCService createCCService(Properties props) throws CCException {
        return this.createCCService("BPE", props);
    }

    public ICCService createCCService() throws CCException {
        return this.createCCService("BPE");
    }

    public ICCService createCCService(String pgkName, Properties props) throws CCException {
        ICCService returnValue = null;
        boolean remote = true;
        String jnfi_value = System.getProperty("java.naming.factory.initial");
        if (jnfi_value != null && jnfi_value.compareTo("org.apache.ode.bpe.inmemory.jndi.IMContextFactory") == 0) {
            remote = false;
        }
        returnValue = remote ? new CCServiceRemoteProxy(pgkName) : new CCServiceBase(props);
        return returnValue;
    }

    private static ICCServiceFactory CreateCCServiceFactory() {
        if (cachedFactory == null) {
            cachedFactory = new CCServiceFactory();
        }
        return cachedFactory;
    }
}

