/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.client.impl.def;

import java.util.Properties;
import org.apache.ode.bpe.bped.EventDirector;
import org.apache.ode.bpe.bped.EventDirectorFactory;
import org.apache.ode.bpe.client.IBPEClient;
import org.apache.ode.bpe.client.IBPEMessage;
import org.apache.ode.bpe.client.IBPEMessagePart;
import org.apache.ode.bpe.client.IDescribedValue;
import org.apache.ode.bpe.client.IFormattableValue;
import org.apache.ode.bpe.client.IOperation;
import org.apache.ode.bpe.client.exceptions.BPEClientInstantiationException;
import org.apache.ode.bpe.client.exceptions.BPEUserException;
import org.apache.ode.bpe.client.impl.def.Message;
import org.apache.ode.bpe.client.impl.def.Operation;
import org.apache.ode.bpe.client.impl.def.Part;
import org.apache.ode.bpe.interaction.spiimpl.CannedFormattableValue;
import org.apache.ode.bpe.uo.util.ApplicationLocalStore;
import org.apache.ode.bpe.util.BPException;

public class BPEClientDefaultImpl
implements IBPEClient {
    private EventDirector eventDirector;

    public BPEClientDefaultImpl(Properties spec) throws BPEUserException {
        try {
            String pkgName = spec.getProperty("packageName");
            boolean remote = true;
            String val = System.getProperty("java.naming.factory.initial");
            if (val != null && val.compareTo("org.apache.ode.bpe.inmemory.jndi.IMContextFactory") == 0) {
                remote = false;
            }
            this.eventDirector = remote ? (pkgName != null ? (spec.getProperty("bpe_local") == null ? EventDirectorFactory.createRemoteEventDirector(pkgName) : this.getLocalEventDirector(pkgName)) : EventDirectorFactory.createRemoteEventDirector()) : EventDirectorFactory.createEventDirectorCached();
        }
        catch (BPException e) {
            throw new BPEClientInstantiationException(e);
        }
    }

    private EventDirector getLocalEventDirector(String packageName) throws BPException {
        String key = "BPED local interface for package " + packageName + " with thread hashcode " + Thread.currentThread().hashCode();
        EventDirector returnValue = (EventDirector)ApplicationLocalStore.get(key);
        if (returnValue == null) {
            returnValue = EventDirectorFactory.createRemoteEventDirector(packageName, true);
            ApplicationLocalStore.set(key, returnValue);
        }
        return returnValue;
    }

    public IBPEMessage createMessage() {
        return new Message(this);
    }

    public IFormattableValue createFormattableValue(IDescribedValue describedValue) {
        return new CannedFormattableValue(describedValue);
    }

    public IOperation createOperation(Properties spec) {
        Operation returnValue = new Operation(this, this.eventDirector, spec);
        return returnValue;
    }

    public IBPEMessagePart createPart(String name, IDescribedValue value) {
        return new Part((IBPEClient)this, name, value);
    }

    public IBPEMessagePart createPart(String name, IFormattableValue value) {
        return new Part((IBPEClient)this, name, value);
    }
}

