/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.persistent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ode.bpe.context.IContainer;
import org.apache.ode.bpe.context.INode;
import org.apache.ode.bpe.context.IPart;
import org.apache.ode.bpe.context.base.ContextServiceException;
import org.apache.ode.bpe.context.base.SuperNode;
import org.apache.ode.bpe.context.ejb.BPE_ObjectLocal;
import org.apache.ode.bpe.context.persistent.PersistentNode;

public class PersistentContainer
extends PersistentNode
implements IContainer,
Serializable {
    private static final long serialVersionUID = 1L;

    public PersistentContainer(String name, PersistentContainer parent) throws ContextServiceException {
        super(name, parent);
        this.setNodeType(2);
    }

    public PersistentContainer(String name, PersistentContainer parent, BPE_ObjectLocal local) throws ContextServiceException {
        super(name, parent);
        this.setNodeType(2);
    }

    protected PersistentContainer() throws ContextServiceException {
        this.setNodeType(2);
    }

    public IContainer createContainer(String iContainerLocator) throws ContextServiceException {
        IContainer newContainer = this.internalCreateContainer(iContainerLocator);
        this.setDirty(this);
        return newContainer;
    }

    public IPart createPart(String iPartLocator) throws ContextServiceException {
        IPart newPart = this.internalCreatePart(iPartLocator);
        this.setDirty(this);
        return newPart;
    }

    public INode findChild(String iChildLocator) throws ContextServiceException {
        return this.internalFindChild(iChildLocator);
    }

    public void removeChild(String iChildLocator) throws ContextServiceException {
        this.internalRemoveChild(iChildLocator);
        this.setDirty(this);
    }

    public void moveNode(INode iSourceNode, String iTargetName) throws ContextServiceException {
        this.setDirty((SuperNode)iSourceNode);
        this.internalMoveNode(iSourceNode, iTargetName);
        this.setDirty(this);
    }

    public void copyNode(INode iSourceNode, String iTargetName) throws ContextServiceException {
        this.internalCopyNode(iSourceNode, iTargetName);
        this.setDirty(this);
    }

    public Collection getChildren() throws ContextServiceException {
        return this.internalGetChildren();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.writeNodeElements(s);
        Collection children = null;
        try {
            children = this.getInternalChildCollectionForSerialization();
        }
        catch (Exception e) {
            throw new IOException("Failed to get children.");
        }
        if (children != null) {
            s.writeInt(children.size());
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                PersistentNode node = (PersistentNode)iter.next();
                s.writeObject(node);
            }
        } else {
            s.writeInt(0);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.readNodeElements(s);
        int childCount = s.readInt();
        for (int i = 0; i < childCount; ++i) {
            SuperNode node = (SuperNode)s.readObject();
            try {
                this.addChild(node);
                continue;
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
    }
}

