/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.definition.serialimpl;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.ode.bpe.condition.Conditional;
import org.apache.ode.bpe.condition.ConditionalFactory;
import org.apache.ode.bpe.definition.IPMDAction;
import org.apache.ode.bpe.definition.IPMDChangeCondition;
import org.apache.ode.bpe.definition.IPMDLocator;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.serialimpl.PMDAction_SerialImpl;
import org.apache.ode.bpe.definition.serialimpl.PMDLocator_SerialImpl;
import org.apache.ode.bpe.definition.serialimpl.PMDRoot_SerialImpl;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.interaction.IInvocation;
import org.apache.ode.bpe.interaction.builders.IInteractionBuilder;
import org.apache.ode.bpe.util.BPException;

public class PMDChangeCondition_SerialImpl
implements IPMDChangeCondition,
Serializable {
    static final long serialVersionUID = -8039881624470633713L;
    private String label;
    private String description;
    private String className;
    private Properties props;
    private HashMap locators;
    private Vector actions;
    private Vector falseActions;
    private PMDRoot_SerialImpl root;
    private transient Conditional conditionalImpl;

    PMDChangeCondition_SerialImpl(String label, String conditionalClass, PMDRoot_SerialImpl root) throws DefinitionServiceException {
        this.label = label;
        this.className = conditionalClass;
        this.props = new Properties();
        this.locators = new HashMap();
        this.actions = new Vector();
        this.falseActions = new Vector();
        this.root = root;
    }

    public PMDChangeCondition_SerialImpl() {
    }

    public String getConditionalClass() {
        return this.className;
    }

    public void setConditionalClass(String c) {
        this.className = c;
        try {
            if (this.props != null) {
                this.conditionalImpl = ConditionalFactory.createConditional(this.className, this.props);
            }
        }
        catch (BPException bPException) {
            // empty catch block
        }
    }

    public Properties getMetadata() {
        return this.props;
    }

    public void setMetadata(Properties props) {
        this.props = props;
        if (this.className != null) {
            try {
                this.conditionalImpl = ConditionalFactory.createConditional(this.className, props);
            }
            catch (BPException bPException) {
                // empty catch block
            }
        }
    }

    public IPMDLocator createLocator(String name, String path, IInvocation query, IInteractionBuilder builder, int type, boolean forOutput, boolean contentious) throws DefinitionServiceException {
        PMDLocator_SerialImpl ret = new PMDLocator_SerialImpl(name, path, query, builder, type, forOutput, contentious);
        this.locators.put(name, ret);
        return ret;
    }

    public IPMDLocator getLocator(String name) {
        return (IPMDLocator)this.locators.get(name);
    }

    public IPMDLocator addLocator(String name, IPMDLocator locatorObj) {
        this.locators.put(name, locatorObj);
        return locatorObj;
    }

    public IPMDAction createAction(String label, String actionClass) throws DefinitionServiceException {
        PMDAction_SerialImpl ret = new PMDAction_SerialImpl(label, actionClass, this.root);
        this.actions.add(ret);
        return ret;
    }

    public IPMDAction createFalseAction(String label, String actionClass) throws DefinitionServiceException {
        PMDAction_SerialImpl ret = new PMDAction_SerialImpl(label, actionClass, this.root);
        this.falseActions.add(ret);
        return ret;
    }

    public void addMetadata(String name, Object value) throws DefinitionServiceException {
        ((Hashtable)this.props).put(name, value);
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Iterator getActions() {
        return ((AbstractList)this.actions).iterator();
    }

    public Iterator getFalseActions() {
        return ((AbstractList)this.falseActions).iterator();
    }

    public Conditional getConditionalImpl() throws BPException {
        if (this.conditionalImpl == null) {
            this.conditionalImpl = ConditionalFactory.createConditional(this.className, this.props);
            return this.conditionalImpl;
        }
        return this.conditionalImpl;
    }

    public HashMap getLocatorCollection() {
        return this.locators;
    }

    public void setLocatorCollection(HashMap hm) {
        this.locators = hm;
    }

    public Vector getActionCollection() {
        return this.actions;
    }

    public void setActionCollection(Vector v) {
        this.actions = v;
    }

    public Iterator getLocators() {
        return this.locators.values().iterator();
    }

    public int getLocatorSize() {
        return this.locators.size();
    }

    public IPMDRoot getRoot() {
        return this.root;
    }

    public void setRoot(IPMDRoot root) {
        this.root = (PMDRoot_SerialImpl)root;
    }
}

