/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.definition.service.unmanaged;

import java.util.Collection;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.definition.service.unmanaged.PersistentDefinitionService;
import org.apache.ode.bpe.definition.service.unmanaged.TransientDefinitionService;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.event.IStaticKey;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;
import org.apache.ode.bpe.uuid.UUIDService;

public class DefinitionServiceProxy
implements DefinitionService {
    private DefinitionService delegate = null;

    private void createDelegate(BPEProperties props, UUIDService us) throws BPException {
        this.delegate = props.getDefinitionServicePersistence().equals("FALSE") ? new TransientDefinitionService() : new PersistentDefinitionService();
        this.delegate.init(props, us);
    }

    public void init(BPEProperties props, UUIDService us) throws BPException {
        this.createDelegate(props, us);
    }

    public void deleteDefinition(ProcessDefinitionKey rootKey) throws BPException {
        this.delegate.deleteDefinition(rootKey);
    }

    public IPMDRoot getRootDefinition(String definitionKey) throws BPException {
        return this.delegate.getRootDefinition(definitionKey);
    }

    public IPMDRoot getRootDefinition(ProcessDefinitionKey definitionKey) throws BPException {
        return this.delegate.getRootDefinition(definitionKey);
    }

    public IPMDProcess getProcessDefintion(ProcessDefinitionKey processKey, ProcessDefinitionKey rootKey) throws BPException {
        return this.delegate.getProcessDefintion(processKey, rootKey);
    }

    public IPMDRoot createRootDefinition(String label, String version, boolean isStateless) throws BPException {
        return this.delegate.createRootDefinition(label, version, isStateless);
    }

    public void update() throws DefinitionServiceException {
        try {
            this.delegate.update();
        }
        catch (BPException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection getRootDefinitions() throws BPException {
        return this.delegate.getRootDefinitions();
    }

    public void loadDefintion(ProcessDefinitionKey procKey, IProcessCallBack pcb) throws BPException {
        this.delegate.loadDefintion(procKey, pcb);
    }

    public Collection getCorrelations(IStaticKey key) throws BPException {
        return this.delegate.getCorrelations(key);
    }

    public BPEProperties getBPEProperties() {
        return this.delegate.getBPEProperties();
    }

    public void releaseExternalActions() {
        this.delegate.releaseExternalActions();
    }

    public Collection getNonInstanceCreatingOps(IStaticKey key) throws BPException {
        return this.delegate.getNonInstanceCreatingOps(key);
    }

    public void deactivateDefinition(String id) throws BPException {
        this.delegate.deactivateDefinition(id);
    }

    public void activateDefinition(String id) throws BPException {
        this.delegate.activateDefinition(id);
    }

    public void deleteDefinition(String rootKey) throws BPException {
        this.delegate.deleteDefinition(rootKey);
    }

    public void prepare() {
        try {
            this.delegate.prepare();
        }
        catch (BPException e) {
            throw new RuntimeException(e);
        }
    }
}

