/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.ode.bpe.correlation.PartQuery;
import org.apache.ode.bpe.definition.IPMDAction;
import org.apache.ode.bpe.definition.IPMDChangeCondition;
import org.apache.ode.bpe.definition.IPMDCorrelation;
import org.apache.ode.bpe.definition.IPMDCorrelationSetDef;
import org.apache.ode.bpe.definition.IPMDOperation;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.BPELCorrelation;
import org.apache.ode.bpe.deployment.bpel.BPELLinkedActivity;
import org.apache.ode.bpe.deployment.bpel.BPELNode;
import org.apache.ode.bpe.deployment.bpel.BPELPatternValue;
import org.apache.ode.bpe.deployment.bpel.BPELSchema;
import org.apache.ode.bpe.deployment.bpel.BPELScopePath;
import org.apache.ode.bpe.deployment.bpel.BPELUtil;
import org.apache.ode.bpe.deployment.bpel.BPELVariable;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;
import org.apache.ode.bpe.event.BPELStaticKey;
import org.apache.ode.bpe.event.IStaticKey;

abstract class BPELIOActivity
extends BPELLinkedActivity {
    protected Vector m_correlations = new Vector();

    public BPELIOActivity(BPELNode previous, BPELSchema tag, BPELAttributes attrs, Logger logger) throws DeploymentException {
        super(previous, tag, attrs, logger);
    }

    BPELStaticKey getStaticKey() throws DeploymentException {
        QName ptName = this.getQName(this.getAttributes().getPortType());
        if (ptName == null) {
            return null;
        }
        BPELStaticKey bsk = new BPELStaticKey();
        bsk.setTargetNamespace(ptName.getNamespaceURI());
        bsk.setPortType(ptName.getLocalPart());
        bsk.setOperation(this.getAttributes().getOperation());
        return bsk;
    }

    void addCorrelation(BPELCorrelation correlation) {
        this.m_correlations.add(correlation);
    }

    protected IPMDOperation getOperation(IPMDAction regAct, IPMDChangeCondition ccB) throws DeploymentException {
        String defID = null;
        defID = this.getStartProcess().getKey().getValue();
        BPELVariable var = this.getAttributes().getVariable() != null ? this.getVariable(this.getAttributes().getVariable()) : null;
        return this.getOperation(regAct, null, var, BPELPatternValue.IN, true, defID);
    }

    protected IPMDOperation getOperation(IPMDAction regAct, IPMDAction act, BPELVariable var, BPELPatternValue pattern, boolean isInstantiating, String defID) throws DeploymentException {
        IPMDCorrelation initCorrelation = null;
        ArrayList<PartQuery> pqs = null;
        IPMDRoot defRoot = this.getProcess().getDefinitionRoot();
        int varCount = 0;
        if (this.m_correlations.size() > 0) {
            if (var == null) {
                BPELUtil.throwNewException(this.m_logger, Level.SEVERE, "BPEL_CORRVAR", new Object[]{this.getProcess().getAttributes().getName(), this.getAttributes().getName()}, null);
            }
            initCorrelation = defRoot.createCorrelation(this.getStartProcess().getKey().getValue());
            BPELAttributes pProp = null;
            Iterator itr = ((AbstractList)this.m_correlations).iterator();
            while (itr.hasNext()) {
                BPELCorrelation corr = (BPELCorrelation)itr.next();
                if (corr.getPattern() != null && !pattern.equals(corr.getPattern()) && !BPELPatternValue.OUTIN.equals(corr.getPattern())) continue;
                if (isInstantiating && defID == null && !corr.isInitializing()) {
                    BPELUtil.throwNewException(this.m_logger, Level.SEVERE, "BPEL_CORR_NONINIT", new Object[]{this.getProcess().getAttributes().getName()}, null);
                }
                pqs = new ArrayList<PartQuery>();
                StringTokenizer st = corr.getProperties();
                while (st.hasMoreTokens()) {
                    String prop = st.nextToken();
                    pProp = this.getPropertyAttributes(this.getQName(prop), this.getQName(var.getAttributes().getMessageType()));
                    ++varCount;
                    String corrLoc = corr.getName() + ":" + prop;
                    pqs.add(new PartQuery(pProp.getPart(), pProp.getQuery(), corrLoc, this.buildNsHashMap(pProp.getProperty("NSMAP"))));
                    try {
                        if (act != null) {
                            this.createLocator(true, act, corrLoc, corr.getCorrelationSet().getScopePath(new BPELScopePath(this.inCompensationHandler())).toString() + "/" + corr.getName() + "/" + prop, null, null, 0, corr.isInitializing(), false);
                        }
                        if (regAct == null) continue;
                        this.createLocator(true, regAct, corrLoc, corr.getCorrelationSet().getScopePath(new BPELScopePath(this.inCompensationHandler())).toString() + "/" + corr.getName() + "/" + prop, null, null, 0, corr.isInitializing(), false);
                    }
                    catch (DefinitionServiceException e) {
                        BPELUtil.throwNewException(this.m_logger, Level.SEVERE, "BPEL_CREATELOCATOR", new Object[]{this.getProcess().getAttributes().getName(), "dynamicVar:" + String.valueOf(varCount), this.getScopePath(new BPELScopePath(this.inCompensationHandler())).toString() + "/" + corr.getName() + "/" + prop, "no query specified"}, e);
                    }
                }
                if (pqs.isEmpty()) continue;
                IPMDCorrelationSetDef corrlSetDef = defRoot.createCorrelationSet(this.getStartProcess().getKey().getValue() + ":" + corr.getName(), pqs);
                initCorrelation.addCorrelationSet(corrlSetDef, corr.isInitializing(), pattern.getValue());
            }
        }
        return this.createOperation(defRoot, this.getStartProcess().getKey().getValue() + ":" + this.getAttributes().getOperation(), this.getStaticKey(), initCorrelation, isInstantiating, defID);
    }

    protected IPMDOperation createOperation(IPMDRoot defRoot, String operationId, IStaticKey key, IPMDCorrelation corrl, boolean instanceCreating, String defId) {
        return defRoot.createOperation(operationId, key, corrl, instanceCreating, defId);
    }

    private HashMap buildNsHashMap(String nsMap) {
        HashMap<String, String> rtn = new HashMap<String, String>();
        if (nsMap != null) {
            StringTokenizer st = new StringTokenizer(nsMap, "|");
            while (st.hasMoreTokens()) {
                String prefix = st.nextToken();
                String ns = st.nextToken();
                rtn.put(prefix, ns);
            }
        }
        return rtn;
    }
}

