/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.bpel.UnInitVariableMetaData;
import org.apache.ode.bpe.definition.IPMDAction;
import org.apache.ode.bpe.definition.IPMDChangeCondition;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.BPELBoolean;
import org.apache.ode.bpe.deployment.bpel.BPELFlow;
import org.apache.ode.bpe.deployment.bpel.BPELLink;
import org.apache.ode.bpe.deployment.bpel.BPELLinkType;
import org.apache.ode.bpe.deployment.bpel.BPELNode;
import org.apache.ode.bpe.deployment.bpel.BPELProcessType;
import org.apache.ode.bpe.deployment.bpel.BPELSchema;
import org.apache.ode.bpe.deployment.bpel.BPELStructuredActivity;
import org.apache.ode.bpe.deployment.bpel.BPELUtil;
import org.apache.ode.bpe.deployment.bpel.BPELVariable;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;

abstract class BPELLinkedActivity
extends BPELNode {
    IPMDProcess m_process;
    private Vector m_source;
    private Vector m_target;
    private int m_totalTargets = 0;
    private int m_totalSources = 0;
    static /* synthetic */ Class class$org$apache$ode$bpe$condition$DefaultConditional;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$SequenceAction;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$RegisterAction;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$UnRegisterAction;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$StartSequenceAction;

    BPELLinkedActivity(BPELNode previous, BPELSchema tag, BPELAttributes attrs, Logger logger) throws DeploymentException {
        super(previous, tag, attrs, logger);
        if (this.m_attributes.getName() == null) {
            this.m_attributes.setName(tag.getValue());
        }
        if (this.m_parserStack != null) {
            this.m_process = this.m_parserStack.createProcess(this.m_attributes.getName());
            this.m_process.setDescription(this.getActivityDescription());
        }
    }

    void linkProcess(BPELProcessType parent_type, BPELLinkedActivity child, BPELProcessType child_type, boolean linkNodes) throws DeploymentException {
        try {
            this.m_process.addObserverProcessPC(child_type == BPELProcessType.START ? child.getStartProcess() : child.getEndProcess());
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(this.m_logger, Level.SEVERE, "BPEL_ADDOBSERVER", new Object[]{this.getProcess().getAttributes().getName()}, e);
        }
        if (linkNodes) {
            child.addParent(this);
        }
    }

    IPMDProcess createProcess(String label) throws DeploymentException {
        IPMDProcess ret = null;
        try {
            ret = this.m_process.createUnLinkedProcess(label);
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(this.m_logger, Level.SEVERE, "BPEL_CREATEUNLINK", new Object[]{this.getProcess().getAttributes().getName(), label}, e);
        }
        return ret;
    }

    IPMDProcess getStartProcess() {
        return this.m_process;
    }

    IPMDProcess getEndProcess() {
        return this.m_process;
    }

    BPELNode pop() throws DeploymentException {
        this.m_parserStack.addActivity(this);
        return this.m_parserStack;
    }

    Iterator getLinks(BPELLinkType type) {
        return type == BPELLinkType.SOURCE ? ((AbstractList)this.m_source).iterator() : ((AbstractList)this.m_target).iterator();
    }

    void incrementLink(BPELLinkType type) {
        if (type == BPELLinkType.TARGET) {
            ++this.m_totalTargets;
        }
        if (type == BPELLinkType.SOURCE) {
            ++this.m_totalSources;
        }
    }

    int getLinkCounter(BPELLinkType type) {
        return type == BPELLinkType.SOURCE ? this.m_totalSources : this.m_totalTargets;
    }

    void addLink(BPELLink linkName, BPELLinkType type) {
        if (type == BPELLinkType.TARGET) {
            if (this.m_target == null) {
                this.m_target = new Vector();
            }
            this.m_target.add(linkName);
            ++this.m_totalTargets;
        }
        if (type == BPELLinkType.SOURCE) {
            if (this.m_source == null) {
                this.m_source = new Vector();
            }
            this.m_source.add(linkName);
            ++this.m_totalSources;
        }
    }

    void createProcessSequence(BPELAttributes attr, IPMDProcess process) throws DeploymentException {
        try {
            IPMDChangeCondition precc = process.createPrecondition("PreCondition: " + attr.getName(), (class$org$apache$ode$bpe$condition$DefaultConditional == null ? (class$org$apache$ode$bpe$condition$DefaultConditional = BPELLinkedActivity.class$("org.apache.ode.bpe.condition.DefaultConditional")) : class$org$apache$ode$bpe$condition$DefaultConditional).getName());
            IPMDAction preact = precc.createAction("SequenceAction: " + attr.getName(), (class$org$apache$ode$bpe$action$bpel$SequenceAction == null ? (class$org$apache$ode$bpe$action$bpel$SequenceAction = BPELLinkedActivity.class$("org.apache.ode.bpe.action.bpel.SequenceAction")) : class$org$apache$ode$bpe$action$bpel$SequenceAction).getName());
            preact.setMetadata(this.getAttributes());
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(this.m_logger, Level.SEVERE, "BPEL_CREATEACTION", new Object[]{this.getProcess().getAttributes().getName(), this.getAttributes().getName()}, e);
        }
    }

    IPMDAction createRegisterAction(IPMDChangeCondition cc, String label) throws DeploymentException {
        IPMDAction ret = null;
        try {
            ret = cc.createAction("RegisterAction: " + label, (class$org$apache$ode$bpe$action$bpel$RegisterAction == null ? (class$org$apache$ode$bpe$action$bpel$RegisterAction = BPELLinkedActivity.class$("org.apache.ode.bpe.action.bpel.RegisterAction")) : class$org$apache$ode$bpe$action$bpel$RegisterAction).getName());
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(this.m_logger, Level.SEVERE, "BPEL_CREATEACTION", new Object[]{this.getProcess().getAttributes().getName(), label}, e);
        }
        return ret;
    }

    IPMDAction createUnRegisterAction(IPMDChangeCondition cc, String label) throws DeploymentException {
        IPMDAction ret = null;
        try {
            ret = cc.createAction("UnRegisterAction: " + label, (class$org$apache$ode$bpe$action$bpel$UnRegisterAction == null ? (class$org$apache$ode$bpe$action$bpel$UnRegisterAction = BPELLinkedActivity.class$("org.apache.ode.bpe.action.bpel.UnRegisterAction")) : class$org$apache$ode$bpe$action$bpel$UnRegisterAction).getName());
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(this.m_logger, Level.SEVERE, "BPEL_CREATEACTION", new Object[]{this.getProcess().getAttributes().getName(), label}, e);
        }
        return ret;
    }

    void addJoinCondtion(BPELVariable var) throws DeploymentException {
        Iterator ccItr = this.getStartProcess().getChangeConditions();
        while (ccItr.hasNext()) {
            IPMDChangeCondition cc = (IPMDChangeCondition)ccItr.next();
            cc.setConditionalClass(BPELFlow.XPATH_JOIN_COND_CLASS);
            Properties md = new Properties();
            ((Hashtable)md).put("UNINITVAR", new UnInitVariableMetaData("http://schemas.xmlsoap.org/ws/2003/03/business-process/", "uninitializedVariable"));
            ((Hashtable)md).put("JoinExpression", var.createLocator(cc, this, null, null, false));
            ((Hashtable)md).put("SuppressJoinFault", BPELBoolean.NO.equals(this.getAttributes().getSuppressJoin()) ? BPELBoolean.NO.getBooleanValue() : this.getSuppressJoinFailure().getBooleanValue());
            cc.setMetadata(md);
            if (!(this instanceof BPELStructuredActivity) || this.getEndProcess() == null) continue;
            try {
                IPMDAction act = cc.createFalseAction("False Join Condition Start Sequence: " + this.getAttributes().getName(), (class$org$apache$ode$bpe$action$bpel$StartSequenceAction == null ? BPELLinkedActivity.class$("org.apache.ode.bpe.action.bpel.StartSequenceAction") : class$org$apache$ode$bpe$action$bpel$StartSequenceAction).getName());
                ((Hashtable)act.getMetadata()).put("START_DEF_KEY", this.getEndProcess().getKey());
            }
            catch (DefinitionServiceException e) {
                BPELUtil.throwNewException(this.m_logger, Level.SEVERE, "BPEL_CREATEACTION", new Object[]{this.getProcess().getAttributes().getName(), this.getAttributes().getName()}, e);
            }
        }
    }

    abstract String getActivityDescription();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

