/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.xml.WSDLLocator;
import org.apache.ode.bpe.lang.ResourceGetter;
import org.xml.sax.InputSource;

class BPELWSDLLocator
implements WSDLLocator {
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$deployment$bpel$BPELWSDLLocator == null ? (class$org$apache$ode$bpe$deployment$bpel$BPELWSDLLocator = BPELWSDLLocator.class$("org.apache.ode.bpe.deployment.bpel.BPELWSDLLocator")) : class$org$apache$ode$bpe$deployment$bpel$BPELWSDLLocator).getName());
    private InputSource m_source;
    private HashMap m_supportDoc;
    private String m_bpelURI;
    private String m_latestURI;
    static /* synthetic */ Class class$org$apache$ode$bpe$deployment$bpel$BPELWSDLLocator;

    BPELWSDLLocator(String bpelURI, InputSource source, HashMap supportDoc) {
        this.m_source = source;
        this.m_supportDoc = supportDoc;
        this.m_bpelURI = bpelURI;
    }

    public InputSource getBaseInputSource() {
        return this.m_source;
    }

    public String getBaseURI() {
        return this.m_bpelURI;
    }

    private String getQualifiedImportPath(String parentLocation, String importLocation) {
        if (this.m_supportDoc.containsKey(importLocation.toLowerCase())) {
            return importLocation;
        }
        if (importLocation.startsWith("/")) {
            return importLocation;
        }
        int index = parentLocation.lastIndexOf("/");
        if (index == -1) {
            return importLocation;
        }
        String path = parentLocation.substring(0, index);
        String[] components = importLocation.split("/");
        for (int i = 0; i < components.length; ++i) {
            if (components[i].equals(".")) continue;
            if (components[i].equals("..")) {
                index = path.lastIndexOf("/");
                if (index == -1) {
                    path = "";
                    continue;
                }
                path = path.substring(0, index);
                continue;
            }
            if (path.length() > 0) {
                path = path + "/";
            }
            path = path + components[i];
        }
        logger.info("Relative path: " + path);
        return path;
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        logger.info("parentLocation: " + parentLocation + " importLocation: " + importLocation);
        this.m_latestURI = this.getQualifiedImportPath(parentLocation, importLocation);
        InputSource is = null;
        byte[] data = (byte[])this.m_supportDoc.get(this.m_latestURI.toLowerCase());
        if (data != null) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                is = new InputSource(bais);
                bais.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, ResourceGetter.getFormatted("BPEL_IOERR", new Object[]{parentLocation, this.m_latestURI.toLowerCase()}), e);
            }
        }
        if (is == null) {
            logger.log(Level.SEVERE, ResourceGetter.getFormatted("DEPLOY_WSDL_NOTFOUND", new Object[]{this.m_bpelURI, this.m_latestURI.toLowerCase()}));
        }
        return is;
    }

    public String getLatestImportURI() {
        return this.m_latestURI;
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

