/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.engine;

import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.internal.IInternalAction;
import org.apache.ode.bpe.condition.Conditional;
import org.apache.ode.bpe.context.IContextService;
import org.apache.ode.bpe.context.resolver.ContextResolvedObject;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.definition.IPMDAction;
import org.apache.ode.bpe.definition.IPMDChangeCondition;
import org.apache.ode.bpe.definition.IPMDLocator;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.engine.ProcessInstancePausedException;
import org.apache.ode.bpe.engine.ProcessService;
import org.apache.ode.bpe.engine.ReturnMessageLocatorHolder;
import org.apache.ode.bpe.engine.ScopeEnum;
import org.apache.ode.bpe.engine.StateEnum;
import org.apache.ode.bpe.event.IEvent;
import org.apache.ode.bpe.event.IInternalEvent;
import org.apache.ode.bpe.event.StateEvent;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.instance.service.InstanceService;
import org.apache.ode.bpe.interaction.spiadapter.SPIAdapterInteraction;
import org.apache.ode.bpe.lang.ResourceGetter;
import org.apache.ode.bpe.scope.service.IFCScopeInstance;
import org.apache.ode.bpe.scope.service.IScopeService;
import org.apache.ode.bpe.scope.service.ScopePath;
import org.apache.ode.bpe.util.BPException;

public class ProcessInstance {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$engine$ProcessInstance == null ? (class$org$apache$ode$bpe$engine$ProcessInstance = ProcessInstance.class$("org.apache.ode.bpe.engine.ProcessInstance")) : class$org$apache$ode$bpe$engine$ProcessInstance).getName());
    private IPMIProcess process;
    private ProcessService ps;
    private int debugVariableLogSize = Integer.MAX_VALUE;
    private static final String LINE_SEPERATOR = System.getProperty("line.separator");
    private static final String VARIABLE_LOGGING_SIZE_PROP = "VARIABLE_LOGGING_SIZE";
    static /* synthetic */ Class class$org$apache$ode$bpe$engine$ProcessInstance;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;

    protected ProcessInstance(IPMIProcess process, ProcessService ps) {
        this.process = process;
        this.ps = ps;
    }

    public String getKey() {
        return this.process.getKey();
    }

    public String getRootKey() {
        return this.process.getRootKey();
    }

    public InstanceService getInstanceService() {
        return this.ps.getInstanceService();
    }

    public IScopeService getScopeService() throws BPException {
        return this.ps.getScopeService(this.process);
    }

    public IContextService getContextService() throws BPException {
        return this.ps.getContextService(this.process);
    }

    public Collection getSubProcess(ScopeEnum scope) {
        return null;
    }

    public StateEnum getState() {
        return StateEnum.getState(this.process.getState());
    }

    public void setState(StateEnum state) {
        this.process.setState(state.getIntValue());
    }

    public ScopePath getScopePath() {
        return this.process.getScopePath();
    }

    public void setScopePath(ScopePath scopePath) {
        this.process.setScopePath(scopePath);
    }

    public String getLabel() throws BPException {
        return this.process.getDefinition().getLabel();
    }

    public String getDescription() throws BPException {
        return this.process.getDefinition().getDescription();
    }

    public String getVersion() throws BPException {
        return this.process.getDefinition().getVersion();
    }

    public void pause() {
    }

    public void activiate() {
    }

    public void terminate(IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        IScopeService ss = this.getScopeService();
        ss.getRootScope().terminate(this.process, ec, pcb);
    }

    private boolean isRootProcessPaused() throws BPException {
        IPMIProcess rootInstance = this.getInstanceService().getRootInstance(this.getRootKey());
        return rootInstance.isPaused();
    }

    public void processEvent(IEvent event, IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        if (!(event instanceof IInternalEvent) && this.isRootProcessPaused()) {
            throw new ProcessInstancePausedException(this.getRootKey());
        }
        ec.initProcessInstanceCollection();
        this.processInternalEvent(event, ec, pcb);
        while (!ec.processInstanceCollectionIsEmpty()) {
            ProcessInstance pi = ec.getNextProcessInstance();
            pi.processInternalEvent(new StateEvent(pi.getRootKey(), pi.getKey(), StateEnum.STARTED), ec, pcb);
        }
    }

    private void processInternalEvent(IEvent event, IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        ReturnMessageLocatorHolder rmlh;
        ec.setDeadProcess(false);
        this.logProcessStatus("      * Engine Begins Executing->");
        if (event instanceof IInternalEvent) {
            ((IInternalEvent)event).apply(this, ec, pcb);
        }
        if ((rmlh = pcb.getReturnMessageMetadata()) == null) {
            rmlh = new ReturnMessageLocatorHolder();
            rmlh.setRootProcessID(this.getRootKey());
            pcb.setReturnMessageMetadata(rmlh);
        }
        if (this.process.getState() != StateEnum.STARTED.getIntValue()) {
            if (this.process.getState() == StateEnum.TERMINATED.getIntValue()) {
                return;
            }
            String s = ResourceGetter.getFormatted("ENG_PI_PNS", new Object[]{this.process.getKey(), String.valueOf(this.process.getState())});
            logger.severe(s);
        }
        try {
            if (this.evaluate(this.process.getDefinition().getChangeConditions(), this.process.getDefinition(), ec, pcb)) {
                this.process.setState(StateEnum.FINISHED.getIntValue());
                Iterator iOPC = this.process.getDefinition().getObserverProcessPC();
                while (iOPC.hasNext()) {
                    IPMDProcess pDef = (IPMDProcess)iOPC.next();
                    this.evaluate(pDef.getPrecondition(), pDef, ec, pcb);
                }
                this.logProcessStatus("      * Engine Ends Executing->");
                if (!ec.isDeadProcess()) {
                    this.process.remove();
                }
            }
        }
        catch (Throwable t) {
            IScopeService ss = this.getScopeService();
            IFCScopeInstance scope = ss.getScope(this.getScopePath());
            scope.handleFault(t, this.process, ec, pcb);
            this.process.remove();
        }
    }

    private boolean evaluate(IPMDChangeCondition dCC, IPMDProcess pDef, IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        ContextResolver resolver;
        boolean result = true;
        if (dCC == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(pDef.getLabel() + " has no conditions.");
            }
            return result;
        }
        Conditional cond = dCC.getConditionalImpl();
        boolean bln = cond.evaluate(resolver = new ContextResolver(this.process, dCC, this.getContextService(), this.getScopeService()));
        if (bln) {
            this.logConditionEvaluation(true, dCC, pDef);
            Iterator iAction = dCC.getActions();
            result = this.executeActions(iAction, pDef, ec, pcb);
        } else {
            this.logConditionEvaluation(false, dCC, pDef);
            Iterator iAction = dCC.getFalseActions();
            result = this.executeActions(iAction, pDef, ec, pcb);
        }
        return result;
    }

    private boolean executeActions(Iterator iAction, IPMDProcess pDef, IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        boolean result = true;
        while (iAction.hasNext() && result) {
            IPMDAction actionMD = (IPMDAction)iAction.next();
            IInternalAction action = actionMD.getActionImpl();
            ContextResolver resolver = new ContextResolver(this.process, actionMD, this.getContextService(), this.getScopeService());
            result = action.execute(resolver, ec, pcb, this.process, pDef);
            this.logActionExecution(result, action);
        }
        return result;
    }

    private void logActionExecution(boolean result, IInternalAction action) {
        if (logger.isLoggable(Level.FINER)) {
            logger.fine("\n      * Engine executed Action( class = " + action.getClass().getName() + ", retValue = " + result + " )");
        }
    }

    private void logConditionEvaluation(boolean b, IPMDChangeCondition dcc, IPMDProcess def) {
        if (logger.isLoggable(Level.FINER)) {
            logger.fine("\n      * Engine condition evaluated to " + b + " for defintion( label = " + def.getLabel() + ", key = " + def.getKey().getValue() + ")");
        }
    }

    private boolean evaluate(Iterator iCC, IPMDProcess pDef, IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        boolean result = true;
        while (iCC.hasNext() && result) {
            result = this.evaluate((IPMDChangeCondition)iCC.next(), pDef, ec, pcb);
        }
        return result;
    }

    private void logProcessStatus(String positionIdentifier) throws BPException {
        if (logger.isLoggable(Level.FINE) || logger.isLoggable(Level.FINER)) {
            String variableLogSize = LogManager.getLogManager().getProperty(VARIABLE_LOGGING_SIZE_PROP);
            if (variableLogSize != null) {
                this.debugVariableLogSize = new Integer(variableLogSize);
                if (this.debugVariableLogSize < 0) {
                    this.debugVariableLogSize = Integer.MAX_VALUE;
                }
            }
            String loggerStr = "*********************************";
            loggerStr = loggerStr + LINE_SEPERATOR;
            loggerStr = loggerStr + positionIdentifier + this.getLabel();
            loggerStr = loggerStr + LINE_SEPERATOR;
            if (this.getDescription() != null) {
                loggerStr = loggerStr + "      * Detail Metadata Description->" + this.getDescription();
                loggerStr = loggerStr + LINE_SEPERATOR;
            }
            if (logger.isLoggable(Level.FINER)) {
                loggerStr = loggerStr + "      * Variable(s):";
                loggerStr = loggerStr + LINE_SEPERATOR;
                Iterator changeConditionsIterator = this.process.getDefinition().getChangeConditions();
                if (changeConditionsIterator != null) {
                    while (changeConditionsIterator.hasNext()) {
                        IPMDChangeCondition changeCondition = (IPMDChangeCondition)changeConditionsIterator.next();
                        ContextResolver resolver = new ContextResolver(this.process, changeCondition, this.getContextService(), this.getScopeService());
                        loggerStr = this.logVariables(loggerStr, resolver);
                        Iterator iAction = changeCondition.getActions();
                        if (iAction == null) continue;
                        while (iAction.hasNext()) {
                            IPMDAction actionMD = (IPMDAction)iAction.next();
                            actionMD.getActionImpl();
                            ContextResolver actionResolver = new ContextResolver(this.process, actionMD, this.getContextService(), this.getScopeService());
                            loggerStr = this.logVariables(loggerStr, actionResolver);
                        }
                    }
                }
            }
            loggerStr = loggerStr + "      *********************************";
            logger.fine(loggerStr);
        }
    }

    private String logVariables(String loggerStr, ContextResolver resolver) {
        Iterator it = resolver.getLocatorHolder().getLocators();
        if (it != null) {
            while (it.hasNext()) {
                IPMDLocator loc = (IPMDLocator)it.next();
                String name = loc.getName();
                try {
                    ContextResolvedObject ro = (ContextResolvedObject)resolver.resolveWithOutInvocation(name);
                    name = resolver.getResolvedVariableName(name);
                    if (ro != null) {
                        Object resolvedValue = ro.getValue();
                        if (resolvedValue != null) {
                            if (resolvedValue instanceof SPIAdapterInteraction) {
                                SPIAdapterInteraction spi = (SPIAdapterInteraction)resolvedValue;
                                if (spi.getUserValue().supportsGetValueAs(array$B == null ? ProcessInstance.class$("[B") : array$B)) {
                                    byte[] ba = (byte[])spi.getUserValue().getValueAs(array$B == null ? ProcessInstance.class$("[B") : array$B);
                                    String str = new String(ba);
                                    if (str.length() > 500) {
                                        str = str.substring(0, 499);
                                    }
                                    loggerStr = loggerStr + "      * " + name + " = " + str;
                                } else if (spi.getUserValue().supportsGetValueAs(class$java$lang$String == null ? ProcessInstance.class$("java.lang.String") : class$java$lang$String)) {
                                    String str = (String)spi.getUserValue().getValueAs(class$java$lang$String == null ? ProcessInstance.class$("java.lang.String") : class$java$lang$String);
                                    loggerStr = loggerStr + "      * " + name + " = " + str;
                                } else {
                                    loggerStr = loggerStr + "      * " + name + " = " + ((Object)spi.getUserValue()).toString();
                                }
                            }
                        } else {
                            loggerStr = loggerStr + "      * " + name + " = null";
                        }
                    } else {
                        loggerStr = loggerStr + "      * " + name + " = null";
                    }
                }
                catch (Exception e) {
                    loggerStr = loggerStr + "      * " + name + "->" + e.getClass().getName() + ":" + e.getLocalizedMessage();
                }
                loggerStr = loggerStr + LINE_SEPERATOR;
            }
        }
        return loggerStr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

