/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.instance.nonpersistent;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.engine.StateEnum;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.instance.service.InstanceServiceException;
import org.apache.ode.bpe.instance.service.nonpersistent.InstanceServiceTransientImpl;
import org.apache.ode.bpe.scope.service.ScopePath;
import org.apache.ode.bpe.util.BPException;

public class PMIProcessTransientImpl
implements IPMIProcess {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$instance$nonpersistent$PMIProcessTransientImpl == null ? (class$org$apache$ode$bpe$instance$nonpersistent$PMIProcessTransientImpl = PMIProcessTransientImpl.class$("org.apache.ode.bpe.instance.nonpersistent.PMIProcessTransientImpl")) : class$org$apache$ode$bpe$instance$nonpersistent$PMIProcessTransientImpl).getName());
    private String root;
    private String key;
    private String contextContainerId;
    private String executionCtx = "process";
    private int state = StateEnum.UNSTARTED.getIntValue();
    private ScopePath scopePath = new ScopePath();
    private boolean markedForCleanUp;
    private boolean isStateless;
    private IPMDProcess pDefinition;
    private InstanceServiceTransientImpl service;
    static /* synthetic */ Class class$org$apache$ode$bpe$instance$nonpersistent$PMIProcessTransientImpl;

    public PMIProcessTransientImpl(String defKey, DefinitionService ds, InstanceServiceTransientImpl is) {
        ProcessDefinitionKey pdk = new ProcessDefinitionKey(defKey);
        try {
            this.pDefinition = ds.getProcessDefintion(pdk, pdk);
            this.isStateless = ds.getRootDefinition(pdk).getIsStateless();
        }
        catch (BPException e) {
            // empty catch block
        }
        this.key = this.root = String.valueOf(this.hashCode());
        this.contextContainerId = this.root;
        this.service = is;
    }

    private PMIProcessTransientImpl(IPMDProcess pDef, String root, InstanceServiceTransientImpl is, ScopePath scopePath, String ctxtid, String executionCtx) {
        this.pDefinition = pDef;
        this.root = root;
        this.service = is;
        this.key = String.valueOf(this.hashCode());
        this.scopePath = scopePath;
        this.contextContainerId = ctxtid;
        this.executionCtx = executionCtx;
    }

    public IPMIProcess createSubProcess(IPMDProcess definition) throws BPException {
        PMIProcessTransientImpl ret;
        try {
            ret = new PMIProcessTransientImpl(definition, this.root, this.service, (ScopePath)this.scopePath.clone(), this.contextContainerId, this.executionCtx);
        }
        catch (CloneNotSupportedException e) {
            throw new BPException("NATIVE_EXCEPTION", new Object[]{"CloneNotSupportedException"}, e);
        }
        if (!this.isStateless && this.service != null) {
            this.service.addInstance(this.root, ret);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("New instance:" + ret.getKey() + "(Parent:" + this.key + ")");
        }
        return ret;
    }

    public void remove() throws InstanceServiceException {
    }

    public boolean isMarkedForCleanUp() {
        return this.markedForCleanUp;
    }

    public void setMarkedForCleanUp(boolean b) {
        this.markedForCleanUp = b;
    }

    public String getRootKey() {
        return this.root;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int i) {
        this.state = i;
    }

    public IPMDProcess getDefinition() throws InstanceServiceException, DefinitionServiceException {
        return this.pDefinition;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isStateless() {
        return true;
    }

    public boolean isPaused() {
        return false;
    }

    public ScopePath getScopePath() {
        return this.scopePath;
    }

    public void setScopePath(ScopePath scopePath) {
        this.scopePath = scopePath;
    }

    public String getContextContainerId() {
        return this.contextContainerId;
    }

    public void setContextContaionerId(String id) {
        this.contextContainerId = id;
    }

    public String getExecutionContext() {
        return this.executionCtx;
    }

    public void setExecutionContext(String executionCtx) {
        this.executionCtx = executionCtx;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

