/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.interaction;

import java.util.HashMap;
import org.apache.ode.bpe.interaction.IInvocation;
import org.apache.ode.bpe.interaction.IInvocationFactory;
import org.apache.ode.bpe.interaction.InteractionException;
import org.apache.ode.bpe.interaction.Invocation;
import org.apache.ode.bpe.interaction.operations.CopyChildrenOperation;
import org.apache.ode.bpe.interaction.operations.CopyChildrenWithOverwriteOperation;
import org.apache.ode.bpe.interaction.operations.CopyTreeOperation;
import org.apache.ode.bpe.interaction.operations.GetObjectOperation;
import org.apache.ode.bpe.interaction.operations.GetTextValueOperation;
import org.apache.ode.bpe.interaction.operations.IOperation;
import org.apache.ode.bpe.interaction.operations.PruneOperation;
import org.apache.ode.bpe.interaction.operations.SelectTreeOperation;
import org.apache.ode.bpe.interaction.operations.SetObjectOperation;
import org.apache.ode.bpe.interaction.operations.SetTextValueOperation;
import org.apache.ode.bpe.interaction.query.JaxenXPathSingleNodeQuery;

public class InvocationFactory
implements IInvocationFactory {
    public static IInvocationFactory newInstance() {
        return new InvocationFactory();
    }

    public IInvocation createXPathQueryNodeValueInvocation(String iExpression, HashMap iNamespaceMap) throws InteractionException {
        GetTextValueOperation operation = new GetTextValueOperation();
        IInvocation invocation = this.createCommonInvocation(iExpression, iNamespaceMap, operation, 1);
        return invocation;
    }

    public IInvocation createXPathSetNodeValueInvocation(String iXPathExpression, HashMap iNamespaceMap) throws InteractionException {
        SetTextValueOperation operation = new SetTextValueOperation();
        IInvocation invocation = this.createCommonInvocation(iXPathExpression, iNamespaceMap, operation, 2);
        return invocation;
    }

    public IInvocation createXPathSelectTreeInvocation(String iXPathExpression, HashMap iNamespaceMap) throws InteractionException {
        SelectTreeOperation operation = new SelectTreeOperation();
        IInvocation invocation = this.createCommonInvocation(iXPathExpression, iNamespaceMap, operation, 3);
        return invocation;
    }

    public IInvocation createXPathCopyTreeInvocation(String iXPathExpression, HashMap iNamespaceMap) throws InteractionException {
        CopyTreeOperation operation = new CopyTreeOperation();
        IInvocation invocation = this.createCommonInvocation(iXPathExpression, iNamespaceMap, operation, 4);
        return invocation;
    }

    public IInvocation createXPathPruneTreeInvocation(String iXPathExpression, HashMap iNamespaceMap) throws InteractionException {
        PruneOperation operation = new PruneOperation();
        IInvocation invocation = this.createCommonInvocation(iXPathExpression, iNamespaceMap, operation, 5);
        return invocation;
    }

    public IInvocation createSetObjectInvocation() {
        SetObjectOperation operation = new SetObjectOperation();
        Invocation invocation = new Invocation(null, operation, 7);
        return invocation;
    }

    public IInvocation createGetObjectInvocation() {
        GetObjectOperation operation = new GetObjectOperation();
        Invocation invocation = new Invocation(null, operation, 8);
        return invocation;
    }

    private IInvocation createCommonInvocation(String iXPathExpression, HashMap iNamespaceMap, IOperation iOperation, int type) throws InteractionException {
        try {
            JaxenXPathSingleNodeQuery query = new JaxenXPathSingleNodeQuery(iXPathExpression, iNamespaceMap);
            Invocation invocation = new Invocation(query, iOperation, type);
            return invocation;
        }
        catch (Exception e) {
            InteractionException bpx = new InteractionException("NATIVE_EXCEPTION", new Object[]{"Exception"}, e);
            throw bpx;
        }
    }

    public IInvocation createXPathCopyChildrenWithOverwriteInvocation(String iXPathExpression, HashMap iNamespaceMap) throws InteractionException {
        CopyChildrenWithOverwriteOperation operation = new CopyChildrenWithOverwriteOperation();
        IInvocation invocation = this.createCommonInvocation(iXPathExpression, iNamespaceMap, operation, 6);
        return invocation;
    }

    public IInvocation createXPathCopyChildrenInvocation(String iXPathExpression, HashMap iNamespaceMap) throws InteractionException {
        CopyChildrenOperation operation = new CopyChildrenOperation();
        IInvocation invocation = this.createCommonInvocation(iXPathExpression, iNamespaceMap, operation, 6);
        return invocation;
    }
}

