/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.interaction.query;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ode.bpe.interaction.AmbiguousNodeException;
import org.apache.ode.bpe.interaction.query.IDocumentQuery;
import org.apache.ode.bpe.interaction.query.INodeBuilder;
import org.apache.ode.bpe.interaction.query.JaxenNodeBuilder;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.XPathFunctionContext;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JaxenXPathSingleNodeQuery
implements IDocumentQuery,
Serializable {
    static final long serialVersionUID = 8007784523598625657L;
    private HashMap m_namespaceMap = null;
    private SimpleNamespaceContext m_namespaceContext = null;
    private transient Map DOMXPathHM;
    private String m_expression;
    private boolean m_shouldCreateNode = false;
    private INodeBuilder m_nodeBuilder = null;

    public JaxenXPathSingleNodeQuery() {
    }

    public JaxenXPathSingleNodeQuery(String iXPathExpression, HashMap iNamespaceMap) throws Exception {
        this.setNamespaceMap(iNamespaceMap);
        this.setXPathExpression(iXPathExpression);
    }

    public JaxenXPathSingleNodeQuery(String XPathExpression, HashMap namespaceMap, DOMXPath locator) throws Exception {
        this.setNamespaceMap(namespaceMap);
        this.setXPathExpression(XPathExpression);
        this.setLocator(locator);
    }

    public void setLocator(DOMXPath locator) {
        locator.setFunctionContext((FunctionContext)new XPathFunctionContext());
        if (this.DOMXPathHM == null) {
            this.DOMXPathHM = Collections.synchronizedMap(new HashMap());
        }
        this.DOMXPathHM.put(Thread.currentThread(), locator);
    }

    public DOMXPath createLocator() throws Exception {
        DOMXPath locator;
        if (this.DOMXPathHM == null) {
            this.DOMXPathHM = Collections.synchronizedMap(new HashMap());
        }
        if ((locator = (DOMXPath)this.DOMXPathHM.get(Thread.currentThread())) == null && this.m_expression != null && this.m_namespaceMap != null) {
            locator = new DOMXPath(this.getXPathExpression());
            locator.setNamespaceContext(this.createNamespaceContext());
            locator.setFunctionContext((FunctionContext)new XPathFunctionContext());
            this.DOMXPathHM.put(Thread.currentThread(), locator);
        }
        return locator;
    }

    public String getXPathExpression() throws Exception {
        return this.m_expression;
    }

    public void setXPathExpression(String iExpression) throws Exception {
        this.m_expression = iExpression;
        this.createLocator();
    }

    public void setShouldCreateNode(boolean iShouldCreateNode) {
        this.m_shouldCreateNode = iShouldCreateNode;
    }

    public boolean getShouldCreateNode() {
        return this.m_shouldCreateNode;
    }

    public NamespaceContext createNamespaceContext() {
        if (this.m_namespaceContext == null) {
            this.m_namespaceContext = new SimpleNamespaceContext((Map)this.m_namespaceMap);
        }
        return this.m_namespaceContext;
    }

    public void setNamespaceMap(HashMap iNamespaceMap) throws Exception {
        this.m_namespaceMap = iNamespaceMap;
        this.createNamespaceContext();
        this.createLocator();
    }

    public HashMap getNamespaceMap() {
        return this.m_namespaceMap;
    }

    public static Object runSingleNodeQuery(DOMXPath iQuery, Document iDocument, String xpath) throws Exception {
        Object result = iQuery.evaluate((Object)iDocument);
        Object resultObject = null;
        if (result instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)result;
            if (arrayList.size() > 1) {
                throw new AmbiguousNodeException(new Object[]{xpath});
            }
            Iterator iterator = ((AbstractList)arrayList).iterator();
            if (iterator.hasNext()) {
                resultObject = iterator.next();
            }
        } else {
            resultObject = result.equals(Collections.EMPTY_LIST) ? null : result;
        }
        return resultObject;
    }

    public Object runQuery(Document iDocument) throws Exception {
        DOMXPath xpath = this.createLocator();
        return JaxenXPathSingleNodeQuery.runSingleNodeQuery(xpath, iDocument, this.m_expression);
    }

    private synchronized void createNodeBuilder() throws JaxenException {
        if (this.m_nodeBuilder == null) {
            this.m_nodeBuilder = new JaxenNodeBuilder(this.m_namespaceMap, this.m_expression);
        }
    }

    public Node buildQueriedNode(Document iDocument) throws Exception {
        if (this.m_nodeBuilder == null) {
            this.createNodeBuilder();
        }
        return this.m_nodeBuilder.buildNode(iDocument);
    }
}

