/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.interaction.spiadapter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.ode.bpe.client.DescribedValue;
import org.apache.ode.bpe.client.IDescribedValue;
import org.apache.ode.bpe.client.IFormattableValue;
import org.apache.ode.bpe.client.spi.interaction.ISPIInteraction;
import org.apache.ode.bpe.client.spi.interaction.ISPIQuery;
import org.apache.ode.bpe.context.ICloneable;
import org.apache.ode.bpe.context.base.ContextServiceException;
import org.apache.ode.bpe.interaction.IInteraction;
import org.apache.ode.bpe.interaction.IInvocation;
import org.apache.ode.bpe.interaction.IObjectAccessible;
import org.apache.ode.bpe.interaction.IObjectMutable;
import org.apache.ode.bpe.interaction.InteractionException;
import org.apache.ode.bpe.interaction.query.IQuery;
import org.apache.ode.bpe.interaction.query.JaxenXPathSingleNodeQuery;
import org.apache.ode.bpe.interaction.spiadapter.FormattableValueAdapter;
import org.apache.ode.bpe.interaction.spiadapter.JaxenQuery;
import org.apache.ode.bpe.interaction.spiimpl.CannedFormattableValue;
import org.apache.ode.bpe.interaction.spiimpl.MasterInteractionFactory;
import org.apache.ode.bpe.util.ObjectInputStreamContextClassLoader;
import org.w3c.dom.Document;

public class SPIAdapterInteraction
implements IInteraction,
Serializable,
ICloneable,
IObjectAccessible,
IObjectMutable {
    static final long serialVersionUID = -6159197689519493325L;
    private ISPIInteraction m_spi;
    static /* synthetic */ Class class$org$w3c$dom$Document;

    public SPIAdapterInteraction() {
    }

    public SPIAdapterInteraction(ISPIInteraction interaction) {
        this.m_spi = interaction;
    }

    public Object invoke(IInvocation iInvocation) throws InteractionException {
        Object returnValue = this.invoke(iInvocation, null);
        return returnValue;
    }

    public Object invoke(IInvocation iInvocation, Object iInput) throws InteractionException {
        if (!(iInput instanceof IFormattableValue) && iInput != null) {
            iInput = new CannedFormattableValue(iInput);
        }
        Object returnValue = this.internalInvoke(iInvocation, (IFormattableValue)iInput);
        return returnValue;
    }

    public void releaseResources() throws InteractionException {
        this.m_spi.releaseHeldResources();
    }

    protected Object internalInvoke(IInvocation invocation, IFormattableValue input) {
        IFormattableValue returnValue = null;
        ISPIQuery query = this.createSPIQuery(invocation.getQuery());
        switch (invocation.getType()) {
            case 1: {
                if (this.m_spi == null) {
                    returnValue = null;
                    break;
                }
                if (!this.m_spi.supportsGetSimpleValue(query)) {
                    this.normalizeInteraction();
                }
                returnValue = this.m_spi.getSimpleValue(query);
                break;
            }
            case 3: {
                if (this.m_spi == null) {
                    returnValue = null;
                    break;
                }
                if (!this.m_spi.supportsGetComplexValue(query)) {
                    this.normalizeInteraction();
                }
                returnValue = this.m_spi.getComplexValue(query);
                break;
            }
            case 8: {
                returnValue = this.getContentObject();
                break;
            }
            case 6: {
                if (this.m_spi == null) {
                    this.createEmptyInteraction();
                }
                if (!this.m_spi.supportsCopySubElements(query, input)) {
                    this.normalizeInteraction();
                }
                this.m_spi.copySubElements(query, input);
                break;
            }
            case 2: {
                if (this.m_spi == null) {
                    this.createEmptyInteraction();
                }
                if (!this.m_spi.supportsSetSimpleValue(query, input)) {
                    this.normalizeInteraction();
                }
                this.m_spi.setSimpleValue(query, input);
                break;
            }
            case 4: {
                if (this.m_spi == null) {
                    this.createEmptyInteraction();
                }
                if (!this.m_spi.supportsSetComplexValue(query, input)) {
                    this.normalizeInteraction();
                }
                this.m_spi.setComplexValue(query, input);
                break;
            }
            case 5: {
                if (this.m_spi == null) {
                    returnValue = null;
                }
                if (!this.m_spi.supportsRemoveValue(query)) {
                    this.normalizeInteraction();
                }
                this.m_spi.removeValue(query);
                break;
            }
            case 7: {
                this.setContentObject(input);
            }
        }
        if (returnValue != null) {
            returnValue = new FormattableValueAdapter(returnValue);
        }
        return returnValue;
    }

    private IFormattableValue getContentObject() {
        IFormattableValue returnValue = this.m_spi == null ? null : this.m_spi.getValue();
        return returnValue;
    }

    private void normalizeInteraction() {
        Document documentValue = (Document)this.m_spi.getValue().getValueAs(class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = SPIAdapterInteraction.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document);
        DescribedValue dv = new DescribedValue(documentValue);
        this.m_spi = MasterInteractionFactory.newInstance().createInteraction(dv);
    }

    private void createEmptyInteraction() {
        this.m_spi = MasterInteractionFactory.newInstance().createAnyTypeInteraction();
    }

    protected ISPIQuery createSPIQuery(IQuery query) {
        JaxenQuery jq = null;
        if (query != null) {
            jq = new JaxenQuery((JaxenXPathSingleNodeQuery)query);
        }
        return jq;
    }

    public Object cloneObject() throws ContextServiceException {
        ISPIInteraction newspi = !this.m_spi.supportsCloneSPIInteraction() ? this.cloneSPI() : this.m_spi.cloneSPIInteraction();
        return new SPIAdapterInteraction(newspi);
    }

    private ISPIInteraction cloneSPI() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.m_spi);
            oos.close();
            byte[] bytes = baos.toByteArray();
            baos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStreamContextClassLoader ois = new ObjectInputStreamContextClassLoader(bais);
            ISPIInteraction newInteraction = (ISPIInteraction)ois.readObject();
            ois.close();
            bais.close();
            return newInteraction;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object getObject() throws InteractionException {
        return this.getContentObject();
    }

    public Object getObject(String iPreference) throws InteractionException {
        Object returnValue = null;
        returnValue = iPreference == null || iPreference.equals("") || "formattableValue".equalsIgnoreCase(iPreference.toLowerCase()) ? this.getUserValue() : ("obj".equalsIgnoreCase(iPreference) ? this.getUserValue().getDescribedValue().getData() : ("buf".equalsIgnoreCase(iPreference) ? (Object)this.m_spi.toString().getBytes() : ("interaction".equalsIgnoreCase(iPreference) ? this : this.getUserValue().getDescribedValue().getData())));
        return returnValue;
    }

    public String toString() {
        String returnValue = ((Object)this.m_spi.getValue()).toString();
        return returnValue;
    }

    public ISPIInteraction getSPIInteraction() {
        return this.m_spi;
    }

    public void setSPIInteraction(ISPIInteraction spiinteraction) {
        this.m_spi = spiinteraction;
    }

    public IFormattableValue getUserValue() {
        return new FormattableValueAdapter(this.m_spi.getValue());
    }

    public void setObject(Object iObject) throws InteractionException {
        this.setContentObject(iObject);
    }

    private void setContentObject(Object object) {
        IDescribedValue dv = object instanceof IFormattableValue ? ((IFormattableValue)object).getDescribedValue() : (object instanceof IDescribedValue ? (IDescribedValue)object : new DescribedValue(object));
        this.m_spi = MasterInteractionFactory.newInstance().createInteraction(dv);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

