/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.interaction.spiimpl.document;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.ode.bpe.client.IDescribedValue;
import org.apache.ode.bpe.client.IFormat;
import org.apache.ode.bpe.client.formats.XMLFormat;
import org.apache.ode.bpe.client.spi.interaction.ISPIInteraction;
import org.apache.ode.bpe.client.spi.interaction.ISPIInteractionFactory;
import org.apache.ode.bpe.interaction.spiimpl.document.DocumentInteraction;
import org.w3c.dom.Document;

public class DocumentInteractionFactory
implements ISPIInteractionFactory {
    static final long serialVersionUID = -4030617350592369896L;

    public ISPIInteraction createAnyTypeInteraction() {
        return new DocumentInteraction();
    }

    public ISPIInteraction createInteraction(IDescribedValue describedValue) {
        Object data = describedValue.getData();
        if (data instanceof byte[]) {
            return new DocumentInteraction((byte[])data);
        }
        if (data instanceof String) {
            return new DocumentInteraction(((String)data).getBytes());
        }
        if (data instanceof Document) {
            return new DocumentInteraction((Document)data);
        }
        if (data == null) {
            return this.createAnyTypeInteraction();
        }
        throw new UnsupportedOperationException();
    }

    public boolean supportsInteraction(IDescribedValue describedValue) {
        Object data = describedValue.getData();
        IFormat format = describedValue.getFormat();
        boolean formatIsXML = format != null && format instanceof XMLFormat;
        Properties contentType = describedValue.getContentType();
        if (contentType != null && !((Hashtable)contentType).isEmpty()) {
            return false;
        }
        if (data instanceof Document) {
            return true;
        }
        if (format != null && !(format instanceof XMLFormat)) {
            return false;
        }
        if (data instanceof byte[] && formatIsXML) {
            return true;
        }
        if (data instanceof String && formatIsXML) {
            return true;
        }
        return data == null;
    }

    public boolean supportsAnyType() {
        return true;
    }
}

