/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.ode.bpe.info.PackageInfo;
import org.apache.ode.bpe.info.PackageInfoHome;

public class BPEProperties
extends Properties {
    static final long serialVersionUID = -5037951613080178324L;
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$util$BPEProperties == null ? (class$org$apache$ode$bpe$util$BPEProperties = BPEProperties.class$("org.apache.ode.bpe.util.BPEProperties")) : class$org$apache$ode$bpe$util$BPEProperties).getName());
    public static final String UUID_USE_CONNECTOR_KEY = "UUID_USE_CONNECTOR_KEY";
    public static final String UUID_USE_CONNECTOR_DEFAULT = "false";
    public static final String UUID_CLASS_KEY = "UUID_CLASS_KEY";
    public static final String UUID_CLASS_DEFAULT = "org.apache.ode.bpe.uuid.AXISUUIDService";
    public static final String UUID_SIZE_KEY = "UUID_SIZE_KEY";
    public static final int UUID_SIZE_DEFAULT = 200;
    public static final String DEF_CLASS_KEY = "DEF_CLASS_KEY";
    public static final String DEF_CLASS_DEFAULT = "org.apache.ode.bpe.definition.serialimpl.DefinitionService_SerImpl";
    public static final String DEF_PERSISTENT_KEY = "DEF_PERSISTENT_KEY";
    public static final String DEF_PERSISTENT_DEFAULT = "FALSE";
    public static final String DEF_SCHEMA_KEY = "DEF_SCHEMA_KEY";
    public static final String DEF_SCHEMA_DEFAULT = "BPEL4WS.XSD";
    public static final String INST_CLASS_KEY = "INST_CLASS_KEY";
    public static final String INST_CLASS_DEFAULT = "org.apache.ode.bpe.instance.beanimpl.InstanceServicePersistentImpl";
    public static final String INST_PERSISTENT_KEY = "INST_PERSISTENT_KEY";
    public static final String INST_PERSISTENT_DEFAULT = "FALSE";
    public static final String SCOPE_CLASS_KEY = "SCOPE_CLASS_KEY";
    public static final String SCOPE_CLASS_DEFAULT = "org.apache.ode.bpe.scope.service.impl.ScopeServiceImpl";
    public static final String ED_CLASS_KEY = "ED_CLASS_KEY";
    public static final String ED_CLASS_DEFAULT = "org.apache.ode.bpe.bped.EventDirectorSLImpl";
    public static final String CORL_CLASS_KEY = "CORL_CLASS_KEY";
    public static final String CORL_CLASS_DEFAULT = "org.apache.ode.bpe.correlation.CorrelationServiceSLImpl";
    public static final String LOCK_CLASS_KEY = "LOCK_CLASS_KEY";
    public static final String LOCK_CLASS_DEFAULT = "org.apache.ode.bpe.locking.IMLockingService";
    public static final String LOCK_HASH_BUCKETS_KEY = "LOCK_HASH_BUCKETS_KEY";
    public static final String LOCK_HASH_BUCKETS_DEFAULT = "1000";
    public static final String BPEL_COMPLIANT_KEY = "BPEL_COMPLIANT_KEY";
    public static final String BPEL_COMPLIANT_DEFAULT = "TRUE";
    public static final String CTX_CLASS_TRANSIENT_KEY = "CTX_CLASS_TRANSIENT_KEY";
    public static final String CTX_CLASS_TRANSIENT_DEFAULT = "org.apache.ode.bpe.context.nonpersistent.TransientContextService";
    public static final String CTX_CLASS_PERSISTENT_KEY = "CTX_CLASS_PERSISTENT_KEY";
    public static final String CTX_CLASS_PERSISTENT_DEFAULT = "org.apache.ode.bpe.context.persistent.PersistentContextService";
    public static final String CTX_PERSISTENCE_KEY = "CTX_PERSISTENCE_KEY";
    public static final String CTX_PERSISTENT = "CTX_PERSISTENT";
    public static final String CTX_TRANSIENT = "CTX_TRANSIENT";
    public static final String CTX_PERSISTENCE_GRANULARITY_KEY = "CTX_PERSISTENCE_GRANULARITY_KEY";
    public static final String CTX_MONOLITHIC = "CTX_MONOLITHIC";
    public static final String CTX_INTERMEDIATE = "CTX_INTERMEDIATE";
    public static final String CTX_FINE = "CTX_FINE";
    public static final String DOF_CLASS_PERSISTENT_KEY = "DOF_CLASS_PERSISTENT_KEY";
    public static final String DOF_CLASS_PERSISTENT_DEFAULT = "org.apache.ode.bpe.context.ejb.EJBDataObjectFactory";
    public static final String DOF_CMP_HOME = "java:comp/env/theCMPObjectBean";
    public static final String DOF_BMP_HOME = "java:comp/env/theBMPObjectBean";
    public static final String DOF_EJB_HOME_KEY = "DOF_EJB_HOME_KEY";
    public static final String DOF_EJB_HOME_DEFAULT = "java:comp/env/theCMPObjectBean";
    public static final String INTERACTION_FACTORIES_KEY = "INTERACTION_FACTORIES_KEY";
    public static final String INTERACTION_FACTORIES_DEFAULT = (class$org$apache$ode$bpe$interaction$spiimpl$document$DocumentInteractionFactory == null ? (class$org$apache$ode$bpe$interaction$spiimpl$document$DocumentInteractionFactory = BPEProperties.class$("org.apache.ode.bpe.interaction.spiimpl.document.DocumentInteractionFactory")) : class$org$apache$ode$bpe$interaction$spiimpl$document$DocumentInteractionFactory).getName() + "," + (class$org$apache$ode$bpe$interaction$spiimpl$atomic$AtomicInteractionFactory == null ? (class$org$apache$ode$bpe$interaction$spiimpl$atomic$AtomicInteractionFactory = BPEProperties.class$("org.apache.ode.bpe.interaction.spiimpl.atomic.AtomicInteractionFactory")) : class$org$apache$ode$bpe$interaction$spiimpl$atomic$AtomicInteractionFactory).getName();
    public static final String EXTERNAL_INTERACTION_FACTORIES_KEY = "EXTERNAL_INTERACTION_FACTORIES_KEY";
    public static final String EXTERNAL_INTERACTION_FACTORIES_DEFAULT = "";
    public static final String EXTERNAL_ACTION_BPE_IMPLEMENTATION_KEY = "EXTERNAL_ACTION_BPE_IMPLEMENTATION_KEY";
    public static final String EXTERNAL_ACTION_BPE_IMPLEMENTATION_DEFAULT = "org.apache.ode.action.bpel.ExternalServiceAction";
    public static final String EXTERNAL_ACTION_DEFAULT_IMPLEMENTATION_KEY = "EXTERNAL_ACTION_DEFAULT_IMPLEMENTATION_KEY";
    private Context jndiContext;
    private static final String STRING_TYPE = "java.lang.String";
    private static final String INTEGER_TYPE = "java.lang.Integer";
    private static final String BOOLEAN_TYPE = "java.lang.Boolean";
    private static Map propertiesCache = Collections.synchronizedMap(new HashMap());
    private Properties packageProperties;
    static /* synthetic */ Class class$org$apache$ode$bpe$util$BPEProperties;
    static /* synthetic */ Class class$org$apache$ode$bpe$interaction$spiimpl$document$DocumentInteractionFactory;
    static /* synthetic */ Class class$org$apache$ode$bpe$interaction$spiimpl$atomic$AtomicInteractionFactory;
    static /* synthetic */ Class class$org$apache$ode$bpe$info$PackageInfoHome;

    public static BPEProperties getCachedProperties() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        BPEProperties properties = (BPEProperties)propertiesCache.get(contextClassLoader);
        if (properties == null) {
            InitialContext initialContext = null;
            try {
                initialContext = new InitialContext();
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
            properties = new BPEProperties(true, initialContext);
            propertiesCache.put(contextClassLoader, properties);
        }
        return properties;
    }

    public BPEProperties() {
        this.loadStandAloneProperties();
    }

    public static boolean IsRunningStandAlone() {
        boolean runningStandAlone = false;
        String jnfi_value = System.getProperty("java.naming.factory.initial");
        if (jnfi_value == null || jnfi_value.compareTo("org.apache.ode.bpe.inmemory.jndi.IMContextFactory") == 0) {
            runningStandAlone = true;
        }
        return runningStandAlone;
    }

    protected void loadStandAloneProperties() {
        File file;
        if (BPEProperties.IsRunningStandAlone() && (file = new File("odeEngine.properties")).exists()) {
            try {
                FileInputStream ifstrm = new FileInputStream("odeEngine.properties");
                this.load(ifstrm);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public BPEProperties(boolean initalize, Context initCtx) {
        this.loadStandAloneProperties();
        try {
            try {
                this.jndiContext = (Context)initCtx.lookup("java:comp/env");
            }
            catch (Exception e) {
                logger.warning(e.getLocalizedMessage());
            }
            if (initalize && this.jndiContext != null) {
                NamingEnumeration<Binding> e = initCtx.listBindings("java:comp/env");
                while (e.hasMore()) {
                    Binding b = e.next();
                    this.setProperty(b.getName(), b.getObject(), b.getClassName());
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "- Found JNDI Binding:" + b.getName() + " Value: " + this.getProperty(b.getName()));
                }
            }
        }
        catch (NamingException ne) {
            logger.log(Level.SEVERE, EXTERNAL_INTERACTION_FACTORIES_DEFAULT, ne);
        }
    }

    public boolean getUUIDUseConnector() {
        return this.lookupBoolean(UUID_USE_CONNECTOR_KEY, UUID_USE_CONNECTOR_DEFAULT);
    }

    public void setUUIDUseConnector(boolean value) {
        this.setProperty(UUID_USE_CONNECTOR_KEY, String.valueOf(value));
    }

    public String getUUIDServiceClass() {
        return this.lookupString(UUID_CLASS_KEY, UUID_CLASS_DEFAULT);
    }

    public void setUUIDServiceClass(String value) {
        this.setProperty(UUID_CLASS_KEY, value);
    }

    public int getUUIDCacheSize() {
        return this.lookupInt(UUID_SIZE_KEY, 200);
    }

    public void setUUIDCacheSize(int value) {
        this.setProperty(UUID_SIZE_KEY, String.valueOf(value));
    }

    public String getDefinitionServiceClass() {
        return this.lookupString(DEF_CLASS_KEY, DEF_CLASS_DEFAULT);
    }

    public void setDefinitionServiceClass(String value) {
        this.setProperty(DEF_CLASS_KEY, value);
    }

    public String getDefinitionServicePersistence() {
        return this.lookupString(DEF_PERSISTENT_KEY, "FALSE");
    }

    public void setDefinitionServicePersistence(String value) {
        this.setProperty(DEF_PERSISTENT_KEY, value);
    }

    public String getDefinitionSchema() {
        return this.lookupString(DEF_SCHEMA_KEY, DEF_SCHEMA_DEFAULT);
    }

    public void setDefinitionSchema(String value) {
        this.setProperty(DEF_SCHEMA_KEY, value);
    }

    public String getInstanceServiceClass() {
        return this.lookupString(INST_CLASS_KEY, INST_CLASS_DEFAULT);
    }

    public void setInstanceServiceClass(String value) {
        this.setProperty(INST_CLASS_KEY, value);
    }

    public boolean getInstanceServicePersistence() {
        return this.lookupBoolean(INST_PERSISTENT_KEY, "FALSE");
    }

    public void setInstanceServicePersistence(String value) {
        this.setProperty(INST_PERSISTENT_KEY, value);
    }

    public String getScopeServiceClass() {
        return this.lookupString(SCOPE_CLASS_KEY, SCOPE_CLASS_DEFAULT);
    }

    public void setScopeServiceClass(String value) {
        this.setProperty(SCOPE_CLASS_KEY, value);
    }

    public String getBPELCompliant() {
        return this.lookupString(BPEL_COMPLIANT_KEY, BPEL_COMPLIANT_DEFAULT);
    }

    public void setBPELCompliant(String value) {
        this.setProperty(BPEL_COMPLIANT_KEY, value);
    }

    public String getEventDirectorClass() {
        return this.lookupString(ED_CLASS_KEY, ED_CLASS_DEFAULT);
    }

    public void setEventDirectorClass(String value) {
        this.setProperty(ED_CLASS_KEY, value);
    }

    public String getCorrelationServiceClass() {
        return this.lookupString(CORL_CLASS_KEY, CORL_CLASS_DEFAULT);
    }

    public void setCorrelationServiceClass(String value) {
        this.setProperty(CORL_CLASS_KEY, value);
    }

    public String getLockingServiceClass() {
        return this.lookupString(LOCK_CLASS_KEY, LOCK_CLASS_DEFAULT);
    }

    public void setLockingServiceClass(String value) {
        this.setProperty(LOCK_CLASS_KEY, value);
    }

    public String getLockingServiceHashBuckets() {
        return this.lookupString(LOCK_HASH_BUCKETS_KEY, LOCK_HASH_BUCKETS_DEFAULT);
    }

    public void setLockingServiceHashBuckets(String value) {
        this.setProperty(LOCK_HASH_BUCKETS_KEY, value);
    }

    public String getTransientContextServiceClass() {
        return this.lookupString(CTX_CLASS_TRANSIENT_KEY, CTX_CLASS_TRANSIENT_DEFAULT);
    }

    public void setTransientContextServiceClass(String value) {
        this.setProperty(CTX_CLASS_TRANSIENT_KEY, value);
    }

    public String getPersistentContextServiceClass() {
        return this.lookupString(CTX_CLASS_PERSISTENT_KEY, CTX_CLASS_PERSISTENT_DEFAULT);
    }

    public void setPersistentContextServiceClass(String value) {
        this.setProperty(CTX_CLASS_PERSISTENT_KEY, value);
    }

    public String getDataObjectFactoryClass() {
        return this.lookupString(DOF_CLASS_PERSISTENT_KEY, DOF_CLASS_PERSISTENT_DEFAULT);
    }

    public void setDataObjectFactoryClass(String value) {
        this.setProperty(DOF_CLASS_PERSISTENT_KEY, value);
    }

    public String getInteractionFactories() {
        return this.lookupString(INTERACTION_FACTORIES_KEY, INTERACTION_FACTORIES_DEFAULT);
    }

    public String getExternalInteractionFactories() {
        return this.lookupString(EXTERNAL_INTERACTION_FACTORIES_KEY, EXTERNAL_INTERACTION_FACTORIES_DEFAULT);
    }

    public String getExternalActionBPEImplementation() {
        return this.lookupString(EXTERNAL_ACTION_BPE_IMPLEMENTATION_KEY, EXTERNAL_ACTION_BPE_IMPLEMENTATION_DEFAULT);
    }

    public String getExternalActionDefaultImplementation() {
        return this.lookupString(EXTERNAL_ACTION_DEFAULT_IMPLEMENTATION_KEY, null);
    }

    public String getDataObjectFactoryEJBHome() {
        return this.lookupString(DOF_EJB_HOME_KEY, "java:comp/env/theCMPObjectBean");
    }

    public void setDataObjectFactoryEJBHome(String value) {
        this.setProperty(DOF_EJB_HOME_KEY, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getPackageProperties() {
        if (this.packageProperties == null) {
            try {
                BPEProperties bPEProperties = this;
                synchronized (bPEProperties) {
                    if (this.packageProperties == null) {
                        InitialContext ic = new InitialContext();
                        Object o = ic.lookup("java:comp/env/thePackageInfo");
                        PackageInfoHome pilh = (PackageInfoHome)PortableRemoteObject.narrow((Object)o, (Class)(class$org$apache$ode$bpe$info$PackageInfoHome == null ? (class$org$apache$ode$bpe$info$PackageInfoHome = BPEProperties.class$("org.apache.ode.bpe.info.PackageInfoHome")) : class$org$apache$ode$bpe$info$PackageInfoHome));
                        PackageInfo pil = pilh.create();
                        this.packageProperties = pil.getProperties();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.packageProperties;
    }

    private String lookupString(String key, String defaultValue) {
        String ret = null;
        ret = this.getProperty(key);
        if (ret == null && this.jndiContext != null) {
            try {
                ret = (String)this.jndiContext.lookup(key);
            }
            catch (Exception e) {
                logger.warning(e.getLocalizedMessage());
            }
        }
        return ret == null ? defaultValue : ret;
    }

    private int lookupInt(String key, int defaultValue) {
        Integer ret = null;
        String value = this.getProperty(key);
        if (value == null) {
            if (this.jndiContext != null) {
                try {
                    ret = (Integer)this.jndiContext.lookup(key);
                }
                catch (Exception e) {
                    logger.warning(e.getLocalizedMessage());
                }
            }
        } else {
            ret = new Integer(value);
        }
        return ret == null ? defaultValue : ret;
    }

    private boolean lookupBoolean(String key, String defaultValue) {
        Boolean ret = null;
        String value = this.getProperty(key);
        if (value == null) {
            if (this.jndiContext != null) {
                try {
                    ret = (Boolean)this.jndiContext.lookup(key);
                }
                catch (Exception e) {
                    logger.warning(e.getLocalizedMessage());
                }
            }
        } else {
            ret = new Boolean(value);
        }
        return ret == null ? Boolean.getBoolean(defaultValue) : ret;
    }

    private void setProperty(String key, Object value, String type) {
        if (type == null) {
            return;
        }
        if (type.equals(STRING_TYPE)) {
            String putValue = (String)value;
            putValue = ((String)value).replaceAll("\\\\", EXTERNAL_INTERACTION_FACTORIES_DEFAULT);
            this.setProperty(key, putValue);
            return;
        }
        if (type.equals(INTEGER_TYPE)) {
            this.setProperty(key, ((Integer)value).toString());
            return;
        }
        if (type.equals(BOOLEAN_TYPE)) {
            this.setProperty(key, ((Boolean)value).toString());
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

