/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.apache.ode.bpe.bped.DeployTypeEnum;
import org.apache.ode.bpe.bped.EventDirector;
import org.apache.ode.bpe.bped.EventDirectorException;
import org.apache.ode.bpe.bped.EventDirectorFactory;
import org.apache.ode.bpe.bped.IDeployer;
import org.apache.ode.bpe.deployment.DefinitionKey;
import org.apache.ode.bpe.event.BPELStaticKey;
import org.apache.ode.bpe.event.IResponseMessage;
import org.apache.ode.bpe.event.SimpleRequestMessageEvent;
import org.apache.ode.bpe.interaction.IInteraction;
import org.apache.ode.bpe.interaction.InteractionFactory;
import org.apache.ode.bpe.util.BPException;
import org.apache.ode.bpe.util.PerfTimer;

public class BenchMarkUtil {
    private static InteractionFactory interactionfactory = InteractionFactory.newInstance();
    private File defJar;
    private boolean remote;
    private ArrayList messages = new ArrayList();
    private int iterations = 500;

    public static void main(String[] args) {
        BenchMarkUtil eu = new BenchMarkUtil();
        eu.run(args);
    }

    private void run(String[] args) {
        this.parseCmdLine(args);
        try {
            int i;
            EventDirector ed = this.remote ? EventDirectorFactory.createRemoteEventDirector() : EventDirectorFactory.createEventDirector();
            IDeployer deployer = ed.getDeployer(DeployTypeEnum.BPEL);
            if (this.defJar != null) {
                Collection keys = deployer.loadDefinition(new FileInputStream(this.defJar), false);
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    DefinitionKey key = (DefinitionKey)it.next();
                    System.out.println("Id for deployed defintion " + key.getLabel() + " is " + key.getKey());
                    if (this.remote) continue;
                    deployer.setStateless(key.getKey());
                }
            }
            Iterator it = ((AbstractList)this.messages).iterator();
            SimpleRequestMessageEvent msgEvent = null;
            if (it.hasNext()) {
                String partName;
                Properties msg = new Properties();
                msg.load(new FileInputStream((File)it.next()));
                BPELStaticKey bsk = new BPELStaticKey();
                bsk.setTargetNamespace(msg.getProperty("target.name.space"));
                bsk.setPortType(msg.getProperty("port.type"));
                bsk.setOperation(msg.getProperty("operation"));
                msgEvent = new SimpleRequestMessageEvent();
                msgEvent.setStaticKey(bsk);
                i = 1;
                while ((partName = msg.getProperty("part" + String.valueOf(i++))) != null) {
                    String[] partSplit = partName.split("\\.");
                    if (partSplit.length < 2) {
                        System.out.println("part name requires a type prefix");
                        break;
                    }
                    IInteraction ior = null;
                    if (partSplit[0].equals("xml")) {
                        ior = interactionfactory.createXMLInteraction(msg.getProperty(partName).getBytes());
                    } else if (partSplit[0].equals("str")) {
                        ior = interactionfactory.createObjectInteraction(msg.getProperty(partName));
                    }
                    msgEvent.setPart(partSplit[1], ior);
                }
            }
            this.profile();
            IResponseMessage er = ed.sendEvent(msgEvent, true);
            PerfTimer timer = new PerfTimer();
            timer.start();
            for (i = 0; i < this.iterations; ++i) {
                ed.sendEvent(msgEvent, true);
            }
            System.out.println(timer.getTimeSum("BenchMarkUtil", this.iterations));
            System.out.println();
            System.out.println("Return message:");
            System.out.println(er.toString());
        }
        catch (EventDirectorException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (BPException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseCmdLine(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h")) {
                    this.help();
                    continue;
                }
                if (args[i].equals("-d")) {
                    this.defJar = new File(args[++i]);
                    if (this.defJar.isFile() && this.defJar.canRead()) continue;
                    this.help();
                    continue;
                }
                if (args[i].equals("-r")) {
                    this.remote = true;
                    continue;
                }
                if (args[i].equals("-x")) continue;
                if (args[i].equals("-t")) {
                    this.iterations = Integer.parseInt(args[++i]);
                    continue;
                }
                while (i < args.length) {
                    File f = new File(args[i]);
                    if (f.isFile() && f.canRead()) {
                        this.messages.add(f);
                    } else {
                        this.help();
                    }
                    ++i;
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.help();
        }
    }

    private void help() {
        System.out.println("EnginUtil [-d deployFile][-r] [-x defId] [msgFile]...");
        System.out.println("-d deployFile - the definition deploy zip file ");
        System.out.println("-r - specifiy if you are connecting to a remote engine");
        System.out.println("-t - specifiy the number of times the message is sent");
        System.out.println("-x defId - delete a defintion out of the defintion repository");
        System.out.println("Specifiy 0..n message to send");
        System.exit(0);
    }

    private void profile() {
    }
}

