/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ContextLocalStorage {
    private static Map globalMap = Collections.synchronizedMap(new HashMap());

    public static Object Get(Object key) {
        Object value = ContextLocalStorage.GetContextLocalMap().get(key);
        return value;
    }

    public static void Put(Object key, Object value) {
        ContextLocalStorage.GetContextLocalMap().put(key, value);
    }

    public static void Remove(Object key) {
        ContextLocalStorage.GetContextLocalMap().remove(key);
    }

    public static void Clear() {
        ContextLocalStorage.GetContextLocalMap().clear();
    }

    private static Map GetContextLocalMap() {
        Object key = ContextLocalStorage.getContextMapKey();
        Map localMap = (Map)globalMap.get(key);
        if (localMap == null) {
            localMap = ContextLocalStorage.CreateContextLocalMap();
        }
        return localMap;
    }

    private static synchronized Map CreateContextLocalMap() {
        Object key = ContextLocalStorage.getContextMapKey();
        Map localMap = (Map)globalMap.get(key);
        if (localMap == null) {
            localMap = Collections.synchronizedMap(new HashMap());
            globalMap.put(key, localMap);
        }
        return localMap;
    }

    private static Object getContextMapKey() {
        ClassLoader key = Thread.currentThread().getContextClassLoader();
        if (key == null) {
            throw new UnsupportedOperationException();
        }
        return key;
    }
}

