/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.util;

import java.util.logging.LogManager;

public class TraceLog {
    private static String TRACE_LOG = "bpe.trace.log";
    private static boolean enabled = Boolean.valueOf(LogManager.getLogManager().getProperty(TRACE_LOG));

    public static void println(String iValue) {
        if (TraceLog.enabled()) {
            System.out.println("TRACELOG: " + iValue);
        }
    }

    public static void println(Class iClass, String iValue) {
        if (TraceLog.enabled()) {
            TraceLog.println("Inside " + iClass.getName() + " : " + iValue);
        }
    }

    public static void printlnInside(Class iClass, String iFunction, String iValue) {
        if (TraceLog.enabled()) {
            TraceLog.println(iClass, "function = " + iFunction + " : " + iValue);
        }
    }

    public static void printlnInsideID(Class iClass, String iFunction, String iID, String iValue) {
        if (TraceLog.enabled()) {
            TraceLog.printlnInside(iClass, iFunction, "id = " + iID + " : " + iValue);
        }
    }

    public static void printRefCount(Class iClass, String iFunction, String iID, long iRefCount) {
        if (TraceLog.enabled()) {
            TraceLog.printlnInsideID(iClass, iFunction, iID, " refCount = " + iRefCount);
        }
    }

    public static void printUpdateCount(Class iClass, String iFunction, String iID, long iUpdateCount) {
        if (TraceLog.enabled()) {
            TraceLog.printlnInsideID(iClass, iFunction, iID, " updateCount = " + iUpdateCount);
        }
    }

    public static boolean enabled() {
        return enabled;
    }
}

