/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bpe;

import java.io.File;
import org.apache.servicemix.bpe.BPEComponent;
import org.apache.servicemix.bpe.BPEDeployer;
import org.apache.servicemix.bpe.BPELifeCycle;
import org.apache.servicemix.common.BaseLifeCycle;
import org.apache.servicemix.common.ServiceUnit;
import org.springframework.core.io.Resource;

public class BPESpringComponent
extends BPEComponent {
    private String name;
    private Resource bpelResource;

    protected BaseLifeCycle createLifeCycle() {
        return new LifeCycle();
    }

    public Resource getBpelResource() {
        return this.bpelResource;
    }

    public void setBpelResource(Resource bpelResource) {
        this.bpelResource = bpelResource;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public class LifeCycle
    extends BPELifeCycle {
        protected ServiceUnit su;

        public LifeCycle() {
            super(BPESpringComponent.this);
        }

        protected void doInit() throws Exception {
            super.doInit();
            if (BPESpringComponent.this.bpelResource == null) {
                throw new IllegalArgumentException("bpelResource must be configured");
            }
            File bpelFile = BPESpringComponent.this.bpelResource.getFile();
            String fileName = bpelFile.getName();
            if (!fileName.endsWith(".bpel")) {
                throw new IllegalArgumentException("bpelResource must resolve to a .bpel file");
            }
            if (BPESpringComponent.this.name == null) {
                BPESpringComponent.this.name = fileName.substring(0, fileName.length() - 5);
            }
            this.su = new BPEDeployer(BPESpringComponent.this).deploy(BPESpringComponent.this.name, bpelFile.getParent());
            BPESpringComponent.this.getRegistry().registerServiceUnit(this.su);
        }

        protected void doStart() throws Exception {
            super.doStart();
            this.su.start();
        }

        protected void doStop() throws Exception {
            this.su.stop();
            super.doStop();
        }

        protected void doShutDown() throws Exception {
            this.su.shutDown();
            super.doShutDown();
        }
    }
}

