/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.action.bpel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.external.ActionSystemException;
import org.apache.ode.bpe.action.external.IExternalAction;
import org.apache.ode.bpe.action.external.IURIResolver;
import org.apache.ode.bpe.action.internal.ActionException;
import org.apache.ode.bpe.action.internal.IInternalAction;
import org.apache.ode.bpe.action.param.ActionParamFactory;
import org.apache.ode.bpe.action.param.IActionParam;
import org.apache.ode.bpe.context.IContainer;
import org.apache.ode.bpe.context.IContextService;
import org.apache.ode.bpe.context.IPart;
import org.apache.ode.bpe.context.resolver.ContextResolvedObject;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.correlation.keys.CorrelationKeysUtil;
import org.apache.ode.bpe.definition.IPMDAction;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.service.DefinitionURIResolver;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.interaction.IInteraction;
import org.apache.ode.bpe.interaction.spiadapter.SPIAdapterInteraction;
import org.apache.ode.bpe.scope.service.BPRuntimeException;
import org.apache.ode.bpe.util.BPException;
import org.apache.ode.bpe.wsdl.extensions.BPEInput;
import org.apache.ode.bpe.wsdl.extensions.BPEOutput;

public class ExternalServiceAction
implements IInternalAction {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$action$bpel$ExternalServiceAction == null ? (class$org$apache$ode$bpe$action$bpel$ExternalServiceAction = ExternalServiceAction.class$("org.apache.ode.bpe.action.bpel.ExternalServiceAction")) : class$org$apache$ode$bpe$action$bpel$ExternalServiceAction).getName());
    public static final String IMPL_KEY = "implementation";
    public static final String INPUT_MAP_KEY = "input_map";
    public static final String OUTPUT_MAP_KEY = "output_map";
    public static final String NAMESPACE = "namespace";
    public static final String EXT_ACTION_PROPS = "external_action_properties";
    public static final String OPERATION_KEY = "operation_key";
    public static final String PARTNER_LINK = "partner_link";
    public static final String INVOKE_ATTRIBUTES = "invoke_attributes";
    private IExternalAction action;
    private IURIResolver m_uriResolver;
    private String m_inputVar;
    private String m_outputVar;
    private Collection m_inputMap;
    private Collection m_outputMap;
    private String m_nameSpace;
    private String m_partnerLink;
    private ArrayList operations;
    private String m_operation;
    private String m_service;
    private String m_portType;
    private String m_portTypeNamespace;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$ExternalServiceAction;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;

    public void init(Properties properties) throws BPException {
        this.operations = (ArrayList)((Hashtable)properties).get("operations");
        Object operationKey = ((Hashtable)properties).get(OPERATION_KEY);
        IPMDRoot defRoot = null;
        IPMDAction defAction = (IPMDAction)((Hashtable)properties).get("action_def_key");
        if (defAction != null) {
            defRoot = defAction.getRoot();
            if (operationKey != null && defRoot != null) {
                this.action = defRoot.getExternalAction(operationKey);
            }
        }
        Properties props = (Properties)((Hashtable)properties).get(EXT_ACTION_PROPS);
        this.m_operation = props.getProperty("OperationName");
        this.m_service = props.getProperty("ServiceName");
        this.m_portType = props.getProperty("PortTypeName");
        this.m_portTypeNamespace = props.getProperty("PortTypeNameSpace");
        if (this.action == null) {
            try {
                Class<?> instClass = Class.forName(properties.getProperty(IMPL_KEY));
                this.action = (IExternalAction)instClass.newInstance();
                this.action.init((Properties)((Hashtable)properties).get(EXT_ACTION_PROPS));
                if (defRoot != null && operationKey != null) {
                    defRoot.putExternalAction(operationKey, this.action);
                }
            }
            catch (ClassNotFoundException e) {
                ActionException bpx = new ActionException("CLASS_NOT_FOUND", new Object[]{properties.getProperty(IMPL_KEY)});
                bpx.log(logger, Level.SEVERE);
                throw bpx;
            }
            catch (InstantiationException e) {
                ActionException bpx = new ActionException("NATIVE_EXCEPTION", new Object[]{"InstantiationException"}, e);
                bpx.log(logger, Level.SEVERE);
                throw bpx;
            }
            catch (IllegalAccessException e) {
                ActionException bpx = new ActionException("NATIVE_EXCEPTION", new Object[]{"IllegalAccessException"}, e);
                bpx.log(logger, Level.SEVERE);
                throw bpx;
            }
        }
        this.m_inputVar = properties.getProperty("input_locator");
        this.m_outputVar = properties.getProperty("output_locator");
        this.m_inputMap = (Collection)((Hashtable)properties).get(INPUT_MAP_KEY);
        this.m_outputMap = (Collection)((Hashtable)properties).get(OUTPUT_MAP_KEY);
        this.m_nameSpace = properties.getProperty(NAMESPACE);
        this.m_partnerLink = properties.getProperty(PARTNER_LINK);
    }

    public boolean execute(ContextResolver resolver, IEvaluationContext ec, IProcessCallBack pcb, IPMIProcess processInstance, IPMDProcess processDefinition) throws BPException {
        IContextService cs;
        IContainer root;
        IContainer procroot;
        IPart partnerLinkPart;
        HashMap<String, Object> input = new HashMap<String, Object>();
        HashMap output = new HashMap();
        HashMap<String, Object> inputForCorrl = new HashMap<String, Object>();
        if (this.m_uriResolver == null) {
            this.m_uriResolver = new DefinitionURIResolver(ec.getProcessService().getInstanceService().getDefinitionService().getRootDefinition(processDefinition.getRootKey()));
        }
        ContextResolvedObject data = null;
        BPEInput inputNode = null;
        IActionParam param = null;
        String partName = null;
        Iterator inputItr = this.m_inputMap.iterator();
        while (inputItr.hasNext()) {
            inputNode = (BPEInput)inputItr.next();
            partName = inputNode.getPart() == null ? this.m_inputVar : inputNode.getPart();
            data = (ContextResolvedObject)resolver.resolveBPContext(this.m_inputVar + ":" + partName);
            if (data.getValue() == null) {
                throw new BPException("UNINITIALIZED_INVOKE_ERROR", new Object[]{processDefinition.getRoot().getLabel(), processDefinition.getRoot().getKey().getValue(), processDefinition.getLabel(), this.m_operation, this.m_service, this.m_portType, this.m_portTypeNamespace, this.m_inputVar + ":" + partName});
            }
            param = ActionParamFactory.createActionParam(data, inputNode.getType());
            input.put(partName, param.getParam());
            inputForCorrl.put(partName, data.getValue());
        }
        if (this.operations != null && CorrelationKeysUtil.hasCorrelationSets(this.operations)) {
            CorrelationKeysUtil.setCorrelationKeys(resolver, inputForCorrl, this.operations, "out");
        }
        if ((partnerLinkPart = (IPart)(procroot = (IContainer)(root = (cs = resolver.getContextService()).getRoot()).findChild(processInstance.getRootKey())).findChild(this.m_partnerLink)) != null) {
            Object obj = partnerLinkPart.getObjectForRead();
            input.put("<OOB", obj);
        }
        try {
            this.action.execute(input, output, this.m_uriResolver);
        }
        catch (BPRuntimeException rte) {
            rte.setNameSpace(this.m_nameSpace);
            throw rte;
        }
        catch (ActionSystemException ase) {
            String variables = "";
            Iterator inputItr2 = this.m_inputMap.iterator();
            while (inputItr2.hasNext()) {
                inputNode = (BPEInput)inputItr2.next();
                String string = partName = inputNode.getPart() == null ? this.m_inputVar : inputNode.getPart();
                String varName = this.m_inputVar + ":" + partName;
                data = (ContextResolvedObject)resolver.resolveBPContext(varName);
                Object obj = data.getValue();
                if (!(obj instanceof SPIAdapterInteraction)) continue;
                SPIAdapterInteraction spi = (SPIAdapterInteraction)obj;
                if (spi.getUserValue().supportsGetValueAs(array$B == null ? ExternalServiceAction.class$("[B") : array$B)) {
                    byte[] ba = (byte[])spi.getUserValue().getValueAs(array$B == null ? ExternalServiceAction.class$("[B") : array$B);
                    String str = new String(ba);
                    if (str.length() > 500) {
                        str = str.substring(0, 499);
                    }
                    variables = variables + "Variable: " + varName + " Value: " + str + "\n";
                    continue;
                }
                String str = (String)spi.getUserValue().getValueAs(class$java$lang$String == null ? ExternalServiceAction.class$("java.lang.String") : class$java$lang$String);
                variables = variables + "Variable: " + varName + " Value: " + str + "\n";
            }
            BPException bpe = new BPException("INVOKE_ERROR", new Object[]{processDefinition.getRoot().getLabel(), processDefinition.getRoot().getKey().getValue(), processDefinition.getLabel(), this.m_operation, this.m_service, this.m_portType, this.m_portTypeNamespace, variables});
            logger.severe(bpe.getLocalizedMessage());
            throw ase;
        }
        HashMap<String, IInteraction> outputForCorrl = new HashMap<String, IInteraction>();
        Object ret = null;
        Iterator outputItr = this.m_outputMap.iterator();
        while (outputItr.hasNext()) {
            BPEOutput outputNode = (BPEOutput)outputItr.next();
            partName = outputNode.getPart() == null ? this.m_outputVar : outputNode.getPart();
            ret = output.get(partName);
            if (ret == null) continue;
            ContextResolvedObject to = (ContextResolvedObject)resolver.resolveBPContext(this.m_outputVar + ":" + partName);
            IInteraction interaction = null;
            if (ret instanceof IInteraction) {
                interaction = ret;
            } else {
                interaction = to.getInteractionFactory().createInteraction();
                param = ActionParamFactory.createActionParam(null, outputNode.getType());
                param.setParam(ret, interaction);
            }
            to.setObject(interaction);
            outputForCorrl.put(partName, interaction);
        }
        if (this.operations != null && CorrelationKeysUtil.hasCorrelationSets(this.operations)) {
            CorrelationKeysUtil.setCorrelationKeys(resolver, outputForCorrl, this.operations, "in");
        }
        return true;
    }

    public void release() {
        this.action.release();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

