/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.action.bpel;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.internal.ActionException;
import org.apache.ode.bpe.action.internal.IInternalAction;
import org.apache.ode.bpe.bped.IInternalEventDirector;
import org.apache.ode.bpe.context.resolver.ContextResolvedObject;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.engine.ProcessInstance;
import org.apache.ode.bpe.engine.StateEnum;
import org.apache.ode.bpe.event.StateEvent;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.util.BPException;

public class MergeAction
implements IInternalAction {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$action$bpel$MergeAction == null ? (class$org$apache$ode$bpe$action$bpel$MergeAction = MergeAction.class$("org.apache.ode.bpe.action.bpel.MergeAction")) : class$org$apache$ode$bpe$action$bpel$MergeAction).getName());
    public static final String LOCATOR = "SyncThreadCounterLocator";
    public static final String THREAD_COUNT_KEY = "SyncThreadCount";
    private Properties props;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$MergeAction;

    public void init(Properties properties) throws ActionException {
        this.props = properties;
    }

    public boolean execute(ContextResolver resolver, IEvaluationContext ec, IProcessCallBack pcb, IPMIProcess processInstance, IPMDProcess processDefinition) throws BPException {
        int syncCount;
        if (logger.isLoggable(Level.FINE)) {
            Enumeration e = ((Hashtable)this.props).elements();
            StringBuffer sb = new StringBuffer();
            while (e.hasMoreElements()) {
                sb.append((String)e.nextElement());
                sb.append("  ");
            }
            logger.fine("Merge Props:" + sb.toString());
        }
        ContextResolvedObject ro = (ContextResolvedObject)resolver.resolveBPContext(LOCATOR);
        int threadCount = 1;
        if (ro.getValue() == null) {
            ro.setObject(new Integer(threadCount));
        } else {
            threadCount = (Integer)ro.getValue();
            ro.setObject(new Integer(++threadCount));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Threads counted: " + threadCount + " Num to sync: " + this.props.getProperty(THREAD_COUNT_KEY));
        }
        if ((syncCount = Integer.valueOf(this.props.getProperty(THREAD_COUNT_KEY)).intValue()) == threadCount) {
            ProcessInstance pi = ec.getProcessService().createSubProcess(processInstance, processDefinition);
            if (this.props.getProperty("WithNewThread") != null) {
                ((IInternalEventDirector)pcb).sendEvent(new StateEvent(pi.getRootKey(), pi.getKey(), StateEnum.STARTED), false);
            } else {
                ec.addProcessInstance(pi);
            }
            ro.setObject(new Integer(0));
        }
        return true;
    }

    public void release() {
        this.props = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

