/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.bped.unmanaged;

import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.bped.IDeployer;
import org.apache.ode.bpe.bped.IInternalEventDirector;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.deployment.DefinitionKey;
import org.apache.ode.bpe.deployment.ResourceDeployer;
import org.apache.ode.bpe.deployment.bpel.BPELDeploy;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.event.LoadDefinitionEvent;
import org.apache.ode.bpe.util.BPException;

public class BPELDeployerSLImpl
implements IDeployer {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$bped$unmanaged$BPELDeployerSLImpl == null ? (class$org$apache$ode$bpe$bped$unmanaged$BPELDeployerSLImpl = BPELDeployerSLImpl.class$("org.apache.ode.bpe.bped.unmanaged.BPELDeployerSLImpl")) : class$org$apache$ode$bpe$bped$unmanaged$BPELDeployerSLImpl).getName());
    private DefinitionService ds;
    private IInternalEventDirector ed;
    static /* synthetic */ Class class$org$apache$ode$bpe$bped$unmanaged$BPELDeployerSLImpl;

    protected BPELDeployerSLImpl(IInternalEventDirector ed) {
        this.ed = ed;
        this.ds = ed.getProcessService().getInstanceService().getDefinitionService();
    }

    public Collection loadDefinition(String resource, boolean validating) throws BPException {
        ResourceDeployer rd = new ResourceDeployer(new BPELDeploy(this.ds));
        Collection keys = null;
        keys = rd.deployResource(resource, validating, null);
        this.loadKeys(keys);
        return keys;
    }

    public Collection loadDefinition(InputStream is, boolean validating) throws BPException {
        Collection keys = null;
        BPELDeploy deployer = new BPELDeploy(this.ds);
        keys = deployer.deployJar(is, validating, null);
        this.loadKeys(keys);
        return keys;
    }

    private void loadKeys(Collection keys) {
        try {
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                DefinitionKey defkey = (DefinitionKey)it.next();
                IPMDRoot rootDef = this.ds.getRootDefinition(new ProcessDefinitionKey(defkey.getKey()));
                this.ed.sendEvent(new LoadDefinitionEvent(rootDef.getProcess().getKey().getValue()), true);
            }
        }
        catch (DeploymentException e) {
            logger.log(Level.SEVERE, "", e);
        }
        catch (DefinitionServiceException e) {
            logger.log(Level.SEVERE, "", e);
        }
        catch (BPException e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public void removeDefinition(String defID) {
        try {
            this.ds.deleteDefinition(new ProcessDefinitionKey(defID));
        }
        catch (BPException e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public void setStateless(String defID) throws BPException {
        IPMDRoot root = this.ds.getRootDefinition(new ProcessDefinitionKey(defID));
        root.setIsStateless(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

