/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.cc.client.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.ode.bpe.cc.client.CCException;
import org.apache.ode.bpe.cc.client.IInstance;
import org.apache.ode.bpe.cc.client.IScope;
import org.apache.ode.bpe.cc.client.impl.ChildScope;
import org.apache.ode.bpe.cc.client.impl.ServiceNode;
import org.apache.ode.bpe.cc.client.impl.Variable;
import org.apache.ode.bpe.cc.data.ScopeData;
import org.apache.ode.bpe.cc.data.VariableData;
import org.apache.ode.bpe.cc.service.ICCService;

public class Scope
extends ServiceNode
implements IScope {
    private IInstance m_instance;
    private ScopeData m_data;

    public Scope(ICCService service, IInstance instance, ScopeData cdata) {
        super(service);
        this.m_instance = instance;
        this.m_data = cdata;
    }

    public Collection getChildScopes() throws CCException {
        Collection childScopes = this.getService().getChildScopes(this.m_data);
        Iterator iter = childScopes.iterator();
        LinkedList<ChildScope> scopeList = new LinkedList<ChildScope>();
        while (iter.hasNext()) {
            ScopeData data = (ScopeData)iter.next();
            ChildScope newScope = new ChildScope(this.getService(), this.m_instance, this, data);
            scopeList.add(newScope);
        }
        return scopeList;
    }

    public Collection getVariables() throws CCException {
        Collection variables = this.getService().getVariables(this.m_data);
        Iterator iter = variables.iterator();
        LinkedList<Variable> variableList = new LinkedList<Variable>();
        while (iter.hasNext()) {
            VariableData vd = (VariableData)iter.next();
            Variable newVariable = new Variable(this.getService(), this, vd);
            variableList.add(newVariable);
        }
        return variableList;
    }

    public IInstance getBPInstance() throws CCException {
        return this.m_instance;
    }

    public String getName() throws CCException {
        return this.m_data.getName();
    }
}

