/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.client;

import java.util.Properties;
import org.apache.ode.bpe.client.IBPEClient;
import org.apache.ode.bpe.client.IBPEMessage;
import org.apache.ode.bpe.client.IBPEMessagePart;
import org.apache.ode.bpe.client.IDescribedValue;
import org.apache.ode.bpe.client.IOperation;
import org.apache.ode.bpe.client.exceptions.BPEClientInstantiationException;
import org.apache.ode.bpe.client.exceptions.BPEUserException;
import org.apache.ode.bpe.client.impl.def.DefaultBPEClientFactory;
import org.apache.ode.bpe.client.spi.IBPEClientFactory;

public class BPEClient
implements IBPEClient {
    private IBPEClient m_impl = null;
    private IBPEClientFactory m_factory = null;
    private Properties m_spec = null;

    public BPEClient() throws BPEUserException {
        this.m_spec = new Properties();
        this.setup();
    }

    public BPEClient(Properties spec) throws BPEUserException {
        this.m_spec = spec;
        this.setup();
    }

    private void setup() throws BPEUserException {
        String factoryName = this.m_spec.getProperty("BPEClientFactory");
        if (factoryName != null) {
            try {
                this.m_factory = (IBPEClientFactory)Class.forName(factoryName).newInstance();
            }
            catch (Exception e) {
                throw new BPEClientInstantiationException(e);
            }
        } else {
            this.m_factory = new DefaultBPEClientFactory();
        }
        this.m_impl = this.m_factory.createBPEClient(this.m_spec);
    }

    public IBPEMessage createMessage() {
        return this.m_impl.createMessage();
    }

    public IOperation createOperation(Properties spec) {
        return this.m_impl.createOperation(spec);
    }

    public IBPEMessagePart createPart(String name, IDescribedValue value) {
        return this.m_impl.createPart(name, value);
    }
}

