/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.client.util;

import java.io.ByteArrayInputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.ode.bpe.client.BPEClient;
import org.apache.ode.bpe.client.DescribedValue;
import org.apache.ode.bpe.client.IBPEClient;
import org.apache.ode.bpe.client.IBPEMessage;
import org.apache.ode.bpe.client.IBPEMessagePart;
import org.apache.ode.bpe.client.IFormat;
import org.apache.ode.bpe.client.IOperation;
import org.apache.ode.bpe.client.exceptions.BPEUserException;
import org.apache.ode.bpe.client.formats.INativeFormat;
import org.apache.ode.bpe.client.result.IResult;
import org.apache.ode.bpe.client.util.IBPEInvoker;
import org.apache.ode.bpe.util.XMLDocBuilderByThread;
import org.xml.sax.InputSource;

public class BPEInvoker
implements IBPEInvoker {
    protected IBPEClient client;
    protected Properties operationSpec;
    protected IOperation operation;
    protected IBPEMessage message;
    protected LinkedList parts = new LinkedList();

    public BPEInvoker() throws BPEUserException {
    }

    public void setInvocationSpec(Properties invocationSpec) throws BPEUserException {
        this.operationSpec = invocationSpec;
        this.client = new BPEClient(invocationSpec);
        this.operation = this.createOperation(invocationSpec);
    }

    public BPEInvoker(Properties operationSpec) throws BPEUserException {
        this.client = new BPEClient(operationSpec);
        this.operationSpec = operationSpec;
        this.operation = this.createOperation(operationSpec);
    }

    private IOperation createOperation(Properties operationSpec) throws BPEUserException {
        if (this.operation == null) {
            this.operation = this.getClient().createOperation(operationSpec);
        }
        return this.operation;
    }

    public IResult invoke() throws BPEUserException {
        IResult result = this.operation.invoke(this.getMessage());
        return result;
    }

    private IBPEMessage getMessage() throws BPEUserException {
        if (this.message == null) {
            this.message = this.getClient().createMessage();
            Iterator iter = this.getParts().iterator();
            while (iter.hasNext()) {
                IBPEMessagePart part = (IBPEMessagePart)iter.next();
                this.message.addPart(part);
            }
        }
        return this.message;
    }

    private LinkedList getParts() {
        return this.parts;
    }

    protected IBPEClient getClient() {
        return this.client;
    }

    public void clear() {
        this.message = null;
        this.parts.clear();
    }

    public void addPart(String partName, Object data, Properties partSpec) {
        String formatName = partSpec.getProperty("formatName");
        IFormat format = null;
        if (formatName.equals("xml")) {
            format = INativeFormat.XML;
            ByteArrayInputStream bai = new ByteArrayInputStream(((String)data).getBytes());
            InputSource in = new InputSource(bai);
            try {
                data = XMLDocBuilderByThread.getDocBuilder().parse(in);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (formatName.equals("atomic")) {
            format = INativeFormat.ATOMIC;
        }
        DescribedValue dv = new DescribedValue(data, format);
        IBPEMessagePart part = this.getClient().createPart(partName, dv);
        this.parts.add(part);
    }
}

