/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.test;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.apache.ode.bpe.context.IContainer;
import org.apache.ode.bpe.context.IContextService;
import org.apache.ode.bpe.context.IHandle;
import org.apache.ode.bpe.context.INode;
import org.apache.ode.bpe.context.IPart;
import org.apache.ode.bpe.context.base.ContextServiceException;
import org.apache.ode.bpe.context.base.ContextServiceFactory;
import org.apache.ode.bpe.context.base.TestUtil;
import org.apache.ode.bpe.context.test.IInteractionObjectFactory;
import org.apache.ode.bpe.context.test.IServiceFactory;
import org.apache.ode.bpe.context.test.SerializationContext;
import org.apache.ode.bpe.interaction.IInteraction;
import org.apache.ode.bpe.interaction.InteractionFactory;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.uuid.UUIDServiceException;
import org.apache.ode.bpe.uuid.UUIDServiceFactory;

public abstract class ContextServiceTest
implements IServiceFactory,
IInteractionObjectFactory {
    private SerializationContext m_serializationContext = null;
    protected OutputStream m_outputStream = null;
    private IContextService m_contextService = null;
    private static final String PROCESS_ROOT = "BP1";
    private static final String STRING_DATA_1 = "String1.";
    private static final String STRING_DATA_2 = "String2.";
    private static final String STRING_DATA_3 = "String3.";
    private static final String PART1_ROOT = "BP1/Sub1";
    private static final String PART2_ROOT = "BP1/Sub1";
    private static final String PART3_ROOT = "BP1/Sub2";
    private static final String PART1_RELATIVE_PATH = "/C0/C2/Part1";
    private static final String PART2_RELATIVE_PATH = "/C0/C3/Part2";
    private static final String PART3_RELATIVE_PATH = "/Part3";
    private static final String PART1_PATH = "BP1/Sub1/C0/C2/Part1";
    private static final String PART2_PATH = "BP1/Sub1/C0/C3/Part2";
    private static final String PART3_PATH = "BP1/Sub2/Part3";
    private static final String MODIFIED_PART_NAME = "ModifiedPart";
    private static final String MODIFIED_PART_PATH = "BP1/Sub2/ModifiedPart";
    private static final String COPY_SOURCE = "BP1/Sub1/C0";
    private static final String COPY_TARGET = "BP1/Sub2";
    private static final String COPIED_PART1_PATH = "BP1/Sub2/C0/C2/Part1";
    private static final String COPIED_PART2_PATH = "BP1/Sub2/C0/C3/Part2";
    private static final String MOVE_SOURCE = "BP1/Sub1/C0/C2";
    private static final String MOVE_TARGET = "BP1/Sub1/C0/C3";
    private static final String INTERACTION_PATH = "BP1/Sub1/C0/CX/InteractionPart";
    private BPEProperties m_properties = new BPEProperties();

    public void assertTrue(boolean iCheckThis) throws Exception {
        if (!iCheckThis) {
            throw new Exception("Assertion failed.");
        }
    }

    protected void scrub() throws Exception {
        this.getContextService().getRoot().removeChild(PROCESS_ROOT);
    }

    public ContextServiceTest() {
        this.setOutputStream(System.out);
        if (System.getProperty("os.name").equals("Linux")) {
            this.m_properties.setUUIDServiceClass("org.apache.ode.bpe.uuid.connector.service.LinUUIDService");
        }
    }

    public void setOutputStream(OutputStream iOutputStream) {
        this.m_outputStream = iOutputStream;
        this.m_serializationContext = new SerializationContext(iOutputStream);
    }

    public void buildBaseStructure() throws Exception {
        this.setDataObject(PART1_PATH, STRING_DATA_1);
        this.setDataObjectByHandle(PART2_PATH, STRING_DATA_2);
        this.setDataObjectByHandle(PART3_PATH, STRING_DATA_3);
        this.setDataObjectByHandle(INTERACTION_PATH, this.createInteractionObject());
        this.checkSerialization();
    }

    private void checkSerialization() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        this.m_serializationContext.printComment("Checking Serialzation:");
        INode node = this.lookupNode(PROCESS_ROOT);
        oos.writeObject(node);
        this.m_serializationContext.printComment("Serialized size = " + baos.toByteArray().length);
        this.m_serializationContext.printComment("Serialized tree:");
        this.m_serializationContext.printBytes(baos.toByteArray());
        oos.close();
        baos.close();
        this.m_serializationContext.println("");
    }

    protected OutputStream getOutputStream() {
        return this.m_outputStream;
    }

    private void setDataObject(String iPartLocator, Object iObject) throws Exception {
        IPart part = this.createPart(iPartLocator);
        part.setObject(iObject);
    }

    private void setDataObjectByHandle(String iPartLocator, Object iObject) throws Exception {
        IHandle handle = this.getContextService().createObjectHandle(iObject);
        IPart part = this.createPart(iPartLocator);
        part.setObjectHandle(handle);
    }

    private IPart createPart(String iPartLocator) throws Exception {
        IContextService iService = this.getContextService();
        StringTokenizer tokenizer = new StringTokenizer(iPartLocator, "/");
        INode currentNode = iService.getRoot();
        while (tokenizer.hasMoreTokens()) {
            String currentToken = tokenizer.nextToken();
            IContainer currentContainer = currentNode;
            if (tokenizer.hasMoreTokens()) {
                currentNode = currentContainer.createContainer(currentToken);
                continue;
            }
            currentNode = currentContainer.createPart(currentToken);
        }
        return (IPart)currentNode;
    }

    private IPart lookupPart(String iLocator) throws Exception {
        INode node = this.lookupNode(iLocator);
        this.assertTrue(node != null);
        this.assertTrue(node instanceof IPart);
        IPart part = (IPart)node;
        return part;
    }

    private Object getObjectForRead(String iLocator) throws Exception {
        IPart part = this.lookupPart(iLocator);
        Object obj = part.getObjectForRead();
        return obj;
    }

    private Object getClonedObject(String iLocator) throws Exception {
        IPart part = this.lookupPart(iLocator);
        Object obj = part.getObjectClone();
        return obj;
    }

    private Object getObjectForReadWrite(String iLocator) throws Exception {
        IPart part = this.lookupPart(iLocator);
        Object obj = part.getObjectForReadWrite();
        return obj;
    }

    private INode lookupNode(String iLocator) throws Exception {
        IContextService iService = this.getContextService();
        StringTokenizer tokenizer = new StringTokenizer(iLocator, "/");
        INode currentNode = iService.getRoot();
        while (tokenizer.hasMoreTokens()) {
            IContainer currentContainer = currentNode;
            String currentToken = tokenizer.nextToken();
            if ((currentNode = currentContainer.findChild(currentToken)) != null) continue;
            return null;
        }
        return currentNode;
    }

    private void copy(String iSource, String iTarget) throws Exception {
        IContextService iService = this.getContextService();
        this.m_serializationContext.printComment("Copying " + iSource + " to " + iTarget + ".");
        IContainer targetContainer = (IContainer)this.lookupNode(iTarget);
        INode sourceNode = this.lookupNode(iSource);
        targetContainer.copyNode(sourceNode, sourceNode.getName());
        this.m_serializationContext.serialize(iService);
    }

    protected void verifyCopyOnWrite() throws Exception {
        String s1 = (String)this.getObjectForReadWrite(PART2_PATH);
        this.assertTrue(s1 != STRING_DATA_2 && s1.equals(STRING_DATA_2));
        String s2 = (String)this.getObjectForReadWrite(PART3_PATH);
        this.assertTrue(s2 != STRING_DATA_3 && s2.equals(STRING_DATA_3));
    }

    protected void verifyGetObjectForRead() throws Exception {
        String s2 = (String)this.getObjectForRead(PART2_PATH);
        this.assertTrue(s2.equals(STRING_DATA_2));
    }

    protected void verifyGetObjectForReadWrite() throws Exception {
        String s2 = (String)this.getObjectForReadWrite(PART1_PATH);
        this.assertTrue(s2.equals(STRING_DATA_1));
    }

    protected void verifyCloneObject() throws Exception {
        String s2 = (String)this.getClonedObject(PART2_PATH);
        this.assertTrue(s2.equals(STRING_DATA_2));
    }

    private void verifyDataObject(String iPartLocator, Object iObject) throws Exception {
        this.verifyStringDataObject(iPartLocator, iObject);
    }

    private void verifyStringDataObject(String iPartLocator, Object iObject) throws Exception {
        String obj1 = (String)this.getObjectForRead(iPartLocator);
        String obj2 = (String)iObject;
        this.assertTrue(obj1.equals(obj2));
    }

    private void internalVerifyBaseStructure() throws Exception {
        this.verifyDataObject(PART1_PATH, STRING_DATA_1);
        this.verifyDataObject(PART2_PATH, STRING_DATA_2);
        this.verifyDataObject(PART3_PATH, STRING_DATA_3);
    }

    protected void verifyBaseStructure() throws Exception {
        this.internalVerifyBaseStructure();
    }

    protected void verifyCopy() throws Exception {
        this.copy(COPY_SOURCE, "BP1/Sub2");
        this.internalVerifyBaseStructure();
        this.verifyStringDataObject(COPIED_PART1_PATH, STRING_DATA_1);
        this.verifyStringDataObject(COPIED_PART2_PATH, STRING_DATA_2);
    }

    protected void verifyModifyDataObject() throws Exception {
        this.setDataObject(MODIFIED_PART_PATH, new StringBuffer("1"));
        StringBuffer buffer = (StringBuffer)this.getObjectForReadWrite(MODIFIED_PART_PATH);
        buffer.append("2");
        buffer = (StringBuffer)this.getObjectForReadWrite(MODIFIED_PART_PATH);
        String bufferString = buffer.toString();
        this.assertTrue(bufferString.equals("12"));
    }

    protected void verifyMove() throws Exception {
        INode node = this.lookupNode(MOVE_TARGET);
        this.assertTrue(node != null);
        this.assertTrue(node instanceof IContainer);
        IContainer container = (IContainer)node;
        node = this.lookupNode(MOVE_SOURCE);
        IContainer parent = container.getContainer();
        this.assertTrue(node != null);
        String nodeName = node.getName();
        container.moveNode(node, nodeName);
        node = this.lookupNode(MOVE_SOURCE);
        this.assertTrue(node == null);
        node = this.lookupNode("BP1/Sub1/C0/C3/" + nodeName);
        this.assertTrue(node != null);
        this.internalDumpContext("After move:");
        parent.moveNode(node, nodeName);
        this.internalVerifyBaseStructure();
    }

    protected void verifyRemove() throws Exception {
        INode node = this.lookupNode("BP1/Sub2");
        this.assertTrue(node != null);
        this.assertTrue(node instanceof IContainer);
        IContainer container = (IContainer)node;
        container.removeChild(MODIFIED_PART_NAME);
        node = this.lookupNode(MODIFIED_PART_PATH);
        this.assertTrue(node == null);
    }

    private void checkRefCount(String iLocator, long iExpectedValue) throws Exception {
        INode node = this.lookupNode(iLocator);
        long refCount = TestUtil.getRefCount(node);
        this.assertTrue(refCount == iExpectedValue);
    }

    protected void verifyReferenceCounts() throws Exception {
        this.internalDumpContext("Before verifyRefCount:");
        this.checkRefCount(COPIED_PART1_PATH, 2L);
        this.checkRefCount(COPIED_PART2_PATH, 1L);
        this.checkRefCount(PART3_PATH, 1L);
        this.checkRefCount(PART1_PATH, 2L);
        this.checkRefCount(PART2_PATH, 1L);
        INode node = this.lookupNode("BP1/Sub2");
        IContainer container = (IContainer)node;
        container.removeChild("C0");
        this.internalDumpContext("Just removed BP1/Sub2/C0:");
        this.checkRefCount(PART1_PATH, 1L);
    }

    private IContextService getContextService() throws Exception {
        if (this.m_contextService == null) {
            this.m_contextService = this.createContextService();
        }
        return this.m_contextService;
    }

    protected void setContextService(IContextService iService) {
        this.m_contextService = iService;
    }

    protected void internalDumpContext(String iComment) throws Exception {
        this.lookupNode("BP1/Sub2");
        this.lookupNode("BP1/Sub1");
        this.lookupNode("BP1/Sub1");
        this.m_serializationContext.printComment(iComment);
        this.m_serializationContext.serialize(this.getContextService());
    }

    protected void dumpContext(String iComment) throws Exception {
        this.internalDumpContext(iComment);
    }

    public void go() throws Exception {
        this.scrub();
        this.dumpContext("Initial Context Tree:");
        this.buildBaseStructure();
        this.dumpContext("Base Context Structure:");
        this.verifyBaseStructure();
        this.verifyGetObjectForRead();
        this.verifyCloneObject();
        this.verifyGetObjectForReadWrite();
        this.verifyModifyDataObject();
        this.dumpContext("Modified Data Object:");
        this.verifyCopy();
        this.dumpContext("Copied Tree:");
        this.verifyMove();
        this.dumpContext("Moved and Moved Back:");
        this.verifyRemove();
        this.dumpContext("Removed Node:");
        this.verifyCopyOnWrite();
        this.dumpContext("Did Copy on Write.");
        this.verifyReferenceCounts();
        this.dumpContext("After verifyRefCount:");
        this.runPerformanceTest();
    }

    protected void setProperty(String iName, String iValue) {
        this.m_properties.setProperty(iName, iValue);
    }

    public String getProperty(String iName) {
        return this.m_properties.getProperty(iName);
    }

    public IContextService createContextService() throws ContextServiceException {
        IContextService tService = null;
        try {
            tService = ContextServiceFactory.createContextService(this.getProperties(), UUIDServiceFactory.createUUIDService(this.getProperties()));
        }
        catch (ContextServiceException e) {
            e.printStackTrace();
        }
        catch (UUIDServiceException e) {
            e.printStackTrace();
        }
        return tService;
    }

    public IInteraction createInteractionObject() throws Exception {
        int bytesRead;
        String fileName = this.getProperty("XML_TEST_FILE");
        FileInputStream fis = new FileInputStream(fileName);
        byte[] chunk = new byte[100];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((bytesRead = fis.read(chunk)) > 0) {
            baos.write(chunk, 0, bytesRead);
        }
        InteractionFactory factory = InteractionFactory.newInstance();
        IInteraction interaction = factory.createXMLInteraction(baos.toByteArray());
        baos.close();
        fis.close();
        return interaction;
    }

    private BPEProperties getProperties() {
        return this.m_properties;
    }

    protected abstract void runPerformanceTest() throws Exception;
}

