/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.correlation.keys;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.internal.ActionException;
import org.apache.ode.bpe.context.resolver.ContextResolvedObject;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.correlation.PartQuery;
import org.apache.ode.bpe.definition.IPMDCorrelation;
import org.apache.ode.bpe.definition.IPMDCorrelationSet;
import org.apache.ode.bpe.definition.IPMDOperation;
import org.apache.ode.bpe.interaction.IInteraction;
import org.apache.ode.bpe.interaction.IInvocation;
import org.apache.ode.bpe.interaction.InteractionException;
import org.apache.ode.bpe.interaction.InteractionFactory;
import org.apache.ode.bpe.util.BPException;

public class CorrelationKeysUtil {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$correlation$keys$CorrelationKeysUtil == null ? (class$org$apache$ode$bpe$correlation$keys$CorrelationKeysUtil = CorrelationKeysUtil.class$("org.apache.ode.bpe.correlation.keys.CorrelationKeysUtil")) : class$org$apache$ode$bpe$correlation$keys$CorrelationKeysUtil).getName());
    static /* synthetic */ Class class$org$apache$ode$bpe$correlation$keys$CorrelationKeysUtil;

    public static boolean hasCorrelationSets(Collection operations) {
        boolean ret = false;
        Iterator opIter = operations.iterator();
        while (opIter.hasNext()) {
            IPMDOperation op = (IPMDOperation)opIter.next();
            IPMDCorrelation correlation = op.getCorrelation();
            if (correlation == null || correlation.getCorrelationSets().isEmpty()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static boolean setCorrelationKeys(ContextResolver resolver, Map parts, Collection operations, String pattern) throws BPException {
        boolean initializedSet = false;
        logger.fine("Trying to Initailize a correlation for set.");
        Iterator opIter = operations.iterator();
        while (opIter.hasNext()) {
            IPMDOperation op = (IPMDOperation)opIter.next();
            IPMDCorrelation correlation = op.getCorrelation();
            if (correlation == null) continue;
            Iterator csIter = correlation.getCorrelationSets().iterator();
            while (csIter.hasNext()) {
                PartQuery pq;
                ContextResolvedObject robj;
                IPMDCorrelationSet cs = (IPMDCorrelationSet)csIter.next();
                if (!cs.isInstantiating() || pattern != null && !cs.getPattern().equals(pattern)) continue;
                Iterator pqsIter = cs.getPartQueries().iterator();
                while (pqsIter.hasNext() && (robj = (ContextResolvedObject)resolver.resolveBPContext((pq = (PartQuery)pqsIter.next()).getLocatorName())).getValue() == null) {
                    initializedSet = true;
                    Object part = parts.get(pq.getPartName());
                    if (part == null) continue;
                    robj.setObject(CorrelationKeysUtil.getPartData(part, pq));
                }
            }
        }
        return initializedSet;
    }

    private static Object getPartData(Object inputObj, PartQuery pq) throws InteractionException, ActionException {
        IInteraction interaction = null;
        if (inputObj instanceof String) {
            String part = (String)inputObj;
            interaction = InteractionFactory.newInstance().createXMLInteraction(part.getBytes());
        } else if (inputObj instanceof IInteraction) {
            interaction = (IInteraction)inputObj;
        } else {
            ActionException bpx = new ActionException("UNKNOWN_DATATYPE", null);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        IInvocation invocation = (IInvocation)pq.getQuery();
        Object resultObject = null;
        resultObject = invocation != null ? interaction.invoke(invocation) : interaction.toString();
        return resultObject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

