/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.correlation.managed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.ode.bpe.correlation.CorrelationService;
import org.apache.ode.bpe.correlation.CorrelationServiceException;
import org.apache.ode.bpe.correlation.Registration;
import org.apache.ode.bpe.correlation.managed.RegistrationEntityLocal;
import org.apache.ode.bpe.correlation.managed.RegistrationEntityLocalHome;
import org.apache.ode.bpe.correlation.managed.RegistrationEntityPK;
import org.apache.ode.bpe.correlation.unmanaged.CorrelationServiceSLImpl;
import org.apache.ode.bpe.engine.ProcessService;
import org.apache.ode.bpe.event.IStaticKey;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;

public class CorrelationServiceEjbImpl
extends CorrelationService {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$correlation$managed$CorrelationServiceEjbImpl == null ? (class$org$apache$ode$bpe$correlation$managed$CorrelationServiceEjbImpl = CorrelationServiceEjbImpl.class$("org.apache.ode.bpe.correlation.managed.CorrelationServiceEjbImpl")) : class$org$apache$ode$bpe$correlation$managed$CorrelationServiceEjbImpl).getName());
    private LinkedList registrationOperations = new LinkedList();
    private LinkedList registrationsForRemoval = new LinkedList();
    private ProcessService ps;
    private boolean isBPELCompliant;
    private RegistrationEntityLocalHome relh;
    public static final String JNDI_RELH_NAME = "java:comp/env/registrationBean";
    private CorrelationServiceSLImpl transientCS = new CorrelationServiceSLImpl();
    static /* synthetic */ Class class$org$apache$ode$bpe$correlation$managed$CorrelationServiceEjbImpl;

    public void createRegistration(Registration registration) throws CorrelationServiceException {
        CreateRegistration cr = new CreateRegistration();
        cr.reg = registration;
        this.registrationOperations.add(cr);
        this.transientCS.createRegistration(registration);
    }

    private void createRegistrationEntity(Registration registration) throws CorrelationServiceException {
        try {
            this.relh.create(registration.getStaticKeyValue(), registration.getRootDefId(), registration.getDefId(), registration.getRootProcId(), registration.getProcId(), registration.getKeyValue(), registration.getOperationId());
        }
        catch (CreateException e) {
            CorrelationServiceException bpx = new CorrelationServiceException("NATIVE_EXCEPTION", new Object[]{"CreateException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
    }

    public Collection getRegistrations(IStaticKey key, Collection keyValues) throws CorrelationServiceException {
        Collection regs = new HashSet();
        Iterator it = keyValues.iterator();
        while (it.hasNext()) {
            Collection beans;
            String keyValue = (String)it.next();
            try {
                beans = keyValue == null ? this.relh.findByStaticKey(((Object)key).toString()) : this.relh.findByStaticKeyandKeyValue(((Object)key).toString(), keyValue);
            }
            catch (FinderException e) {
                CorrelationServiceException bpx = new CorrelationServiceException("NATIVE_EXCEPTION", new Object[]{"FinderException"}, e);
                bpx.log(logger, Level.SEVERE);
                throw bpx;
            }
            Collection regObjs = this.makeRegistrations(((Object)key).toString(), beans);
            Iterator iter = regObjs.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                boolean dup = false;
                Iterator iterator = regs.iterator();
                while (iterator.hasNext()) {
                    Object reg = iterator.next();
                    if (!element.equals(reg)) continue;
                    dup = true;
                    break;
                }
                if (dup) continue;
                regs.add(element);
            }
            regs = this.screenRegs(regs);
            regs.addAll(this.transientCS.getRegistrations(key, keyValues));
        }
        return regs;
    }

    public Collection getRegistrations(IPMIProcess key) throws CorrelationServiceException {
        Collection beans;
        try {
            beans = this.relh.findByProcId(key.getKey());
        }
        catch (FinderException e) {
            CorrelationServiceException bpx = new CorrelationServiceException("NATIVE_EXCEPTION", new Object[]{"FinderException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        Collection regs = this.makeRegistrations(key.getKey(), beans);
        regs = this.screenRegs(regs);
        regs.addAll(this.transientCS.getRegistrations(key));
        return regs;
    }

    public Collection getRegistrations(IStaticKey key) throws CorrelationServiceException {
        Collection beans;
        try {
            beans = this.relh.findByStaticKey(((Object)key).toString());
        }
        catch (FinderException e) {
            CorrelationServiceException bpx = new CorrelationServiceException("NATIVE_EXCEPTION", new Object[]{"FinderException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        Collection regs = this.makeRegistrations(((Object)key).toString(), beans);
        regs = this.screenRegs(regs);
        Collection transientRegs = this.transientCS.getRegistrations(key);
        regs.addAll(transientRegs);
        return regs;
    }

    private Collection screenRegs(Collection regs) {
        LinkedList<Registration> retVal = new LinkedList<Registration>();
        Iterator iter = regs.iterator();
        while (iter.hasNext()) {
            Registration candidate = (Registration)iter.next();
            if (this.registrationsForRemoval.contains(candidate)) continue;
            retVal.add(candidate);
        }
        return retVal;
    }

    private Collection makeRegistrations(String key, Collection beans) {
        ArrayList<Registration> regs = new ArrayList<Registration>();
        Iterator it = beans.iterator();
        while (it.hasNext()) {
            RegistrationEntityLocal bean = (RegistrationEntityLocal)it.next();
            regs.add(new Registration(key, bean.getOperationId(), bean.getRootDefId(), bean.getDefId(), bean.getRootProcId(), bean.getProcId(), bean.getKeyValue()));
        }
        return regs;
    }

    public void update() throws BPException {
    }

    public ProcessService getProcessService() throws BPException {
        return this.ps;
    }

    public boolean isBPELCompliant() {
        return this.isBPELCompliant;
    }

    public void init(BPEProperties props, ProcessService ps) throws CorrelationServiceException {
        this.ps = ps;
        if (props.getBPELCompliant().equals("TRUE")) {
            this.isBPELCompliant = true;
        }
        try {
            InitialContext ic = new InitialContext();
            this.relh = (RegistrationEntityLocalHome)ic.lookup(JNDI_RELH_NAME);
        }
        catch (NamingException ne) {
            CorrelationServiceException bpx = new CorrelationServiceException("NATIVE_EXCEPTION", new Object[]{"NamingException"}, ne);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
    }

    public Registration getRegistration(IStaticKey key, String operationId, String processId) throws CorrelationServiceException {
        Collection beans;
        try {
            beans = this.relh.findByStaticKeyandOpIdandProcId(((Object)key).toString(), operationId, processId);
        }
        catch (FinderException e) {
            CorrelationServiceException bpx = new CorrelationServiceException("NATIVE_EXCEPTION", new Object[]{"FinderException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        Iterator it = this.makeRegistrations(((Object)key).toString(), beans).iterator();
        Registration retVal = null;
        if (it.hasNext() && this.registrationsForRemoval.contains(retVal = (Registration)it.next())) {
            retVal = null;
        }
        if (retVal != null || (retVal = this.transientCS.getRegistration(key, operationId, processId)) != null) {
            // empty if block
        }
        return retVal;
    }

    public void removeRegistration(Registration registration) throws CorrelationServiceException {
        RemoveRegistration rr = new RemoveRegistration();
        rr.reg = registration;
        this.registrationOperations.add(rr);
        this.transientCS.removeRegistration(registration);
        this.registrationsForRemoval.add(registration);
    }

    protected void removeRegistrationEntity(Registration registration) throws CorrelationServiceException {
        try {
            RegistrationEntityPK pk = new RegistrationEntityPK();
            pk.setOperationId(registration.getOperationId());
            pk.setProcId(registration.getProcId());
            pk.setRootDefId(registration.getRootDefId());
            pk.setRootProcId(registration.getRootProcId());
            pk.setStaticKeyValue(registration.getStaticKeyValue());
            RegistrationEntityLocal bean = this.relh.findByPrimaryKey(pk);
            bean.remove();
        }
        catch (ObjectNotFoundException e) {
        }
        catch (FinderException e) {
            logger.log(Level.WARNING, "", e);
        }
        catch (EJBException e) {
            logger.log(Level.WARNING, "", e);
        }
        catch (RemoveException e) {
            logger.log(Level.WARNING, "", e);
        }
    }

    public void persistRegistrationChanges() throws CorrelationServiceException {
        Iterator iter = this.registrationOperations.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof RemoveRegistration) {
                RemoveRegistration rr = (RemoveRegistration)obj;
                this.removeRegistrationEntity(rr.reg);
            }
            if (!(obj instanceof CreateRegistration)) continue;
            CreateRegistration cr = (CreateRegistration)obj;
            this.createRegistrationEntity(cr.reg);
        }
        this.clearState();
    }

    public void clearState() {
        this.registrationsForRemoval.clear();
        this.registrationOperations.clear();
        this.transientCS = new CorrelationServiceSLImpl();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CreateRegistration {
        public Registration reg;

        private CreateRegistration() {
        }
    }

    private class RemoveRegistration {
        public Registration reg;

        private RemoveRegistration() {
        }
    }
}

