/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.event;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.ode.bpe.event.BPELStaticKey;
import org.apache.ode.bpe.event.EventException;
import org.apache.ode.bpe.event.IRequestMessageEvent;
import org.apache.ode.bpe.event.IResponseMessage;
import org.apache.ode.bpe.event.IStaticKey;
import org.apache.ode.bpe.event.NoResponseAllowedException;
import org.apache.ode.bpe.event.OperationMissingException;
import org.apache.ode.bpe.event.SOAPResponseMessage;
import org.apache.ode.bpe.interaction.IInteraction;
import org.apache.ode.bpe.interaction.InteractionFactory;
import org.apache.ode.bpe.util.BPException;

public class SOAPRequestMessageEvent
implements IRequestMessageEvent {
    private SOAPEnvelope m_responseEnvelope;
    private SOAPEnvelope m_requestEnvelope;
    private transient InteractionFactory m_interactionFactory;
    private transient IInteraction m_headerInteraction;
    private transient BPELStaticKey m_staticKey;
    private transient IResponseMessage m_responseMessage;
    private transient boolean m_envelopeParsed;
    private transient HashMap m_messagePartInteractionMap;
    private transient String m_portType;
    private transient String m_operation;
    private transient HashMap m_headerElementInteractionMap;

    public SOAPRequestMessageEvent(SOAPEnvelope iRequestEnvelope, SOAPEnvelope iResponseEnvelope) {
        this.m_requestEnvelope = iRequestEnvelope;
        this.m_responseEnvelope = iResponseEnvelope;
    }

    public Map getParts() {
        return this.m_messagePartInteractionMap;
    }

    private void setMessagePartInteraction(String iPartName, IInteraction iMessagePartInteraction) {
        if (this.m_messagePartInteractionMap == null) {
            this.m_messagePartInteractionMap = new HashMap();
        }
        this.m_messagePartInteractionMap.put(iPartName, iMessagePartInteraction);
    }

    private void setHeaderElementInteraction(String iHeaderElementName, IInteraction iHeaderElementInteraction) {
        if (this.m_headerElementInteractionMap == null) {
            this.m_headerElementInteractionMap = new HashMap();
        }
        this.m_headerElementInteractionMap.put(iHeaderElementName, iHeaderElementInteraction);
    }

    private IInteraction getMessagePartInteraction(String iPartName) {
        return (IInteraction)this.m_messagePartInteractionMap.get(iPartName);
    }

    private String getPortType() throws BPException {
        if (this.m_portType == null) {
            this.marshalFromSOAPEnvelope();
        }
        return this.m_portType;
    }

    private void setPortType(String iPortType) {
        this.m_portType = iPortType;
    }

    private String getOperation() throws BPException {
        if (this.m_operation == null) {
            this.marshalFromSOAPEnvelope();
        }
        return this.m_operation;
    }

    private void setOperation(String iOperation) {
        this.m_operation = iOperation;
    }

    private void marshalFromSOAPEnvelope() throws BPException {
        try {
            if (!this.m_envelopeParsed) {
                this.marshalFromSOAPBody(this.m_requestEnvelope.getBody());
                this.marshalFromSOAPHeader(this.m_requestEnvelope.getHeader());
                this.m_envelopeParsed = true;
            }
        }
        catch (SOAPException soapException) {
            throw new EventException("NATIVE_EXCEPTION", new Object[]{"SOAPException"}, soapException);
        }
    }

    private void marshalFromSOAPBody(SOAPBody iBody) throws BPException {
        Iterator iterator = iBody.getChildElements();
        SOAPElement operationElement = null;
        if (!iterator.hasNext()) {
            throw new OperationMissingException();
        }
        operationElement = (SOAPElement)iterator.next();
        this.setOperation(operationElement.getElementName().getLocalName());
        iterator = operationElement.getChildElements();
        SOAPElement partElement = null;
        while (iterator.hasNext()) {
            partElement = (SOAPElement)iterator.next();
            this.marshalFromMessagePart(partElement);
        }
    }

    private void marshalFromSOAPHeader(SOAPHeader iHeader) throws BPException {
        Iterator iterator = iHeader.getChildElements();
        while (iterator.hasNext()) {
            SOAPElement headerElement = (SOAPElement)iterator.next();
            String localName = headerElement.getElementName().getLocalName();
            if (localName.equals("To")) {
                this.setPortType(headerElement.getValue());
            }
            IInteraction headerElementInteraction = this.createInteraction(headerElement);
            this.setHeaderElementInteraction(localName, headerElementInteraction);
        }
        this.m_headerInteraction = this.createInteraction((SOAPElement)iHeader);
    }

    private void marshalFromMessagePart(SOAPElement iMessagePart) throws BPException {
        String partName = iMessagePart.getElementName().getLocalName();
        IInteraction interaction = this.createInteraction(iMessagePart);
        this.setMessagePartInteraction(partName, interaction);
    }

    private IInteraction createInteraction(SOAPElement iElement) throws BPException {
        MessageElement messageElement = (MessageElement)iElement;
        String elementString = messageElement.toString();
        IInteraction interactionObject = this.getInteractionFactory().createXMLInteraction(elementString.getBytes());
        return interactionObject;
    }

    private InteractionFactory getInteractionFactory() {
        if (this.m_interactionFactory == null) {
            this.m_interactionFactory = InteractionFactory.newInstance();
        }
        return this.m_interactionFactory;
    }

    public IStaticKey getStaticKey() throws BPException {
        this.m_staticKey = new BPELStaticKey();
        this.m_staticKey.setOperation(this.getOperation());
        this.m_staticKey.setPortType(this.getPortType());
        return this.m_staticKey;
    }

    public SOAPEnvelope getSOAPRequestEnvelope() {
        return this.m_requestEnvelope;
    }

    public IInteraction getPart(String iPartName) throws BPException {
        return this.getMessagePartInteraction(iPartName);
    }

    public IInteraction getHeader() {
        return this.m_headerInteraction;
    }

    public IInteraction getHeaderElement(String iHeaderElementName) {
        IInteraction returnInteraction = (IInteraction)this.m_headerElementInteractionMap.get(iHeaderElementName);
        return returnInteraction;
    }

    public IResponseMessage createResponseMessage() throws BPException {
        if (this.m_responseEnvelope == null) {
            throw new NoResponseAllowedException();
        }
        if (this.m_responseMessage == null) {
            this.m_responseMessage = new SOAPResponseMessage((javax.xml.soap.SOAPEnvelope)this.m_responseEnvelope);
        }
        return this.m_responseMessage;
    }
}

