/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.inmemory.jndi;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.InvalidAttributesException;
import javax.resource.spi.ManagedConnectionFactory;

public class IMContext
implements Context {
    private static final String PROPERTY_FILE_NAME_PART = ".properties";
    private static final String RA_MANAGED_CONNECTION_FACTORY_NAME = "RAManagedConnectionFactoryName";
    private static final String RA_PROPERTY_SET_METHOD_PART = "set";
    private static final String RA_CREATE_CONNECTION_FACTORY_METHOD_NAME = "createConnectionFactory";
    private static final String FILE_SEPERATER1 = "\\";
    private static final String FILE_SEPERATER2 = "/";
    private static final String PROPERTY_VALUE_TYPE_PART = "_PROPERTY_VALUE_TYPE";
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$inmemory$jndi$IMContext == null ? (class$org$apache$ode$bpe$inmemory$jndi$IMContext = IMContext.class$("org.apache.ode.bpe.inmemory.jndi.IMContext")) : class$org$apache$ode$bpe$inmemory$jndi$IMContext).getName());
    private static Map managedConnectionFactoryCache = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$apache$ode$bpe$inmemory$jndi$IMContext;
    static /* synthetic */ Class class$java$lang$String;

    public Object lookup(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookup(String name) throws NamingException {
        Object retValue = managedConnectionFactoryCache.get(name);
        if (retValue != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Got cached object for ->" + name);
            }
            return retValue;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Calling IMContext for look up->" + name);
        }
        String fileSeperator = System.getProperty("file.separator");
        int pos = name.lastIndexOf(fileSeperator);
        String raInfoFileName = name;
        if (pos != -1) {
            if (pos + fileSeperator.length() < name.length()) {
                raInfoFileName = name.substring(pos + fileSeperator.length());
            }
        } else if (fileSeperator.equals(FILE_SEPERATER1)) {
            pos = name.lastIndexOf(FILE_SEPERATER2);
            if (pos != -1 && pos + FILE_SEPERATER2.length() < name.length()) {
                raInfoFileName = name.substring(pos + FILE_SEPERATER2.length());
            }
        } else {
            pos = name.lastIndexOf(FILE_SEPERATER1);
            if (pos != -1 && pos + FILE_SEPERATER1.length() < name.length()) {
                raInfoFileName = name.substring(pos + FILE_SEPERATER1.length());
            }
        }
        raInfoFileName = raInfoFileName + PROPERTY_FILE_NAME_PART;
        try {
            Properties props = new Properties();
            IMContext.getProperties(props, raInfoFileName);
            String managedConnectionFactoryName = props.getProperty(RA_MANAGED_CONNECTION_FACTORY_NAME);
            if (managedConnectionFactoryName == null) {
                throw new InvalidAttributesException();
            }
            ((Hashtable)props).remove(RA_MANAGED_CONNECTION_FACTORY_NAME);
            try {
                Class<?> managedConnectionFactoryClass = Class.forName(managedConnectionFactoryName);
                ManagedConnectionFactory managedConnectionFactory = (ManagedConnectionFactory)managedConnectionFactoryClass.newInstance();
                block4: while (((Hashtable)props).size() > 0) {
                    Set keys = ((Hashtable)props).keySet();
                    Iterator iter = keys.iterator();
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        int propertyValueTypePartIndex = key.indexOf(PROPERTY_VALUE_TYPE_PART);
                        if (propertyValueTypePartIndex != -1 && propertyValueTypePartIndex + PROPERTY_VALUE_TYPE_PART.length() == key.length()) continue;
                        String value = props.getProperty(key);
                        ((Hashtable)props).remove(key);
                        String typeKey = key + PROPERTY_VALUE_TYPE_PART;
                        String typeValue = "java.lang.String";
                        if (((Hashtable)props).containsKey(typeKey)) {
                            typeValue = props.getProperty(typeKey);
                            ((Hashtable)props).remove(typeKey);
                        }
                        String methodName = RA_PROPERTY_SET_METHOD_PART + key;
                        Class[] paramsCls = new Class[]{Class.forName(typeValue)};
                        Object[] params = new Object[1];
                        if (typeValue.equals("java.lang.String")) {
                            params[0] = value;
                        } else if (typeValue.equals("java.lang.Boolean")) {
                            params[0] = new Boolean(value);
                        } else if (typeValue.equals("java.lang.Byte")) {
                            params[0] = new Byte(Byte.parseByte(value));
                        } else if (typeValue.equals("java.lang.Character")) {
                            params[0] = value.length() != 0 ? new Character(value.charAt(0)) : null;
                        } else if (typeValue.equals("java.lang.Short")) {
                            params[0] = new Short(Short.parseShort(value));
                        } else if (typeValue.equals("java.lang.Integer")) {
                            params[0] = new Integer(Integer.parseInt(value));
                        } else if (typeValue.equals("java.lang.Long")) {
                            params[0] = new Long(Long.parseLong(value));
                        } else if (typeValue.equals("java.lang.Float")) {
                            params[0] = new Float(Float.parseFloat(value));
                        } else if (typeValue.equals("java.lang.Double")) {
                            params[0] = new Double(Double.parseDouble(value));
                        } else if (typeValue.equals("java.util.Calendar")) {
                            DateFormat df = DateFormat.getTimeInstance();
                            params[0] = df.parse(value);
                        } else {
                            throw new DataFormatException((class$java$lang$String == null ? (class$java$lang$String = IMContext.class$("java.lang.String")) : class$java$lang$String).getName() + "->" + typeValue);
                        }
                        Method method = managedConnectionFactoryClass.getMethod(methodName, paramsCls);
                        method.invoke((Object)managedConnectionFactory, params);
                        continue block4;
                    }
                }
                Class[] paramsCls = new Class[]{};
                Method method = managedConnectionFactoryClass.getMethod(RA_CREATE_CONNECTION_FACTORY_METHOD_NAME, paramsCls);
                Object[] params = new Object[]{};
                retValue = method.invoke((Object)managedConnectionFactory, params);
            }
            catch (Exception e) {
                throw new NamingException(e.getClass().getName() + "->" + e.getLocalizedMessage());
            }
        }
        catch (IOException e) {
            throw new NamingException(e.getClass().getName() + "->" + e.getLocalizedMessage());
        }
        managedConnectionFactoryCache.put(name, retValue);
        return retValue;
    }

    public static void getProperties(Properties props, String fileName) throws IOException {
        String path = System.getProperty("java.naming.provider.url");
        String resource = path == null ? fileName : path + FILE_SEPERATER2 + fileName;
        InputStream strm = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (strm == null) {
            strm = new FileInputStream(fileName);
        }
        props.load(strm);
    }

    public void bind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NameParser getNameParser(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Hashtable getEnvironment() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void close() throws NamingException {
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

