/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.pool;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.pool.ObjPoolObject;
import org.apache.ode.bpe.pool.PoolException;
import org.apache.ode.bpe.pool.SimpleObjPool;

public abstract class MinMaxObjPool
extends SimpleObjPool {
    private int maxPoolSize = -1;
    private int initialPoolSize = 1;
    private int createWaitTime = 0;
    private int growBlock = 1;
    protected Collection pool;
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$pool$MinMaxObjPool == null ? (class$org$apache$ode$bpe$pool$MinMaxObjPool = MinMaxObjPool.class$("org.apache.ode.bpe.pool.MinMaxObjPool")) : class$org$apache$ode$bpe$pool$MinMaxObjPool).getName());
    Set supportedTypes = Collections.synchronizedSet(new HashSet());
    static /* synthetic */ Class class$org$apache$ode$bpe$pool$MinMaxObjPool;

    protected abstract ObjPoolObject getUserIdentifiedObject(Object var1, Object var2, Object var3) throws PoolException;

    public MinMaxObjPool(Collection pool, boolean monitorCheckedOutObjects) throws PoolException {
        super(monitorCheckedOutObjects);
        if (!pool.isEmpty()) {
            PoolException pe = new PoolException("POOL_INIT_1", null);
            pe.log(logger, Level.SEVERE);
            throw pe;
        }
        this.pool = pool;
    }

    public MinMaxObjPool(Collection pool) throws PoolException {
        if (!pool.isEmpty()) {
            PoolException pe = new PoolException("POOL_INIT_1", null);
            pe.log(logger, Level.SEVERE);
            throw pe;
        }
        this.pool = pool;
    }

    public ObjPoolObject checkout(Object factory, Object auth, Object objectSpec) throws PoolException {
        if (!this.supportedTypes.contains(objectSpec)) {
            PoolException pe = new PoolException("POOL_INIT_2", null);
            pe.log(logger, Level.SEVERE);
            throw pe;
        }
        return super.checkout(factory, auth, objectSpec);
    }

    public int getObjPoolSize() {
        return this.pool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentPoolSize() {
        int size = 0;
        Object object = this.sync;
        synchronized (object) {
            size = this.getObjPoolSize() + this.getObjectsInUse();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjPoolObject getNextPoolObject(Object factory, Object auth, Object objSpec) throws PoolException {
        ObjPoolObject ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = this.getUserIdentifiedObject(factory, auth, objSpec);
            if (ret != null) {
                return ret;
            }
            if (this.getCurrentPoolSize() < this.maxPoolSize) {
                int currentPoolSize = this.getCurrentPoolSize();
                for (int i = 1; i < this.growBlock && this.maxPoolSize >= currentPoolSize; ++i) {
                    this.pool.add(this.createObjPoolObject(factory, auth, objSpec));
                    this.doCreateWait();
                }
                return this.createObjPoolObject(factory, auth, objSpec);
            }
            if (this.maxPoolSize == -1) {
                for (int i = 1; i < this.growBlock; ++i) {
                    this.pool.add(this.createObjPoolObject(factory, auth, objSpec));
                    this.doCreateWait();
                }
                return this.createObjPoolObject(factory, auth, objSpec);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxObjPoolSize(int size) throws PoolException {
        Object object = this.sync;
        synchronized (object) {
            if (size < this.getObjectsInUse()) {
                PoolException pe = new PoolException("POOL_ADJ_1", null);
                pe.log(logger, Level.SEVERE);
                throw pe;
            }
            if (size < this.initialPoolSize) {
                PoolException pe = new PoolException("POOL_ADJ_2", null);
                pe.log(logger, Level.SEVERE);
                throw pe;
            }
            if (this.getCurrentPoolSize() - size > 0) {
                PoolException pe = new PoolException("POOL_ADJ_3", null);
                pe.log(logger, Level.SEVERE);
                throw pe;
            }
            this.maxPoolSize = size;
        }
    }

    private void doCreateWait() {
        if (this.createWaitTime > 0) {
            try {
                Thread.sleep(this.createWaitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void init(Properties prop, Object factory, Object auth, Object objSpec) throws PoolException {
        if (!this.pool.isEmpty()) {
            PoolException pe = new PoolException("POOL_INIT_3", null);
            pe.log(logger, Level.SEVERE);
            throw pe;
        }
        String value = prop.getProperty("pool.initialSize");
        if (value != null) {
            this.initialPoolSize = Integer.parseInt(value);
        }
        if ((value = prop.getProperty("pool.maxSize")) != null) {
            this.maxPoolSize = Integer.parseInt(value);
        }
        if ((value = prop.getProperty("pool.growBlock")) != null) {
            this.growBlock = Integer.parseInt(value);
        }
        if ((value = prop.getProperty("pool.createWaitTime")) != null) {
            this.createWaitTime = Integer.parseInt(value);
        }
        for (int i = 0; i < this.initialPoolSize; ++i) {
            this.pool.add(this.createObjPoolObject(factory, auth, objSpec));
        }
        this.supportedTypes.add(objSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reInitializeObjPool(Object factory, Object auth, Object objSpec) throws Exception {
        Object object = this.sync;
        synchronized (object) {
            Iterator it = this.pool.iterator();
            while (it.hasNext()) {
                ObjPoolObject obj = (ObjPoolObject)it.next();
                obj.deleteObjPoolObject();
            }
            this.pool.clear();
            for (int i = 0; i < this.initialPoolSize; ++i) {
                this.pool.add(this.createObjPoolObject(factory, auth, objSpec));
                this.doCreateWait();
            }
        }
        this.supportedTypes.add(objSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void growObjPool(int additionalSize, Object factory, Object auth, Object objSpec) throws Exception {
        Object object = this.sync;
        synchronized (object) {
            this.setMaxObjPoolSize(this.getInitialObjPoolSize() + additionalSize);
            for (int i = 0; i < additionalSize; ++i) {
                this.pool.add(this.createObjPoolObject(factory, auth, objSpec));
                this.doCreateWait();
            }
        }
        this.supportedTypes.add(objSpec);
    }

    public int getInitialObjPoolSize() {
        return this.initialPoolSize;
    }

    public int getMaxObjPoolSize() {
        return this.maxPoolSize;
    }

    public int getObjPoolGrowSize() {
        return this.growBlock;
    }

    public int getCreateWaitTime() {
        return this.createWaitTime;
    }

    public void addSupportedType(Object objectSpec) {
        this.supportedTypes.add(objectSpec);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

