/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.timerservice.quartzimpl;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.event.ITimerEvent;
import org.apache.ode.bpe.timerservice.IBPETimer;
import org.apache.ode.bpe.timerservice.IBPETimerService;
import org.apache.ode.bpe.timerservice.quartzimpl.BPETimerQuartzImpl;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class BPETimerServiceQuartzImpl
implements IBPETimerService {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$timerservice$quartzimpl$BPETimerServiceQuartzImpl == null ? (class$org$apache$ode$bpe$timerservice$quartzimpl$BPETimerServiceQuartzImpl = BPETimerServiceQuartzImpl.class$("org.apache.ode.bpe.timerservice.quartzimpl.BPETimerServiceQuartzImpl")) : class$org$apache$ode$bpe$timerservice$quartzimpl$BPETimerServiceQuartzImpl).getName());
    public static final String TIMER_EVENT = "TIMER_EVENT";
    public static final String PACKAGE = "PACKAGE";
    private String packageName;
    private static Map schedulerMap = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$apache$ode$bpe$timerservice$quartzimpl$BPETimerServiceQuartzImpl;
    static /* synthetic */ Class class$org$apache$ode$bpe$timerservice$quartzimpl$BPETimerJob;

    private IBPETimer schedule(Date date, ITimerEvent timerEvent) throws BPException {
        JobDetail jobDetail = new JobDetail(timerEvent.getProcId() + timerEvent.getDefId(), "DEFAULT", class$org$apache$ode$bpe$timerservice$quartzimpl$BPETimerJob == null ? (class$org$apache$ode$bpe$timerservice$quartzimpl$BPETimerJob = BPETimerServiceQuartzImpl.class$("org.apache.ode.bpe.timerservice.quartzimpl.BPETimerJob")) : class$org$apache$ode$bpe$timerservice$quartzimpl$BPETimerJob);
        SimpleTrigger trigger = new SimpleTrigger(timerEvent.getProcId() + timerEvent.getDefId(), "DEFAULT", date, null, 0, 0L);
        BPETimerQuartzImpl timer = new BPETimerQuartzImpl(timerEvent);
        jobDetail.getJobDataMap().put((Object)TIMER_EVENT, (Object)timer);
        jobDetail.getJobDataMap().put(PACKAGE, this.packageName);
        try {
            BPETimerServiceQuartzImpl.getScheduler().scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            BPException bpx = new BPException("NATIVE_EXCEPTION", new Object[]{"SchedulerException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        return timer;
    }

    public IBPETimer createTimer(long startDuration, ITimerEvent timerEvent) throws BPException {
        long startTime = System.currentTimeMillis() + startDuration;
        return this.schedule(new Date(startTime), timerEvent);
    }

    public IBPETimer createTimer(Date startTime, ITimerEvent timerEvent) throws BPException {
        return this.schedule(startTime, timerEvent);
    }

    public void removeTimer(IBPETimer timer) throws BPException {
        try {
            BPETimerServiceQuartzImpl.getScheduler().unscheduleJob((String)timer.getId(), "DEFAULT");
        }
        catch (SchedulerException e) {
            BPException bpx = new BPException("NATIVE_EXCEPTION", new Object[]{"SchedulerException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
    }

    public void init(BPEProperties props) throws BPException {
        Properties packageProperties = props.getPackageProperties();
        this.packageName = packageProperties.getProperty("PACKAGE_NAME");
    }

    private static Scheduler getScheduler() {
        Scheduler ret = null;
        Thread currThread = Thread.currentThread();
        if (!schedulerMap.containsKey(currThread)) {
            StdSchedulerFactory schedFact = new StdSchedulerFactory();
            try {
                ret = schedFact.getScheduler();
                schedulerMap.put(currThread, ret);
            }
            catch (SchedulerException e) {
                logger.warning(e.getLocalizedMessage());
                schedulerMap.put(currThread, null);
            }
        } else {
            ret = (Scheduler)schedulerMap.get(currThread);
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

