/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.uuid.connector;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.apache.ode.bpe.pool.PoolException;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.uuid.connector.UUIDConnectionFactory;
import org.apache.ode.bpe.uuid.connector.UUIDConnectionManager;
import org.apache.ode.bpe.uuid.connector.UUIDManagedConnection;
import org.apache.ode.bpe.uuid.connector.UUIDResourceException;

public class UUIDManagedConnectionFactory
implements ManagedConnectionFactory {
    static final long serialVersionUID = 8493648046931230724L;
    private PrintWriter logWriter = null;
    private BPEProperties props = new BPEProperties();
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$uuid$connector$UUIDManagedConnectionFactory == null ? (class$org$apache$ode$bpe$uuid$connector$UUIDManagedConnectionFactory = UUIDManagedConnectionFactory.class$("org.apache.ode.bpe.uuid.connector.UUIDManagedConnectionFactory")) : class$org$apache$ode$bpe$uuid$connector$UUIDManagedConnectionFactory).getName());
    static /* synthetic */ Class class$org$apache$ode$bpe$uuid$connector$UUIDManagedConnectionFactory;

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        return new UUIDConnectionFactory(this, connectionManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        UUIDConnectionManager uuidCM = null;
        try {
            uuidCM = new UUIDConnectionManager(this);
        }
        catch (PoolException e) {
            throw new UUIDResourceException(logger, "UUID_POOL_EXCEPTION", null, e);
        }
        return new UUIDConnectionFactory(this, uuidCM);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        return new UUIDManagedConnection(subject, info, this.props);
    }

    public ManagedConnection matchManagedConnections(Set connections, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        ManagedConnection retValue = null;
        Iterator iter = connections.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof UUIDManagedConnection)) continue;
            retValue = (ManagedConnection)obj;
            break;
        }
        return retValue;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public void setUUIDImplClass(String impl) {
        this.props.setUUIDServiceClass(impl);
    }

    public String getUUIDImplClass() {
        return this.props.getUUIDServiceClass();
    }

    public void setUUIDCacheSize(Integer size) {
        this.props.setUUIDCacheSize(size);
    }

    public Integer getUUIDCacheSize() {
        return new Integer(this.props.getUUIDCacheSize());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

