/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bpe.external;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpe.action.external.ActionSystemException;
import org.apache.ode.bpe.action.external.IExternalAction;
import org.apache.ode.bpe.action.external.IURIResolver;
import org.apache.ode.bpe.client.IFormattableValue;
import org.apache.ode.bpe.interaction.spiimpl.document.DocumentFormattableValue;
import org.apache.ode.bpe.scope.service.BPRuntimeException;
import org.apache.servicemix.bpe.BPEComponent;
import org.apache.servicemix.bpe.BPEEndpoint;
import org.apache.servicemix.bpe.BPELifeCycle;
import org.apache.servicemix.bpe.BPEServiceUnit;
import org.apache.servicemix.jbi.jaxp.BytesSource;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JbiInvokeAction
implements IExternalAction {
    public static final String INTERFACE_NAMESPACE = "interfaceNamespace";
    public static final String INTERFACE_LOCALNAME = "interfaceLocalName";
    public static final String OPERATION_NAMESPACE = "operationNamespace";
    public static final String OPERATION_LOCALNAME = "operationLocalName";
    public static final String SERVICE_NAMESPACE = "serviceNamespace";
    public static final String SERVICE_LOCALNAME = "serviceLocalName";
    public static final String ENDPOINT_NAME = "endpointName";
    public static final String ACTION = "action";
    public static final String ENDPOINT = "endpoint";
    public static final String MEP = "mep";
    private static Log log = LogFactory.getLog((Class)(class$org$apache$servicemix$bpe$external$JbiInvokeAction == null ? (class$org$apache$servicemix$bpe$external$JbiInvokeAction = JbiInvokeAction.class$("org.apache.servicemix.bpe.external.JbiInvokeAction")) : class$org$apache$servicemix$bpe$external$JbiInvokeAction));
    private Properties properties;
    private QName interfaceName;
    private QName serviceName;
    private String endpointName;
    private QName operationName;
    private String inputPartName = BPEComponent.PART_PAYLOAD;
    private String outputPartName = BPEComponent.PART_PAYLOAD;
    private URI mep;
    private SourceTransformer transformer = new SourceTransformer();
    private Operation wsdlOperation;
    private static final long serialVersionUID = -8522450752525724302L;
    static /* synthetic */ Class class$org$apache$servicemix$bpe$external$JbiInvokeAction;
    static /* synthetic */ Class class$org$w3c$dom$Document;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;

    public void init(Properties props) throws BPRuntimeException, ActionSystemException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"init");
        }
        this.properties = props;
        this.extractInformations();
        if (this.serviceName == null && this.interfaceName == null) {
            throw new BPRuntimeException("Interface, Service or Endpoint should be specified", "");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("properties: " + props));
        }
    }

    protected void extractInformations() {
        String action = this.properties.getProperty(ACTION);
        if (action != null) {
            String[] parts = this.split(action);
            this.interfaceName = new QName(parts[0], parts[1]);
            this.operationName = new QName(parts[0], parts[2]);
        } else {
            String interfaceNamespace = this.properties.getProperty(INTERFACE_NAMESPACE);
            String interfaceLocalName = this.properties.getProperty(INTERFACE_LOCALNAME);
            if (interfaceLocalName != null) {
                this.interfaceName = new QName(interfaceNamespace, interfaceLocalName);
            }
            String operationNamespace = this.properties.getProperty(OPERATION_NAMESPACE);
            String operationLocalName = this.properties.getProperty(OPERATION_LOCALNAME);
            if (operationLocalName != null) {
                this.operationName = new QName(operationNamespace, operationLocalName);
            }
        }
        String endpoint = this.properties.getProperty(ENDPOINT);
        if (endpoint != null) {
            String[] parts = this.split(action);
            this.serviceName = new QName(parts[0], parts[1]);
            this.endpointName = parts[2];
        } else {
            String serviceNamespace = this.properties.getProperty(SERVICE_NAMESPACE);
            String serviceLocalName = this.properties.getProperty(SERVICE_LOCALNAME);
            if (serviceLocalName != null) {
                this.serviceName = new QName(serviceNamespace, serviceLocalName);
            }
            this.endpointName = this.properties.getProperty(ENDPOINT_NAME);
        }
        String mep = this.properties.getProperty(MEP);
        if (mep == null) {
            Operation oper;
            BPEEndpoint ep = BPEEndpoint.getCurrent();
            Definition def = ((BPEServiceUnit)ep.getServiceUnit()).getDefinition();
            PortType pt = def.getPortType(this.interfaceName);
            Operation operation = oper = pt != null ? pt.getOperation(this.operationName.getLocalPart(), null, null) : null;
            if (oper != null) {
                Map parts;
                boolean faults;
                boolean output = oper.getOutput() != null && oper.getOutput().getMessage() != null && oper.getOutput().getMessage().getParts().size() > 0;
                boolean bl = faults = oper.getFaults().size() > 0;
                mep = output ? "in-out" : (faults ? "robust-in-only" : "in-only");
                if (oper.getInput() != null && oper.getInput().getMessage() != null) {
                    parts = oper.getInput().getMessage().getParts();
                    this.inputPartName = (String)parts.keySet().iterator().next();
                }
                if (oper.getOutput() != null && oper.getOutput().getMessage() != null) {
                    parts = oper.getOutput().getMessage().getParts();
                    this.outputPartName = (String)parts.keySet().iterator().next();
                }
                this.wsdlOperation = oper;
            }
        }
        if (mep == null) {
            mep = "in-out";
        }
        this.mep = URI.create("http://www.w3.org/2004/08/wsdl/" + mep);
    }

    public void execute(HashMap input, HashMap output, IURIResolver resolver) throws BPRuntimeException, ActionSystemException {
        Object payload;
        block22: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"execute");
            }
            payload = input.get(this.inputPartName);
            Source inputSource = this.getSourceFromPayload(payload);
            try {
                BPEEndpoint endpoint = BPEEndpoint.getCurrent();
                BPEComponent component = (BPEComponent)endpoint.getServiceUnit().getComponent();
                DeliveryChannel channel = ((BPELifeCycle)component.getLifeCycle()).getContext().getDeliveryChannel();
                MessageExchangeFactory factory = channel.createExchangeFactory();
                MessageExchange me = factory.createExchange(this.mep);
                me.setInterfaceName(this.interfaceName);
                me.setService(this.serviceName);
                me.setOperation(this.operationName);
                NormalizedMessage nm = me.createMessage();
                me.setMessage(nm, "in");
                nm.setContent(inputSource);
                boolean res = channel.sendSync(me);
                if (!res) {
                    throw new ActionSystemException("Timeout on sending message");
                }
                if (me.getStatus() == ExchangeStatus.ACTIVE) {
                    if (me.getFault() != null) {
                        Document fault;
                        try {
                            fault = this.transformer.toDOMDocument((NormalizedMessage)me.getFault());
                            me.setStatus(ExchangeStatus.DONE);
                        }
                        catch (Exception e) {
                            me.setError(e);
                            throw new ActionSystemException((Throwable)e);
                        }
                        finally {
                            channel.send(me);
                        }
                        Element e = fault.getDocumentElement();
                        String faultName = e.getLocalName();
                        String partName = BPEComponent.PART_PAYLOAD;
                        QName elemName = new QName(e.getNamespaceURI(), e.getLocalName());
                        if (this.wsdlOperation != null) {
                            Iterator itFault = this.wsdlOperation.getFaults().values().iterator();
                            while (itFault.hasNext()) {
                                Fault f = (Fault)itFault.next();
                                Part p = (Part)f.getMessage().getParts().values().iterator().next();
                                if (!elemName.equals(p.getTypeName())) continue;
                                faultName = f.getName();
                                partName = p.getName();
                            }
                        }
                        BPRuntimeException bpre = new BPRuntimeException(faultName, "");
                        bpre.setNameSpace(e.getNamespaceURI());
                        DocumentFormattableValue documentFormattableValue = new DocumentFormattableValue(fault);
                        bpre.addPartMessage(partName, (Object)documentFormattableValue);
                        throw bpre;
                    }
                    try {
                        nm = me.getMessage("out");
                        if (nm != null) {
                            Document out = this.transformer.toDOMDocument(nm);
                            DocumentFormattableValue documentFormattableValue = new DocumentFormattableValue(out);
                            output.put(this.outputPartName, documentFormattableValue);
                        }
                        me.setStatus(ExchangeStatus.DONE);
                        break block22;
                    }
                    catch (Exception e) {
                        me.setError(e);
                        throw new ActionSystemException((Throwable)e);
                    }
                    finally {
                        channel.send(me);
                    }
                }
                if (me.getStatus() == ExchangeStatus.ERROR) {
                    Exception error = me.getError();
                    throw new BPRuntimeException("Unknown", (Throwable)error);
                }
            }
            catch (MessagingException e) {
                throw new ActionSystemException((Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request: " + payload));
            log.debug((Object)("Response: " + output.get(this.outputPartName)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Source getSourceFromPayload(Object payload) {
        if (payload instanceof IFormattableValue) {
            IFormattableValue value = (IFormattableValue)payload;
            if (value.supportsGetValueAs(class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = JbiInvokeAction.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document)) {
                Document doc = (Document)value.getValueAs(class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = JbiInvokeAction.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document);
                return new DOMSource(doc);
            }
            if (value.supportsGetValueAs(array$B == null ? (array$B = JbiInvokeAction.class$("[B")) : array$B)) {
                byte[] data = (byte[])value.getValueAs(array$B == null ? (array$B = JbiInvokeAction.class$("[B")) : array$B);
                return new BytesSource(data);
            }
            if (!value.supportsGetValueAs(class$java$lang$String == null ? (class$java$lang$String = JbiInvokeAction.class$("java.lang.String")) : class$java$lang$String)) throw new UnsupportedOperationException("Unable to retrieve value");
            String data = (String)value.getValueAs(class$java$lang$String == null ? (class$java$lang$String = JbiInvokeAction.class$("java.lang.String")) : class$java$lang$String);
            return new StringSource(data);
        }
        if (payload instanceof Document) {
            return new DOMSource((Document)payload);
        }
        if (payload instanceof byte[]) {
            return new BytesSource((byte[])payload);
        }
        if (!(payload instanceof String)) throw new UnsupportedOperationException("Unable to retrieve value");
        return new StringSource((String)payload);
    }

    public void release() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"release");
        }
    }

    public void process(MessageExchange exchange) throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    protected String[] split(String uri) {
        int sep = uri.indexOf(47) > 0 ? 47 : 58;
        int idx1 = uri.lastIndexOf(sep);
        int idx2 = uri.lastIndexOf(sep, idx1 - 1);
        String epName = uri.substring(idx1 + 1);
        String svcName = uri.substring(idx2 + 1, idx1);
        String nsUri = uri.substring(0, idx2);
        return new String[]{nsUri, svcName, epName};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

