/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bpe;

import com.ibm.wsdl.extensions.PopulatedExtensionRegistry;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jbi.management.DeploymentException;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import org.apache.ode.bpe.bped.DeployTypeEnum;
import org.apache.ode.bpe.bped.EventDirector;
import org.apache.ode.bpe.bped.IDeployer;
import org.apache.ode.bpe.deployment.bpel.BPELDefinitionKey;
import org.apache.ode.bpe.wsdl.extensions.BPEActionSerializer;
import org.apache.ode.bpe.wsdl.extensions.BPEFaultSerializer;
import org.apache.ode.bpe.wsdl.extensions.BPEInputSerializer;
import org.apache.ode.bpe.wsdl.extensions.BPELPropertyAliasSerializer;
import org.apache.ode.bpe.wsdl.extensions.BPELPropertySerializer;
import org.apache.ode.bpe.wsdl.extensions.BPEOutputSerializer;
import org.apache.ode.bpe.wsdl.extensions.BPEVariableMapSerializer;
import org.apache.ode.bpe.wsdl.extensions.ExtentionConstants;
import org.apache.servicemix.bpe.BPEComponent;
import org.apache.servicemix.bpe.BPEEndpoint;
import org.apache.servicemix.bpe.BPEServiceUnit;
import org.apache.servicemix.bpe.util.FileSystemJarInputStream;
import org.apache.servicemix.common.AbstractDeployer;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.tools.wsdl.WSDLFlattener;
import org.w3c.dom.Document;

public class BPEDeployer
extends AbstractDeployer {
    protected FilenameFilter filter = new BpelFilter();
    static /* synthetic */ Class class$javax$wsdl$Definition;
    static /* synthetic */ Class class$org$apache$ode$bpe$wsdl$extensions$BPELProperty;
    static /* synthetic */ Class class$org$apache$ode$bpe$wsdl$extensions$BPELPropertyAlias;
    static /* synthetic */ Class class$javax$wsdl$BindingOperation;
    static /* synthetic */ Class class$org$apache$ode$bpe$wsdl$extensions$BPEAction;
    static /* synthetic */ Class class$javax$wsdl$BindingInput;
    static /* synthetic */ Class class$org$apache$ode$bpe$wsdl$extensions$BPEInput;
    static /* synthetic */ Class class$javax$wsdl$BindingOutput;
    static /* synthetic */ Class class$org$apache$ode$bpe$wsdl$extensions$BPEOutput;
    static /* synthetic */ Class class$javax$wsdl$BindingFault;
    static /* synthetic */ Class class$org$apache$ode$bpe$wsdl$extensions$BPEFault;
    static /* synthetic */ Class class$org$apache$ode$bpe$wsdl$extensions$BPEVariableMap;

    public BPEDeployer(BPEComponent component) {
        super((ServiceMixComponent)component);
    }

    public boolean canDeploy(String serviceUnitName, String serviceUnitRootPath) {
        File[] bpels = new File(serviceUnitRootPath).listFiles(this.filter);
        return bpels != null && bpels.length == 1;
    }

    public ServiceUnit deploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        try {
            EventDirector ed = ((BPEComponent)this.component).getEventDirector();
            IDeployer deployer = ed.getDeployer(DeployTypeEnum.BPEL);
            Collection defKeys = deployer.loadDefinition((InputStream)new FileSystemJarInputStream(new File(serviceUnitRootPath)), false);
            BPEServiceUnit su = new BPEServiceUnit();
            su.setComponent(this.component);
            su.setName(serviceUnitName);
            su.setRootPath(serviceUnitRootPath);
            su.setDefinitionKeys(defKeys);
            Definition rootDef = this.loadMainWsdl(serviceUnitRootPath);
            this.checkDefinition(rootDef, true);
            su.setDefinition(rootDef);
            WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
            WSDLFlattener flattener = new WSDLFlattener(rootDef);
            Iterator it = rootDef.getServices().values().iterator();
            while (it.hasNext()) {
                Service svc = (Service)it.next();
                Iterator it2 = svc.getPorts().values().iterator();
                while (it2.hasNext()) {
                    Port pt = (Port)it2.next();
                    BPEEndpoint ep = new BPEEndpoint();
                    ep.setServiceUnit(su);
                    ep.setInterfaceName(pt.getBinding().getPortType().getQName());
                    ep.setService(svc.getQName());
                    ep.setEndpoint(pt.getName());
                    Definition def = flattener.getDefinition(ep.getInterfaceName());
                    Document desc = writer.getDocument(def);
                    ep.setDefinition(def);
                    ep.setDescription(desc);
                    this.validate(ep);
                    su.addEndpoint(ep);
                }
            }
            return su;
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public void undeploy(ServiceUnit su) throws DeploymentException {
        try {
            BPEServiceUnit bpeSU = (BPEServiceUnit)su;
            EventDirector ed = ((BPEComponent)this.component).getEventDirector();
            IDeployer deployer = ed.getDeployer(DeployTypeEnum.BPEL);
            Iterator i = bpeSU.getDefinitionKeys().iterator();
            while (i.hasNext()) {
                deployer.removeDefinition(((BPELDefinitionKey)i.next()).getKey());
            }
            su.shutDown();
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    protected void checkDefinition(Definition rootDef, boolean main) throws DeploymentException {
        Collection msgs = rootDef.getMessages().values();
        Iterator iter = msgs.iterator();
        while (iter.hasNext()) {
            Message msg = (Message)iter.next();
            if (msg.isUndefined()) {
                throw this.failure("deploy", "WSDL Message '" + msg.getQName() + "' is undefined. Check namespaces.", null);
            }
            if (msg.getParts().size() <= 1) continue;
            throw this.failure("deploy", "WSDL Message '" + msg.getQName() + "' has more than one part", null);
        }
        Collection imports = rootDef.getImports().values();
        Iterator iter2 = imports.iterator();
        while (iter2.hasNext()) {
            List imps = (List)iter2.next();
            Iterator iterator = imps.iterator();
            while (iterator.hasNext()) {
                Import imp = (Import)iterator.next();
                this.checkDefinition(imp.getDefinition(), false);
            }
        }
    }

    private Definition loadMainWsdl(String serviceUnitRootPath) throws WSDLException {
        File[] bpels = new File(serviceUnitRootPath).listFiles(this.filter);
        String bpel = bpels[0].getAbsoluteFile().toURI().toString();
        String wsdl = bpel.substring(0, bpel.length() - 4) + "wsdl";
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setExtensionRegistry(this.getExtentionRegistry());
        Definition ret = reader.readWSDL(null, wsdl);
        return ret;
    }

    private ExtensionRegistry getExtentionRegistry() {
        PopulatedExtensionRegistry er = new PopulatedExtensionRegistry();
        BPELPropertySerializer bpelPropSerializer = new BPELPropertySerializer();
        BPELPropertyAliasSerializer bpelPropAliasSerializer = new BPELPropertyAliasSerializer();
        BPEActionSerializer bpeActionSerializer = new BPEActionSerializer();
        BPEInputSerializer bpeInputSerializer = new BPEInputSerializer();
        BPEOutputSerializer bpeOutputSerializer = new BPEOutputSerializer();
        BPEFaultSerializer bpeFaultSerializer = new BPEFaultSerializer();
        BPEVariableMapSerializer bpeVariableSerializer = new BPEVariableMapSerializer();
        er.registerSerializer(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = BPEDeployer.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPEL_PROPERTY, (ExtensionSerializer)bpelPropSerializer);
        er.registerDeserializer(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = BPEDeployer.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPEL_PROPERTY, (ExtensionDeserializer)bpelPropSerializer);
        er.mapExtensionTypes(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = BPEDeployer.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPEL_PROPERTY, class$org$apache$ode$bpe$wsdl$extensions$BPELProperty == null ? (class$org$apache$ode$bpe$wsdl$extensions$BPELProperty = BPEDeployer.class$("org.apache.ode.bpe.wsdl.extensions.BPELProperty")) : class$org$apache$ode$bpe$wsdl$extensions$BPELProperty);
        er.registerSerializer(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = BPEDeployer.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPEL_PROPERTY_ALIAS, (ExtensionSerializer)bpelPropAliasSerializer);
        er.registerDeserializer(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = BPEDeployer.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPEL_PROPERTY_ALIAS, (ExtensionDeserializer)bpelPropAliasSerializer);
        er.mapExtensionTypes(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = BPEDeployer.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPEL_PROPERTY_ALIAS, class$org$apache$ode$bpe$wsdl$extensions$BPELPropertyAlias == null ? (class$org$apache$ode$bpe$wsdl$extensions$BPELPropertyAlias = BPEDeployer.class$("org.apache.ode.bpe.wsdl.extensions.BPELPropertyAlias")) : class$org$apache$ode$bpe$wsdl$extensions$BPELPropertyAlias);
        er.registerSerializer(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = BPEDeployer.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, ExtentionConstants.Q_ELEM_BPE_ACTION, (ExtensionSerializer)bpeActionSerializer);
        er.registerDeserializer(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = BPEDeployer.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, ExtentionConstants.Q_ELEM_BPE_ACTION, (ExtensionDeserializer)bpeActionSerializer);
        er.mapExtensionTypes(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = BPEDeployer.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, ExtentionConstants.Q_ELEM_BPE_ACTION, class$org$apache$ode$bpe$wsdl$extensions$BPEAction == null ? (class$org$apache$ode$bpe$wsdl$extensions$BPEAction = BPEDeployer.class$("org.apache.ode.bpe.wsdl.extensions.BPEAction")) : class$org$apache$ode$bpe$wsdl$extensions$BPEAction);
        er.registerSerializer(class$javax$wsdl$BindingInput == null ? (class$javax$wsdl$BindingInput = BPEDeployer.class$("javax.wsdl.BindingInput")) : class$javax$wsdl$BindingInput, ExtentionConstants.Q_ELEM_BPE_INPUT, (ExtensionSerializer)bpeInputSerializer);
        er.registerDeserializer(class$javax$wsdl$BindingInput == null ? (class$javax$wsdl$BindingInput = BPEDeployer.class$("javax.wsdl.BindingInput")) : class$javax$wsdl$BindingInput, ExtentionConstants.Q_ELEM_BPE_INPUT, (ExtensionDeserializer)bpeInputSerializer);
        er.mapExtensionTypes(class$javax$wsdl$BindingInput == null ? (class$javax$wsdl$BindingInput = BPEDeployer.class$("javax.wsdl.BindingInput")) : class$javax$wsdl$BindingInput, ExtentionConstants.Q_ELEM_BPE_INPUT, class$org$apache$ode$bpe$wsdl$extensions$BPEInput == null ? (class$org$apache$ode$bpe$wsdl$extensions$BPEInput = BPEDeployer.class$("org.apache.ode.bpe.wsdl.extensions.BPEInput")) : class$org$apache$ode$bpe$wsdl$extensions$BPEInput);
        er.registerSerializer(class$javax$wsdl$BindingOutput == null ? (class$javax$wsdl$BindingOutput = BPEDeployer.class$("javax.wsdl.BindingOutput")) : class$javax$wsdl$BindingOutput, ExtentionConstants.Q_ELEM_BPE_OUTPUT, (ExtensionSerializer)bpeOutputSerializer);
        er.registerDeserializer(class$javax$wsdl$BindingOutput == null ? (class$javax$wsdl$BindingOutput = BPEDeployer.class$("javax.wsdl.BindingOutput")) : class$javax$wsdl$BindingOutput, ExtentionConstants.Q_ELEM_BPE_OUTPUT, (ExtensionDeserializer)bpeOutputSerializer);
        er.mapExtensionTypes(class$javax$wsdl$BindingOutput == null ? (class$javax$wsdl$BindingOutput = BPEDeployer.class$("javax.wsdl.BindingOutput")) : class$javax$wsdl$BindingOutput, ExtentionConstants.Q_ELEM_BPE_OUTPUT, class$org$apache$ode$bpe$wsdl$extensions$BPEOutput == null ? (class$org$apache$ode$bpe$wsdl$extensions$BPEOutput = BPEDeployer.class$("org.apache.ode.bpe.wsdl.extensions.BPEOutput")) : class$org$apache$ode$bpe$wsdl$extensions$BPEOutput);
        er.registerSerializer(class$javax$wsdl$BindingFault == null ? (class$javax$wsdl$BindingFault = BPEDeployer.class$("javax.wsdl.BindingFault")) : class$javax$wsdl$BindingFault, ExtentionConstants.Q_ELEM_BPE_FAULT, (ExtensionSerializer)bpeFaultSerializer);
        er.registerDeserializer(class$javax$wsdl$BindingFault == null ? (class$javax$wsdl$BindingFault = BPEDeployer.class$("javax.wsdl.BindingFault")) : class$javax$wsdl$BindingFault, ExtentionConstants.Q_ELEM_BPE_FAULT, (ExtensionDeserializer)bpeFaultSerializer);
        er.mapExtensionTypes(class$javax$wsdl$BindingFault == null ? (class$javax$wsdl$BindingFault = BPEDeployer.class$("javax.wsdl.BindingFault")) : class$javax$wsdl$BindingFault, ExtentionConstants.Q_ELEM_BPE_FAULT, class$org$apache$ode$bpe$wsdl$extensions$BPEFault == null ? (class$org$apache$ode$bpe$wsdl$extensions$BPEFault = BPEDeployer.class$("org.apache.ode.bpe.wsdl.extensions.BPEFault")) : class$org$apache$ode$bpe$wsdl$extensions$BPEFault);
        er.registerSerializer(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = BPEDeployer.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPE_VAR, (ExtensionSerializer)bpeVariableSerializer);
        er.registerDeserializer(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = BPEDeployer.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPE_VAR, (ExtensionDeserializer)bpeVariableSerializer);
        er.mapExtensionTypes(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = BPEDeployer.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, ExtentionConstants.Q_ELEM_BPE_VAR, class$org$apache$ode$bpe$wsdl$extensions$BPEVariableMap == null ? (class$org$apache$ode$bpe$wsdl$extensions$BPEVariableMap = BPEDeployer.class$("org.apache.ode.bpe.wsdl.extensions.BPEVariableMap")) : class$org$apache$ode$bpe$wsdl$extensions$BPEVariableMap);
        return er;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class BpelFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith(".bpel");
        }
    }
}

