/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bpe;

import java.util.Map;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.ode.bpe.bped.EventDirector;
import org.apache.ode.bpe.client.IFormattableValue;
import org.apache.ode.bpe.event.BPELStaticKey;
import org.apache.ode.bpe.event.IRequestMessageEvent;
import org.apache.ode.bpe.event.IResponseMessage;
import org.apache.ode.bpe.event.IStaticKey;
import org.apache.ode.bpe.event.SimpleRequestMessageEvent;
import org.apache.ode.bpe.interaction.IInteraction;
import org.apache.ode.bpe.interaction.InteractionException;
import org.apache.ode.bpe.interaction.InvocationFactory;
import org.apache.ode.bpe.interaction.XMLInteractionObject;
import org.apache.ode.bpe.scope.service.BPRuntimeException;
import org.apache.servicemix.bpe.BPEComponent;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ExchangeProcessor;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.w3c.dom.Document;

public class BPEEndpoint
extends Endpoint
implements ExchangeProcessor {
    protected ServiceEndpoint activated;
    protected DeliveryChannel channel;
    protected SourceTransformer transformer = new SourceTransformer();
    private static final ThreadLocal ENDPOINT = new ThreadLocal();
    static /* synthetic */ Class class$org$w3c$dom$Document;

    public static BPEEndpoint getCurrent() {
        return (BPEEndpoint)((Object)ENDPOINT.get());
    }

    public static void setCurrent(BPEEndpoint endpoint) {
        ENDPOINT.set(endpoint);
    }

    public MessageExchange.Role getRole() {
        return MessageExchange.Role.PROVIDER;
    }

    public void activate() throws Exception {
        this.logger = this.serviceUnit.getComponent().getLogger();
        ComponentContext ctx = this.serviceUnit.getComponent().getComponentContext();
        this.activated = ctx.activateEndpoint(this.service, this.endpoint);
        this.channel = ctx.getDeliveryChannel();
    }

    public void deactivate() throws Exception {
        ServiceEndpoint ep = this.activated;
        this.activated = null;
        ComponentContext ctx = this.serviceUnit.getComponent().getComponentContext();
        ctx.deactivateEndpoint(ep);
    }

    public ExchangeProcessor getProcessor() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        block26: {
            if (exchange.getStatus() == ExchangeStatus.DONE) {
                return;
            }
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                return;
            }
            String inputPartName = BPEComponent.PART_PAYLOAD;
            String outputPartName = BPEComponent.PART_PAYLOAD;
            if (exchange.getOperation() != null) {
                Map parts;
                PortType pt = this.getDefinition().getPortType(this.getInterfaceName());
                Operation oper = pt.getOperation(exchange.getOperation().getLocalPart(), null, null);
                if (oper.getInput() != null && oper.getInput().getMessage() != null) {
                    parts = oper.getInput().getMessage().getParts();
                    inputPartName = (String)parts.keySet().iterator().next();
                }
                if (oper.getOutput() != null && oper.getOutput().getMessage() != null) {
                    parts = oper.getOutput().getMessage().getParts();
                    outputPartName = (String)parts.keySet().iterator().next();
                }
            }
            BPELStaticKey bsk = new BPELStaticKey();
            bsk.setTargetNamespace(this.getInterfaceName().getNamespaceURI());
            bsk.setPortType(this.getInterfaceName().getLocalPart());
            if (exchange.getOperation() != null) {
                bsk.setOperation(exchange.getOperation().getLocalPart());
            }
            SimpleRequestMessageEvent msg = new SimpleRequestMessageEvent();
            msg.setStaticKey((IStaticKey)bsk);
            XMLInteractionObject interaction = new XMLInteractionObject();
            interaction.setDocument(this.transformer.toDOMDocument(exchange.getMessage("in")));
            msg.setPart(inputPartName, (IInteraction)interaction);
            EventDirector ed = ((BPEComponent)this.getServiceUnit().getComponent()).getEventDirector();
            try {
                IResponseMessage response;
                try {
                    BPEEndpoint.setCurrent(this);
                    response = ed.sendEvent((IRequestMessageEvent)msg, true);
                }
                finally {
                    BPEEndpoint.setCurrent(null);
                }
                IInteraction payload = response.getPart(outputPartName);
                if (response.getFault() != null) {
                    Exception e = response.getFault().getFaultException();
                    if (e != null) {
                        throw e;
                    }
                    throw new BPRuntimeException(response.getFault().getFaultString(), "");
                }
                if (exchange instanceof InOnly || exchange instanceof RobustInOnly) {
                    if (payload != null) {
                        throw new UnsupportedOperationException("Did not expect return value for in-only or robust-in-only");
                    }
                    exchange.setStatus(ExchangeStatus.DONE);
                    this.channel.send(exchange);
                    break block26;
                }
                if (exchange instanceof InOptionalOut) {
                    if (payload == null) {
                        exchange.setStatus(ExchangeStatus.DONE);
                        this.channel.send(exchange);
                    } else {
                        NormalizedMessage out = exchange.createMessage();
                        out.setContent((Source)new DOMSource(this.getDocument(payload)));
                        exchange.setMessage(out, "out");
                        this.channel.send(exchange);
                    }
                    break block26;
                }
                if (exchange instanceof InOut) {
                    if (payload == null) {
                        throw new UnsupportedOperationException("Expected return data for in-out");
                    }
                    NormalizedMessage out = exchange.createMessage();
                    out.setContent((Source)new DOMSource(this.getDocument(payload)));
                    exchange.setMessage(out, "out");
                    this.channel.send(exchange);
                    break block26;
                }
                throw new UnsupportedOperationException("Unhandled mep: " + exchange.getPattern());
            }
            catch (BPRuntimeException e) {
                Object payload;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Exception caught", (Throwable)e);
                }
                if ((payload = e.getPartMessage(BPEComponent.PART_PAYLOAD)) instanceof IInteraction) {
                    Fault fault = exchange.createFault();
                    fault.setContent((Source)new DOMSource(this.getDocument((IInteraction)payload)));
                    exchange.setFault(fault);
                } else if (payload instanceof IFormattableValue) {
                    Fault fault = exchange.createFault();
                    Document doc = (Document)((IFormattableValue)payload).getValueAs(class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = BPEEndpoint.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document);
                    fault.setContent((Source)new DOMSource(doc));
                    exchange.setFault(fault);
                } else {
                    exchange.setError((Exception)((Object)e));
                }
                this.channel.send(exchange);
            }
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    protected Document getDocument(IInteraction interaction) throws InteractionException {
        Object obj = interaction.invoke(InvocationFactory.newInstance().createGetObjectInvocation());
        if (obj instanceof Document) {
            return (Document)obj;
        }
        if (obj instanceof IFormattableValue) {
            return (Document)((IFormattableValue)obj).getValueAs(class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = BPEEndpoint.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document);
        }
        throw new IllegalStateException("Unable to handle object of type: " + obj.getClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

